/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server.monitor;

import mondrian.server.Locus;
import mondrian.server.Statement;
import mondrian.server.monitor.Event;

public abstract class SqlStatementEvent
extends Event {
    public final long sqlStatementId;
    public final Locus locus;
    public final String sql;
    public final Purpose purpose;

    public SqlStatementEvent(long timestamp, long sqlStatementId, Locus locus, String sql, Purpose purpose) {
        super(timestamp);
        assert (locus != null);
        assert (sql != null);
        assert (purpose != null);
        this.locus = locus;
        this.sqlStatementId = sqlStatementId;
        this.sql = sql;
        this.purpose = purpose;
    }

    public long getStatementId() {
        Statement mondrianStatement;
        if (this.locus.execution != null && (mondrianStatement = this.locus.execution.getMondrianStatement()) != null) {
            return mondrianStatement.getId();
        }
        return -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Purpose {
        DRILL_THROUGH,
        CELL_SEGMENT,
        TUPLES,
        OTHER;

    }
}

