/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import mondrian.olap.Id;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;

class ChildByNameConstraint
extends DefaultMemberChildrenConstraint {
    private final String childName;
    private final Object cacheKey;

    public ChildByNameConstraint(Id.NameSegment childName) {
        this.childName = childName.name;
        this.cacheKey = Arrays.asList(ChildByNameConstraint.class, childName);
    }

    public int hashCode() {
        return this.getCacheKey().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChildByNameConstraint && this.getCacheKey().equals(((ChildByNameConstraint)obj).getCacheKey());
    }

    public void addLevelConstraint(SqlQuery query, RolapCube baseCube, AggStar aggStar, RolapLevel level) {
        super.addLevelConstraint(query, baseCube, aggStar, level);
        query.addWhere(SqlConstraintUtils.constrainLevel(level, query, baseCube, aggStar, this.childName, true));
    }

    public String toString() {
        return "ChildByNameConstraint(" + this.childName + ")";
    }

    public Object getCacheKey() {
        return this.cacheKey;
    }
}

