/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.storage;

import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.storage.StorageEntry;
import org.pentaho.cdf.utils.JsonUtil;
import org.pentaho.cdf.utils.PluginHibernateUtil;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IBasicFile;

public class StorageEngine {
    private static final Log logger = LogFactory.getLog(StorageEngine.class);
    private static StorageEngine instance;

    public static synchronized StorageEngine getInstance() {
        if (instance == null) {
            PluginHibernateUtil.initialize();
            instance = new StorageEngine();
        }
        return instance;
    }

    public StorageEngine() {
        try {
            logger.info((Object)"Creating StorageEngine instance");
            this.initialize();
        }
        catch (PluginHibernateException ex) {
            logger.fatal((Object)("Could not create StorageEngine: " + Util.getExceptionDescription((Exception)ex)));
            return;
        }
    }

    public JSONObject store(String value, String user) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        if (StringUtils.isEmpty((String)value)) {
            logger.error((Object)"Parameter 'storageValue' cannot be empty");
            throw new InvalidCdfOperationException("Parameter 'storageValue' cannot be empty");
        }
        logger.debug((Object)"Storing user entry");
        Session session = this.getSession();
        session.beginTransaction();
        Query query = session.getNamedQuery("org.pentaho.cdf.storage.StorageEntry.getStorageForUser").setString("user", user);
        StorageEntry storageEntry = (StorageEntry)query.uniqueResult();
        if (storageEntry == null) {
            storageEntry = new StorageEntry();
            storageEntry.setUser(user);
        }
        storageEntry.setStorageValue(value);
        storageEntry.setLastUpdatedDate(Calendar.getInstance().getTime());
        session.save((Object)storageEntry);
        session.flush();
        session.getTransaction().commit();
        session.close();
        return JsonUtil.makeJsonSuccessResponse(Boolean.TRUE);
    }

    public JSONObject read(String user) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        logger.debug((Object)"Reading storage");
        Session session = this.getSession();
        Query query = session.getNamedQuery("org.pentaho.cdf.storage.StorageEntry.getStorageForUser").setString("user", user);
        StorageEntry storageEntry = (StorageEntry)query.uniqueResult();
        String result = storageEntry != null ? storageEntry.getStorageValue() : "{}";
        session.close();
        return JsonUtil.makeJsonSuccessResponse(result);
    }

    public JSONObject delete(String user) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        logger.debug((Object)("Deleting storage for user " + user));
        Session session = this.getSession();
        session.beginTransaction();
        Query query = session.getNamedQuery("org.pentaho.cdf.storage.StorageEntry.getStorageForUser").setString("user", user);
        StorageEntry storageEntry = (StorageEntry)query.uniqueResult();
        if (storageEntry != null) {
            session.delete((Object)storageEntry);
        }
        session.flush();
        session.getTransaction().commit();
        session.close();
        return JsonUtil.makeJsonSuccessResponse(Boolean.TRUE);
    }

    private synchronized Session getSession() throws PluginHibernateException {
        return PluginHibernateUtil.getSession();
    }

    private void initialize() throws PluginHibernateException {
        try {
            IBasicFile storageHbmFile = CdfEngine.getEnvironment().getHibernateConfigurations().getStorageConfigurationFile();
            if (storageHbmFile == null || storageHbmFile.getContents() == null) {
                logger.error((Object)"Unable to find storage hbm file");
                throw new PluginHibernateException("Unable to find storage hbm file", null);
            }
            PluginHibernateUtil.closeSession();
            PluginHibernateUtil.getConfiguration().addInputStream(storageHbmFile.getContents());
            PluginHibernateUtil.rebuildSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to initialize storage engine", (Throwable)e);
            throw new PluginHibernateException("Unable to initialize storage engine", e);
        }
    }

    public static enum Operation {
        READ("READ"),
        STORE("STORE"),
        DELETE("DELETE"),
        UNKNOWN("UNKNOWN");

        private final String operation;

        private Operation(String operation) {
            this.operation = operation;
        }

        public static Operation get(String operation) {
            try {
                return Operation.valueOf(operation.toUpperCase());
            }
            catch (Exception exception) {
                return UNKNOWN;
            }
        }
    }
}

