/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.render;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IUserContentAccess;
import pt.webdetails.cpf.utils.XmlDom4JUtils;

public class XcdfRenderer {
    private static final Log logger = LogFactory.getLog(XcdfRenderer.class);
    private static final String NODE_TEMPLATE = "/cdf/template";
    private static final String NODE_MESSAGES = "/cdf/messages";
    private static final String NODE_STYLES = "/cdf/style";
    private String style;
    private String template;
    private String messagesBaseFilename;

    public boolean determineDashboardTemplating(String solution, String path, String action, String defaultTemplate) throws InvalidCdfOperationException {
        return this.determineDashboardTemplating(FilenameUtils.separatorsToUnix((String)Util.joinPath((String[])new String[]{solution, path, action})), defaultTemplate);
    }

    public boolean determineDashboardTemplating(String dashboard, String defaultTemplate) throws InvalidCdfOperationException {
        boolean success = false;
        IUserContentAccess access = CdfEngine.getUserContentReader(null);
        if (access.fileExists(dashboard)) {
            if (!access.hasAccess(dashboard, FileAccess.EXECUTE)) {
                throw new InvalidCdfOperationException("Access denied");
            }
            try {
                Document doc = XmlDom4JUtils.getDocumentFromFile((IBasicFile)access.fetchFile(dashboard));
                this.template = doc.selectSingleNode(NODE_TEMPLATE) != null ? XmlDom4JUtils.getNodeText((String)NODE_TEMPLATE, (Node)doc, (String)"") : defaultTemplate;
                if (doc.selectSingleNode(NODE_MESSAGES) != null) {
                    this.messagesBaseFilename = XmlDom4JUtils.getNodeText((String)NODE_MESSAGES, (Node)doc);
                }
                this.style = doc.selectSingleNode(NODE_STYLES) != null ? XmlDom4JUtils.getNodeText((String)NODE_STYLES, (Node)doc) : "mantle";
                success = true;
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new InvalidCdfOperationException(e);
            }
        }
        return success;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getStyle() {
        return this.style;
    }

    public String getMessagesBaseFilename() {
        return this.messagesBaseFilename;
    }
}

