/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.comments;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.comments.CommentEntry;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.utils.JsonUtil;
import org.pentaho.cdf.utils.PluginHibernateUtil;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IBasicFile;

public class CommentsEngine {
    private static final Log logger = LogFactory.getLog(CommentsEngine.class);
    private static CommentsEngine instance;
    private static final SimpleDateFormat format;

    public static CommentsEngine getInstance() {
        if (instance == null) {
            PluginHibernateUtil.initialize();
            instance = new CommentsEngine();
        }
        return instance;
    }

    public CommentsEngine() {
        try {
            logger.info((Object)"Creating CommentsEngine instance");
            this.initialize();
        }
        catch (PluginHibernateException ex) {
            logger.fatal((Object)("Could not create CommentsEngine: " + Util.getExceptionDescription((Exception)ex)));
            return;
        }
    }

    public JSONObject add(String page, String comment, String user) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        if (StringUtils.isEmpty((String)page) || StringUtils.isEmpty((String)comment)) {
            logger.error((Object)"Parameters 'page' and 'comment' are not optional");
            throw new InvalidCdfOperationException("Page cannot be null");
        }
        logger.debug((Object)"Adding comment");
        CommentEntry commentEntry = new CommentEntry(page, user, comment);
        Session session = this.getSession();
        session.beginTransaction();
        session.save((Object)commentEntry);
        session.flush();
        session.getTransaction().commit();
        return JsonUtil.makeJsonSuccessResponse(this.commentToJson(commentEntry, user));
    }

    public JSONObject list(String page, int firstResult, int maxResults, boolean isDeleted, boolean isArchived, String user) throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        logger.debug((Object)"Listing messages");
        if (StringUtils.isEmpty((String)page)) {
            logger.error((Object)"Parameter 'page' is not optional");
            throw new InvalidCdfOperationException("Page cannot be null");
        }
        String queryName = isDeleted || isArchived ? "getCommentsByPageWhere" : "getCommentsByPage";
        logger.debug((Object)"Adding comment");
        Session session = this.getSession();
        Query query = session.getNamedQuery("org.pentaho.cdf.comments.CommentEntry." + queryName);
        query.setString("page", page);
        if (isDeleted || isArchived) {
            query.setBoolean("deleted", isDeleted);
            query.setBoolean("archived", isArchived);
        }
        query.setFirstResult(firstResult < 0 ? 0 : firstResult);
        query.setMaxResults(maxResults < 0 ? 20 : maxResults);
        List comments = query.list();
        JSONArray jsonArray = new JSONArray();
        for (CommentEntry comment : comments) {
            JSONObject commentJson = this.commentToJson(comment, user);
            jsonArray.put((Object)commentJson);
        }
        return JsonUtil.makeJsonSuccessResponse(jsonArray);
    }

    public JSONObject delete(int commentId, boolean status, String user, boolean isAdmin) throws JSONException, PluginHibernateException {
        logger.debug((Object)("Deleting comment " + commentId));
        return this.changeCommentStatus(Operation.DELETE, commentId, status, user, isAdmin);
    }

    public JSONObject archive(int commentId, boolean status, String user, boolean isAdmin) throws JSONException, PluginHibernateException {
        logger.debug((Object)("Archiving comment " + commentId));
        return this.changeCommentStatus(Operation.ARCHIVE, commentId, status, user, isAdmin);
    }

    private JSONObject changeCommentStatus(Operation operation, int commentId, boolean status, String user, boolean isAdmin) throws JSONException, PluginHibernateException {
        Session session = this.getSession();
        session.beginTransaction();
        CommentEntry comment = (CommentEntry)session.load(CommentEntry.class, (Serializable)Integer.valueOf(commentId));
        Boolean isUser = comment.getUser().equals(user);
        if (!isUser.booleanValue() && !isAdmin) {
            return JsonUtil.makeJsonErrorResponse("Operation not authorized: not comment owner or administrator", false);
        }
        switch (operation) {
            case DELETE: {
                comment.setDeleted(status);
                break;
            }
            case ARCHIVE: {
                comment.setArchived(status);
            }
        }
        session.save((Object)comment);
        session.getTransaction().commit();
        return JsonUtil.makeJsonSuccessResponse(this.commentToJson(comment, user));
    }

    private JSONObject commentToJson(CommentEntry comment, String user) throws JSONException {
        JSONObject commentJson = new JSONObject();
        commentJson.put("id", comment.getCommentId());
        commentJson.put("user", (Object)comment.getUser());
        commentJson.put("page", (Object)comment.getPage());
        commentJson.put("createdOn", (Object)format.format(comment.getCreatedDate()));
        commentJson.put("elapsedMinutes", comment.getMinutesSinceCreation());
        commentJson.put("comment", (Object)comment.getComment());
        commentJson.put("isMe", comment.getUser().equals(user));
        commentJson.put("isDeleted", comment.isDeleted());
        commentJson.put("isArchived", comment.isArchived());
        return commentJson;
    }

    private Session getSession() throws PluginHibernateException {
        return PluginHibernateUtil.getSession();
    }

    private void initialize() throws PluginHibernateException {
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            IBasicFile commentsHbmFile = CdfEngine.getEnvironment().getHibernateConfigurations().getCommentsConfigurationFile();
            if (commentsHbmFile == null || commentsHbmFile.getContents() == null) {
                logger.error((Object)"Unable to find comments hbm file");
                throw new PluginHibernateException("Unable to find comments hbm file", null);
            }
            PluginHibernateUtil.closeSession();
            PluginHibernateUtil.getConfiguration().addInputStream(commentsHbmFile.getContents());
            PluginHibernateUtil.rebuildSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to initialize comments engine", (Throwable)e);
            throw new PluginHibernateException("Unable to initialize comments engine", e);
        }
    }

    static {
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static enum Operation {
        ADD("ADD"),
        DELETE("DELETE"),
        ARCHIVE("ARCHIVE"),
        LIST("LIST"),
        UNKNOWN("UNKNOWN");

        private final String operation;

        private Operation(String operation) {
            this.operation = operation;
        }

        public static Operation get(String operation) {
            try {
                return Operation.valueOf(operation.toUpperCase());
            }
            catch (Exception exception) {
                return UNKNOWN;
            }
        }
    }
}

