/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.sitemap;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import pt.webdetails.cpf.utils.IPluginUtils;
import pt.webdetails.cpk.elements.IElement;
import pt.webdetails.cpk.elements.impl.DashboardElement;
import pt.webdetails.cpk.sitemap.Link;

public class LinkGenerator {
    private ArrayList<Link> dashboardLinks;
    protected Log logger = LogFactory.getLog(this.getClass());
    private IPluginUtils pluginUtils;
    private static final String ADMIN_DIR = "admin";
    private static final String KETTLE_DIR = "kettle";

    public LinkGenerator(Map<String, IElement> elementsMap, IPluginUtils pluginUtils) {
        this.pluginUtils = pluginUtils;
        this.generateLinks(elementsMap);
    }

    private Map<String, File> getTopLevelDirectories(Collection<IElement> elements) {
        HashMap<String, File> directories = new HashMap<String, File>();
        for (IElement element : elements) {
            File directory = new File(FilenameUtils.getFullPath((String)element.getLocation()));
            if (directory == null) continue;
            try {
                directories.put(directory.getCanonicalPath(), directory);
            }
            catch (Exception e) {}
        }
        return directories;
    }

    private List<File> getDirectories(File directory) {
        List<File> directories = new ArrayList<File>();
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        File[] dirs = directory.listFiles(dirFilter);
        if (dirs != null) {
            directories = Arrays.asList(dirs);
        }
        return directories;
    }

    private void generateLinks(Map<String, IElement> elementsMap) {
        this.dashboardLinks = new ArrayList();
        Map<String, File> directories = this.getTopLevelDirectories(elementsMap.values());
        Link l = null;
        for (File directory : directories.values()) {
            if (directory.getName().equals(ADMIN_DIR) || directory.getName().equals(KETTLE_DIR)) continue;
            for (File file : this.getFiles(directory)) {
                IElement element;
                int index = file.getName().indexOf(".");
                String filename = file.getName().substring(0, index).toLowerCase();
                if (elementsMap.containsKey(filename) && this.isDashboard(element = elementsMap.get(filename)) && !this.linkExists(this.dashboardLinks, l = new Link(elementsMap.get(filename), this.pluginUtils))) {
                    this.dashboardLinks.add(l);
                }
                for (File dir : this.getDirectories(directory)) {
                    if (dir.getName().equals(ADMIN_DIR) || directories.containsValue(dir) || this.linkExists(this.dashboardLinks, l = new Link(dir, elementsMap, this.pluginUtils))) continue;
                    this.dashboardLinks.add(l);
                }
            }
        }
    }

    private List<File> getFiles(File directory) {
        ArrayList<File> files = null;
        if (directory.isDirectory()) {
            FileFilter dirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile();
                }
            };
            files = new ArrayList<File>(Arrays.asList(directory.listFiles(dirFilter)));
        }
        return files;
    }

    private boolean linkExists(ArrayList<Link> lnks, Link lnk) {
        boolean exists = false;
        for (Link l : lnks) {
            try {
                if (l.getName() == null) continue;
                if (!l.getId().equals("") && l.getId().equals(lnk.getId())) {
                    exists = true;
                    continue;
                }
                if (!l.getId().equals("") || !l.getName().equals(lnk.getName())) continue;
                exists = true;
            }
            catch (Exception e) {
                exists = true;
            }
        }
        return exists;
    }

    public JsonNode getLinksJson() {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jnode = null;
        ArrayList<String> json = new ArrayList<String>();
        for (Link l : this.dashboardLinks) {
            json.add(l.getLinkJson());
        }
        try {
            jnode = mapper.readTree(json.toString());
        }
        catch (IOException ex) {
            this.logger.error((Object)ex);
        }
        return jnode;
    }

    public boolean isDashboard(IElement e) {
        return e instanceof DashboardElement;
    }
}

