/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.sitemap;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.ObjectMapper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import pt.webdetails.cpf.utils.IPluginUtils;
import pt.webdetails.cpk.CpkEngine;
import pt.webdetails.cpk.elements.IElement;

public class Link {
    private String name;
    private String id;
    private String link;
    private List<Link> subLinks;
    private Map<String, IElement> elements;
    private IPluginUtils pluginUtils;
    protected Log logger = LogFactory.getLog(this.getClass());

    public Link(File directory, Map<String, IElement> elementsMap, IPluginUtils pluginUtils) {
        this.pluginUtils = pluginUtils;
        this.elements = elementsMap;
        this.subLinks = new ArrayList<Link>();
        this.buildLink(directory);
        this.name = directory.getName();
        this.id = "";
        this.link = "";
    }

    public Link(IElement element, IPluginUtils plug) {
        this.pluginUtils = plug;
        this.name = this.getTextFromWcdf(element.getLocation(), "title");
        if (this.name == null) {
            this.name = this.getTextFromWcdf(element.getLocation(), "description");
        }
        this.link = "/pentaho/plugin/" + this.pluginUtils.getPluginName() + "/api/" + element.getId().toLowerCase();
        this.id = element.getLocation().split("/")[element.getLocation().split("/").length - 1];
        this.subLinks = new ArrayList<Link>();
    }

    public void buildLink(File directory) {
        List<File> directories = null;
        List<File> files = null;
        Link link = null;
        if (!this.getTopLevelDirectories(this.elements).containsValue(directory)) {
            if (this.hasSubfolders(directory)) {
                directories = this.getDirectories(directory);
            }
            if (this.hasFiles(directory)) {
                files = this.getFiles(directory);
            }
            if (directories != null) {
                for (File dir : directories) {
                    link = new Link(dir, this.elements, this.pluginUtils);
                    this.subLinks.add(link);
                }
            }
            if (files != null) {
                for (File file : files) {
                    IElement myElement;
                    int index = file.getName().indexOf(".");
                    String filename = file.getName().substring(0, index).toLowerCase();
                    if (!this.elements.containsKey(filename) || this.subLinkExists((ArrayList)this.subLinks, link = new Link(myElement = this.elements.get(filename), this.pluginUtils))) continue;
                    this.subLinks.add(link);
                }
            }
        }
    }

    private boolean hasSubfolders(File directory) {
        FileFilter dirFilter;
        boolean has = false;
        if (directory.isDirectory() && directory.listFiles(dirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        }).length > 0) {
            has = true;
        }
        return has;
    }

    public String getName() {
        String n = this.name == null ? "null" : this.name;
        return n;
    }

    public String getId() {
        String i = this.id == null ? "null" : this.id;
        return i;
    }

    public List<Link> getSublinks() {
        return this.subLinks;
    }

    public String getLink() {
        String l = this.link == null ? "null" : this.link;
        return l;
    }

    private String getTextFromWcdf(String path, String text) {
        File xml = new File(path);
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(xml);
        }
        catch (DocumentException documentException) {
            this.logger.error((Object)("Problem reading properties from " + path));
        }
        Element root = doc.getRootElement();
        return root.elementText(text);
    }

    private void createSublinks() {
    }

    public boolean isDashboard(IElement e) {
        boolean is = false;
        if (e.getType().equalsIgnoreCase("dashboard")) {
            is = true;
        }
        return is;
    }

    public boolean isKettle(IElement e) {
        boolean is = false;
        if (e.getType().equalsIgnoreCase("kettle")) {
            is = true;
        }
        return is;
    }

    @JsonIgnore
    public String getLinkJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException ex) {
            Logger.getLogger(CpkEngine.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private boolean hasFiles(File directory) {
        FileFilter dirFilter;
        boolean has = false;
        if (directory.isDirectory() && directory.listFiles(dirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        }).length > 0) {
            has = true;
        }
        return has;
    }

    private List<File> getFiles(File directory) {
        ArrayList<File> files = null;
        if (directory.isDirectory()) {
            FileFilter dirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile();
                }
            };
            files = new ArrayList<File>(Arrays.asList(directory.listFiles(dirFilter)));
        }
        return files;
    }

    private List<File> getDirectories(File directory) {
        ArrayList<File> dirs = null;
        if (directory.isDirectory()) {
            FileFilter dirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            };
            dirs = new ArrayList<File>(Arrays.asList(directory.listFiles(dirFilter)));
        }
        return dirs;
    }

    private Map<String, File> getTopLevelDirectories(Map<String, IElement> elementsMap) {
        HashMap<String, File> directories = new HashMap<String, File>();
        for (IElement element : elementsMap.values()) {
            File directory = new File(FilenameUtils.getPath((String)element.getLocation()));
            if (directory == null) continue;
            try {
                directories.put(directory.getCanonicalPath(), directory);
            }
            catch (Exception e) {}
        }
        return directories;
    }

    private boolean subLinkExists(ArrayList<Link> lnks, Link lnk) {
        boolean exists = false;
        for (Link l : lnks) {
            try {
                if (l.getName() == null || !l.getId().equals(lnk.getId())) continue;
                exists = true;
            }
            catch (Exception e) {
                exists = true;
            }
        }
        return exists;
    }
}

