/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpk.CpkEngine;
import pt.webdetails.cpk.InterPluginBroker;
import pt.webdetails.cpk.elements.Element;

public class DashboardElement
extends Element {
    public void processRequest(Map<String, Map<String, Object>> bloatedMap) {
        try {
            this.callCDE(bloatedMap);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error while calling CDE: " + Util.getExceptionDescription((Exception)ex)));
        }
    }

    protected void callCDE(Map<String, Map<String, Object>> bloatedMap) throws UnsupportedEncodingException, IOException {
        String path = CpkEngine.getInstance().getEnvironment().getPluginUtils().getPluginRelativeDirectory(this.getLocation(), true);
        HttpServletResponse response = (HttpServletResponse)bloatedMap.get("path").get("httpresponse");
        response.setContentType("text/html");
        ServletOutputStream out = response.getOutputStream();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Object> requestParams = bloatedMap.get("request");
        path = FilenameUtils.separatorsToUnix((String)path);
        params.put("solution", "system");
        params.put("path", path);
        if (requestParams.containsKey("mode") && requestParams.get("mode").equals("preview")) {
            params.put("file", this.getName() + "_tmp.cdfde");
        } else {
            params.put("file", this.getName() + ".wcdf");
        }
        params.put("absolute", "false");
        params.put("inferScheme", "false");
        for (String name : requestParams.keySet()) {
            params.put(name, requestParams.get(name));
        }
        if (requestParams.containsKey("mode") && requestParams.get("mode").equals("edit")) {
            this.redirectToCdeEditor(response, params);
            return;
        }
        try {
            InterPluginBroker.run(params, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void redirectToCdeEditor(HttpServletResponse response, Map<String, Object> params) throws IOException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("../../pentaho-cdf-dd/api/renderer/edit");
        if (params.size() > 0) {
            urlBuilder.append("?");
        }
        ArrayList<String> paramArray = new ArrayList<String>();
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (!(value instanceof String)) continue;
            paramArray.add(key + "=" + URLEncoder.encode((String)value, "utf-8"));
        }
        urlBuilder.append(StringUtils.join(paramArray, (String)"&"));
        if (response == null) {
            this.logger.error((Object)"response not found");
            return;
        }
        try {
            response.sendRedirect(urlBuilder.toString());
        }
        catch (IOException e) {
            this.logger.error((Object)"could not redirect", (Throwable)e);
        }
    }

    public boolean isRenderable() {
        return true;
    }
}

