/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreeCollection;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;
import org.netbeans.mdr.util.MapEntryImpl;

public class SinglevaluedBtree
extends Btree
implements SinglevaluedIndex {
    public SinglevaluedBtree(String name, Storage.EntryType keyType, Storage.EntryType dataType, BtreePageSource pageSource) throws StorageException {
        super(name, keyType, dataType, pageSource);
    }

    protected void init() throws StorageException {
        this.uniqueKeys = true;
        this.uniqueValues = false;
        super.init();
    }

    public SinglevaluedBtree() {
    }

    public Object getIfExists(Object key) throws StorageException {
        return this.getIfExistsInternal(key, null);
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        return this.getIfExistsInternal(key, repos);
    }

    private Object getIfExistsInternal(Object key, SinglevaluedIndex repos) throws StorageException {
        Object object;
        this.beginRead();
        try {
            byte[] keyBuffer = this.keyInfo.toBuffer(key);
            if (keyBuffer == null) {
                throw new StorageBadRequestException(MessageFormat.format("Invalid key type for this index: {0} received, {1} expected", key.getClass().getName(), this.keyInfo.typeName()));
            }
            BtreePage root = this.pageSource.getPage(this.rootPageId, this);
            byte[] dataBuffer = root.get(keyBuffer);
            Object result = dataBuffer != null ? (repos == null ? this.dataInfo.fromBuffer(dataBuffer) : this.dataInfo.objectFromBuffer(dataBuffer, repos)) : null;
            this.pageSource.unpinPage(root);
            object = result;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return object;
    }

    public Object get(Object key) throws StorageException {
        Object object;
        this.beginRead();
        try {
            Object result = this.getIfExists(key);
            if (result == null) {
                throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
            }
            object = result;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return object;
    }

    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        Object object;
        this.beginRead();
        try {
            Object result = this.getObjectIfExists(key, repos);
            if (result == null) {
                throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
            }
            object = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return object;
    }

    public boolean put(Object key, Object data) throws StorageException {
        boolean bl;
        this.beginWrite();
        try {
            this.replaced = false;
            this.btreePut(key, data, (byte)2, 0);
            bl = this.replaced;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.endWrite();
            throw throwable;
        }
        this.endWrite();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replace(Object key, Object data) throws StorageException {
        this.beginWrite();
        try {
            this.failed = false;
            this.btreePut(key, data, (byte)1, 0);
            if (this.failed) {
                throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.endWrite();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.endWrite();
    }

    public Collection values() throws StorageException {
        return new BtreeCollection(this);
    }

    public synchronized Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.keyType != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        byte[] prefixBytes = this.keyInfo.toBuffer(prefix);
        SearchResult location = this.getLocation(prefixBytes);
        if (location.entryNum == location.page.numEntries()) {
            BtreePage.getNext(null, location);
        }
        while (location.entryNum < location.page.numEntries() && SinglevaluedBtree.isPrefix(prefixBytes, location.page.getKey(location.entryNum))) {
            byte[] key = location.page.getKey(location.entryNum);
            byte[] data = location.page.getData(location.entryNum);
            MapEntryImpl entry = new MapEntryImpl(this.keyInfo.objectFromBuffer(key, primaryIndex), this.dataInfo.objectFromBuffer(data, primaryIndex));
            result.add(entry);
            BtreePage.getNext(null, location);
        }
        return result;
    }

    static boolean isPrefix(byte[] prefix, byte[] key) {
        if (prefix.length > key.length) {
            return false;
        }
        int x = 0;
        while (x < prefix.length) {
            if (prefix[x] != key[x]) {
                return false;
            }
            ++x;
        }
        return true;
    }
}

