/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.common.ui.models.PermissionsModel;
import org.pentaho.common.ui.models.PermissionsModelMapper;
import org.pentaho.common.ui.models.TreeBrowserModel;
import org.pentaho.platform.repository2.unified.jcr.LocalizationUtil;
import org.pentaho.platform.repository2.unified.webservices.LocaleMapDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.platform.repository2.unified.webservices.StringKeyStringValueDto;

public class TreeBrowserMapper {
    private Log logger = LogFactory.getLog(TreeBrowserMapper.class);
    private static String FILE_NAME_KEY = "file.title";
    private PermissionsModelMapper permissionsModelMapper;
    private Locale locale = Locale.getDefault();

    public TreeBrowserMapper(Locale locale) {
        this.locale = locale;
    }

    public void setPermissionsModelMapper(PermissionsModelMapper permissionsModelMapper) {
        this.permissionsModelMapper = permissionsModelMapper;
    }

    public TreeBrowserModel convert(RepositoryFileDto repositoryDto) {
        TreeBrowserModel treeBrowserModel = new TreeBrowserModel();
        try {
            BeanUtils.copyProperties((Object)treeBrowserModel, (Object)repositoryDto);
            treeBrowserModel.setOwner(repositoryDto.getRepositoryFileAclDto().getOwner());
        }
        catch (Exception e) {
            this.logger.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        treeBrowserModel.setLocalizedName(this.getLocalizedName(this.locale, repositoryDto, FILE_NAME_KEY, repositoryDto.getName()));
        PermissionsModel permissionsModel = new PermissionsModel();
        if (this.permissionsModelMapper != null) {
            permissionsModel = this.permissionsModelMapper.map(treeBrowserModel);
        }
        treeBrowserModel.setPermissions(permissionsModel);
        return treeBrowserModel;
    }

    public TreeBrowserModel convert(RepositoryFileTreeDto repositoryFileTreeDto) {
        RepositoryFileDto repositoryFileDto = repositoryFileTreeDto.getFile();
        TreeBrowserModel treeBrowserModel = this.convert(repositoryFileDto);
        this.mapTree(repositoryFileTreeDto, treeBrowserModel);
        return treeBrowserModel;
    }

    private void mapTree(RepositoryFileTreeDto root, TreeBrowserModel treeBrowserModel) {
        List children = root.getChildren();
        ArrayList<TreeBrowserModel> models = new ArrayList<TreeBrowserModel>();
        if (children != null) {
            for (RepositoryFileTreeDto repositoryFileTreeDto : children) {
                RepositoryFileDto file = repositoryFileTreeDto.getFile();
                TreeBrowserModel model = this.convert(file);
                this.mapTree(repositoryFileTreeDto, model);
                models.add(model);
            }
        }
        treeBrowserModel.setChildren(models);
    }

    public Map<String, Properties> toPropertiesMap(List<LocaleMapDto> propertiesMapEntries) {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        if (propertiesMapEntries != null) {
            for (LocaleMapDto localeMapDto : propertiesMapEntries) {
                Properties props = new Properties();
                List properties = localeMapDto.getProperties();
                if (properties != null) {
                    for (StringKeyStringValueDto stringKeyStringValueDto : properties) {
                        props.put(stringKeyStringValueDto.getKey(), stringKeyStringValueDto.getValue());
                    }
                }
                propertiesMap.put(localeMapDto.getLocale(), props);
            }
        }
        return propertiesMap;
    }

    public String getLocalizedName(Locale locale, RepositoryFileDto repositoryDto, String propertyName, String defaultValue) {
        Map<String, Properties> localePropertiesMap = this.toPropertiesMap(repositoryDto.getLocalePropertiesMapEntries());
        LocalizationUtil localizationUtil = new LocalizationUtil(localePropertiesMap, locale);
        return localizationUtil.resolveLocalizedString(propertyName, defaultValue);
    }
}

