/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.metadata.model.impl;

import org.apache.commons.lang.StringUtils;
import org.pentaho.common.ui.metadata.model.ICondition;
import org.pentaho.common.ui.metadata.model.Operator;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.model.CombinationType;

public class Condition
implements ICondition {
    private static final long serialVersionUID = 6382700024558898605L;
    private String column;
    private String category;
    private String operator = Operator.EQUAL.name();
    private String[] value;
    private String comboType = CombinationType.AND.name();
    private boolean parameterized;
    private String selectedAggType;

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public String getCombinationType() {
        return this.comboType;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public String[] getValue() {
        return this.value;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setCombinationType(String combinationType) {
        this.comboType = combinationType;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public boolean validate() {
        return true;
    }

    @Override
    public String getCondition(String type) {
        return this.getCondition(type, this.isParameterized() ? this.value[0] : null);
    }

    @Override
    public String getCondition(String type, String paramName) {
        boolean enforceParameters;
        String[] val = this.value;
        Operator theOperator = Operator.parse(this.operator);
        if (type.equalsIgnoreCase(DataType.STRING.getName()) && theOperator == Operator.EQUAL) {
            theOperator = Operator.EXACTLY_MATCHES;
        }
        boolean bl = enforceParameters = this.isParameterized() && paramName != null;
        if (!enforceParameters && type.equalsIgnoreCase(DataType.STRING.getName())) {
            for (int idx = 0; idx < val.length; ++idx) {
                val[idx] = "\"" + val[idx] + "\"";
            }
        }
        String columnName = "[" + this.category + "." + this.column + (StringUtils.isEmpty((String)this.selectedAggType) ? "" : "." + this.selectedAggType) + "]";
        if (type.equals(DataType.DATE.getName())) {
            if (enforceParameters) {
                for (int idx = 0; idx < val.length; ++idx) {
                    val[idx] = "DATEVALUE([param:" + this.value[idx].replaceAll("[\\{\\}]", "") + "]" + ")";
                }
                return theOperator.formatCondition(columnName, paramName, val, false);
            }
            for (int idx = 0; idx < val.length; ++idx) {
                val[idx] = "DATEVALUE(\"" + val[idx] + "\")";
            }
        }
        return theOperator.formatCondition(columnName, paramName, val, enforceParameters);
    }

    @Override
    public boolean isParameterized() {
        return this.parameterized;
    }

    public void setParameterized(boolean parameterized) {
        this.parameterized = parameterized;
    }

    public void setSelectedAggType(String aggType) {
        this.selectedAggType = aggType;
    }

    @Override
    public String getSelectedAggType() {
        return this.selectedAggType;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

