/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.ParameterVerifier;
import org.apache.oozie.util.ParameterVerifierException;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.ControlNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeDef;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.xml.sax.SAXException;

public class LiteWorkflowAppParser {
    private static final String DECISION_E = "decision";
    private static final String ACTION_E = "action";
    private static final String END_E = "end";
    private static final String START_E = "start";
    private static final String JOIN_E = "join";
    private static final String FORK_E = "fork";
    private static final Object KILL_E = "kill";
    private static final String SLA_INFO = "info";
    private static final String CREDENTIALS = "credentials";
    private static final String GLOBAL = "global";
    private static final String PARAMETERS = "parameters";
    private static final String NAME_A = "name";
    private static final String CRED_A = "cred";
    private static final String USER_RETRY_MAX_A = "retry-max";
    private static final String USER_RETRY_INTERVAL_A = "retry-interval";
    private static final String TO_A = "to";
    private static final String FORK_PATH_E = "path";
    private static final String FORK_START_A = "start";
    private static final String ACTION_OK_E = "ok";
    private static final String ACTION_ERROR_E = "error";
    private static final String DECISION_SWITCH_E = "switch";
    private static final String DECISION_CASE_E = "case";
    private static final String DECISION_DEFAULT_E = "default";
    private static final String KILL_MESSAGE_E = "message";
    public static final String VALIDATE_FORK_JOIN = "oozie.validate.ForkJoin";
    public static final String WF_VALIDATE_FORK_JOIN = "oozie.wf.validate.ForkJoin";
    private Schema schema;
    private Class<? extends ControlNodeHandler> controlNodeHandler;
    private Class<? extends DecisionNodeHandler> decisionHandlerClass;
    private Class<? extends ActionNodeHandler> actionHandlerClass;
    private List<String> forkList = new ArrayList<String>();
    private List<String> joinList = new ArrayList<String>();
    private StartNodeDef startNode;
    private List<String> visitedOkNodes = new ArrayList<String>();
    private List<String> visitedJoinNodes = new ArrayList<String>();

    public LiteWorkflowAppParser(Schema schema, Class<? extends ControlNodeHandler> controlNodeHandler, Class<? extends DecisionNodeHandler> decisionHandlerClass, Class<? extends ActionNodeHandler> actionHandlerClass) throws WorkflowException {
        this.schema = schema;
        this.controlNodeHandler = controlNodeHandler;
        this.decisionHandlerClass = decisionHandlerClass;
        this.actionHandlerClass = actionHandlerClass;
    }

    public LiteWorkflowApp validateAndParse(Reader reader, Configuration jobConf) throws WorkflowException {
        return this.validateAndParse(reader, jobConf, null);
    }

    public LiteWorkflowApp validateAndParse(Reader reader, Configuration jobConf, Configuration configDefault) throws WorkflowException {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            String strDef = writer.toString();
            if (this.schema != null) {
                Validator validator = this.schema.newValidator();
                validator.validate(new StreamSource(new StringReader(strDef)));
            }
            Element wfDefElement = XmlUtils.parseXml(strDef);
            ParameterVerifier.verifyParameters(jobConf, wfDefElement);
            LiteWorkflowApp app = this.parse(strDef, wfDefElement, configDefault);
            HashMap<String, VisitStatus> traversed = new HashMap<String, VisitStatus>();
            traversed.put(app.getNode(":start:").getName(), VisitStatus.VISITING);
            this.validate(app, app.getNode(":start:"), traversed);
            if (jobConf.getBoolean(WF_VALIDATE_FORK_JOIN, true) && Services.get().getConf().getBoolean(VALIDATE_FORK_JOIN, true)) {
                this.validateForkJoin(app);
            }
            return app;
        }
        catch (ParameterVerifierException ex) {
            throw new WorkflowException(ex);
        }
        catch (JDOMException ex) {
            throw new WorkflowException(ErrorCode.E0700, new Object[]{ex.getMessage(), ex});
        }
        catch (SAXException ex) {
            throw new WorkflowException(ErrorCode.E0701, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0702, ex.getMessage(), ex);
        }
    }

    private void validateForkJoin(LiteWorkflowApp app) throws WorkflowException {
        if (this.forkList.size() != this.joinList.size()) {
            throw new WorkflowException(ErrorCode.E0730, new Object[0]);
        }
        if (!this.forkList.isEmpty()) {
            this.visitedOkNodes.clear();
            this.visitedJoinNodes.clear();
            this.validateForkJoin(this.startNode, app, new LinkedList<String>(), new LinkedList<String>(), new LinkedList<String>(), true);
        }
    }

    private void validateForkJoin(NodeDef node, LiteWorkflowApp app, Deque<String> forkNodes, Deque<String> joinNodes, Deque<String> path, boolean okTo) throws WorkflowException {
        if (path.contains(node.getName())) {
            throw new WorkflowException(ErrorCode.E0741, node.getName(), Arrays.toString(path.toArray()));
        }
        path.push(node.getName());
        if (okTo && !(node instanceof KillNodeDef) && !(node instanceof JoinNodeDef) && !(node instanceof EndNodeDef)) {
            if (this.visitedOkNodes.contains(node.getName())) {
                throw new WorkflowException(ErrorCode.E0743, node.getName());
            }
            this.visitedOkNodes.add(node.getName());
        }
        if (node instanceof StartNodeDef) {
            String transition = node.getTransitions().get(0);
            NodeDef tranNode = app.getNode(transition);
            this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo);
        } else if (node instanceof ActionNodeDef) {
            String transition = node.getTransitions().get(0);
            NodeDef tranNode = app.getNode(transition);
            this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo);
            transition = node.getTransitions().get(1);
            tranNode = app.getNode(transition);
            this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, false);
        } else if (node instanceof DecisionNodeDef) {
            for (String transition : new HashSet<String>(node.getTransitions())) {
                NodeDef tranNode = app.getNode(transition);
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo);
            }
        } else if (node instanceof ForkNodeDef) {
            forkNodes.push(node.getName());
            for (String transition : new HashSet<String>(node.getTransitions())) {
                NodeDef tranNode = app.getNode(transition);
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo);
            }
            forkNodes.pop();
            if (!joinNodes.isEmpty()) {
                joinNodes.pop();
            }
        } else if (node instanceof JoinNodeDef) {
            if (forkNodes.isEmpty()) {
                throw new WorkflowException(ErrorCode.E0742, node.getName());
            }
            if (forkNodes.size() > joinNodes.size() && (joinNodes.isEmpty() || !joinNodes.peek().equals(node.getName()))) {
                joinNodes.push(node.getName());
            }
            if (!joinNodes.peek().equals(node.getName())) {
                throw new WorkflowException(ErrorCode.E0732, forkNodes.peek(), node.getName(), joinNodes.peek());
            }
            joinNodes.pop();
            String currentForkNode = forkNodes.pop();
            String transition = node.getTransitions().get(0);
            NodeDef tranNode = app.getNode(transition);
            if (!okTo || this.visitedJoinNodes.contains(node.getName())) {
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, false);
            } else {
                this.visitedJoinNodes.add(node.getName());
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, true);
            }
            forkNodes.push(currentForkNode);
            joinNodes.push(node.getName());
        } else if (!(node instanceof KillNodeDef)) {
            if (node instanceof EndNodeDef) {
                if (!forkNodes.isEmpty()) {
                    path.pop();
                    String parent = path.peek();
                    throw new WorkflowException(ErrorCode.E0737, parent, node.getName());
                }
            } else {
                throw new WorkflowException(ErrorCode.E0740, node.getName());
            }
        }
        path.pop();
    }

    private LiteWorkflowApp parse(String strDef, Element root, Configuration configDefault) throws WorkflowException {
        Namespace ns = root.getNamespace();
        LiteWorkflowApp def = null;
        Element global = null;
        for (Element eNode : root.getChildren()) {
            if (eNode.getName().equals("start")) {
                def = new LiteWorkflowApp(root.getAttributeValue(NAME_A), strDef, new StartNodeDef(this.controlNodeHandler, eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(END_E)) {
                def.addNode(new EndNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler));
                continue;
            }
            if (eNode.getName().equals(KILL_E)) {
                def.addNode(new KillNodeDef(eNode.getAttributeValue(NAME_A), eNode.getChildText(KILL_MESSAGE_E, ns), this.controlNodeHandler));
                continue;
            }
            if (eNode.getName().equals(FORK_E)) {
                ArrayList<String> paths = new ArrayList<String>();
                for (Element tran : eNode.getChildren(FORK_PATH_E, ns)) {
                    paths.add(tran.getAttributeValue("start"));
                }
                def.addNode(new ForkNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler, paths));
                continue;
            }
            if (eNode.getName().equals(JOIN_E)) {
                def.addNode(new JoinNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler, eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(DECISION_E)) {
                Element eSwitch = eNode.getChild(DECISION_SWITCH_E, ns);
                ArrayList<String> transitions = new ArrayList<String>();
                for (Element e : eSwitch.getChildren(DECISION_CASE_E, ns)) {
                    transitions.add(e.getAttributeValue(TO_A));
                }
                transitions.add(eSwitch.getChild(DECISION_DEFAULT_E, ns).getAttributeValue(TO_A));
                String switchStatement = XmlUtils.prettyPrint(eSwitch).toString();
                def.addNode(new DecisionNodeDef(eNode.getAttributeValue(NAME_A), switchStatement, this.decisionHandlerClass, (List<String>)transitions));
                continue;
            }
            if (ACTION_E.equals(eNode.getName())) {
                String[] transitions = new String[2];
                Element eActionConf = null;
                for (Element elem : eNode.getChildren()) {
                    if (ACTION_OK_E.equals(elem.getName())) {
                        transitions[0] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (ACTION_ERROR_E.equals(elem.getName())) {
                        transitions[1] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (SLA_INFO.equals(elem.getName()) || CREDENTIALS.equals(elem.getName())) continue;
                    eActionConf = elem;
                    this.handleGlobal(ns, global, configDefault, elem);
                }
                String credStr = eNode.getAttributeValue(CRED_A);
                String userRetryMaxStr = eNode.getAttributeValue(USER_RETRY_MAX_A);
                String userRetryIntervalStr = eNode.getAttributeValue(USER_RETRY_INTERVAL_A);
                String actionConf = XmlUtils.prettyPrint(eActionConf).toString();
                def.addNode(new ActionNodeDef(eNode.getAttributeValue(NAME_A), actionConf, this.actionHandlerClass, transitions[0], transitions[1], credStr, userRetryMaxStr, userRetryIntervalStr));
                continue;
            }
            if (SLA_INFO.equals(eNode.getName()) || CREDENTIALS.equals(eNode.getName())) continue;
            if (eNode.getName().equals(GLOBAL)) {
                global = eNode;
                continue;
            }
            if (eNode.getName().equals(PARAMETERS)) continue;
            throw new WorkflowException(ErrorCode.E0703, eNode.getName());
        }
        return def;
    }

    private void validate(LiteWorkflowApp app, NodeDef node, Map<String, VisitStatus> traversed) throws WorkflowException {
        if (node instanceof StartNodeDef) {
            this.startNode = (StartNodeDef)node;
        } else {
            try {
                ParamChecker.validateActionName(node.getName());
            }
            catch (IllegalArgumentException ex) {
                throw new WorkflowException(ErrorCode.E0724, ex.getMessage());
            }
        }
        if (node instanceof ActionNodeDef) {
            try {
                boolean supportedAction;
                Element action = XmlUtils.parseXml(node.getConf());
                boolean bl = supportedAction = Services.get().get(ActionService.class).getExecutor(action.getName()) != null;
                if (!supportedAction) {
                    throw new WorkflowException(ErrorCode.E0723, node.getName(), action.getName());
                }
            }
            catch (JDOMException ex) {
                throw new RuntimeException("It should never happen, " + ex.getMessage(), ex);
            }
        }
        if (node instanceof ForkNodeDef) {
            this.forkList.add(node.getName());
        }
        if (node instanceof JoinNodeDef) {
            this.joinList.add(node.getName());
        }
        if (node instanceof EndNodeDef) {
            traversed.put(node.getName(), VisitStatus.VISITED);
            return;
        }
        if (node instanceof KillNodeDef) {
            traversed.put(node.getName(), VisitStatus.VISITED);
            return;
        }
        for (String transition : node.getTransitions()) {
            if (app.getNode(transition) == null) {
                throw new WorkflowException(ErrorCode.E0708, node.getName(), transition);
            }
            if (traversed.get(app.getNode(transition).getName()) == VisitStatus.VISITING) {
                throw new WorkflowException(ErrorCode.E0707, app.getNode(transition).getName());
            }
            if (traversed.get(app.getNode(transition).getName()) == VisitStatus.VISITED) continue;
            traversed.put(app.getNode(transition).getName(), VisitStatus.VISITING);
            this.validate(app, app.getNode(transition), traversed);
        }
        traversed.put(node.getName(), VisitStatus.VISITED);
    }

    private void handleGlobal(Namespace ns, Element global, Configuration configDefault, Element eActionConf) throws WorkflowException {
        Namespace actionNs = eActionConf.getNamespace();
        if (global != null) {
            Element globalJobTracker = global.getChild("job-tracker", ns);
            Element globalNameNode = global.getChild("name-node", ns);
            List globalJobXml = global.getChildren("job-xml", ns);
            Element globalConfiguration = global.getChild("configuration", ns);
            if (globalJobTracker != null && eActionConf.getChild("job-tracker", actionNs) == null) {
                Element jobTracker = new Element("job-tracker", actionNs);
                jobTracker.setText(globalJobTracker.getText());
                eActionConf.addContent((Content)jobTracker);
            }
            if (globalNameNode != null && eActionConf.getChild("name-node", actionNs) == null) {
                Element nameNode = new Element("name-node", actionNs);
                nameNode.setText(globalNameNode.getText());
                eActionConf.addContent((Content)nameNode);
            }
            if (!globalJobXml.isEmpty()) {
                List actionJobXml = eActionConf.getChildren("job-xml", actionNs);
                for (Element jobXml : globalJobXml) {
                    boolean alreadyExists = false;
                    for (Element actionXml : actionJobXml) {
                        if (!jobXml.getText().equals(actionXml.getText())) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    Element ejobXml = new Element("job-xml", actionNs);
                    ejobXml.setText(jobXml.getText());
                    eActionConf.addContent((Content)ejobXml);
                }
            }
            try {
                Element actionConfiguration = eActionConf.getChild("configuration", actionNs);
                XConfiguration actionConf = actionConfiguration == null ? new XConfiguration() : new XConfiguration(new StringReader(XmlUtils.prettyPrint(actionConfiguration).toString()));
                if (globalConfiguration != null) {
                    XConfiguration globalConf = new XConfiguration(new StringReader(XmlUtils.prettyPrint(globalConfiguration).toString()));
                    XConfiguration.injectDefaults(globalConf, actionConf);
                }
                XConfiguration.injectDefaults(configDefault, actionConf);
                int position = eActionConf.indexOf((Content)actionConfiguration);
                eActionConf.removeContent((Content)actionConfiguration);
                Element eConfXml = XmlUtils.parseXml(actionConf.toXmlString(false));
                eConfXml.detach();
                eConfXml.setNamespace(actionNs);
                if (position > 0) {
                    eActionConf.addContent(position, (Content)eConfXml);
                }
                eActionConf.addContent((Content)eConfXml);
            }
            catch (IOException e) {
                throw new WorkflowException(ErrorCode.E0700, "Error while processing action conf");
            }
            catch (JDOMException e) {
                throw new WorkflowException(ErrorCode.E0700, "Error while processing action conf");
            }
        } else {
            ActionExecutor ae = Services.get().get(ActionService.class).getExecutor(eActionConf.getName());
            if (ae == null) {
                throw new WorkflowException(ErrorCode.E0723, eActionConf.getName(), ActionService.class.getName());
            }
            if (ae.requiresNNJT) {
                if (eActionConf.getChild("name-node", actionNs) == null) {
                    throw new WorkflowException(ErrorCode.E0701, "No name-node defined");
                }
                if (eActionConf.getChild("job-tracker", actionNs) == null) {
                    throw new WorkflowException(ErrorCode.E0701, "No job-tracker defined");
                }
            }
        }
    }

    private static enum VisitStatus {
        VISITING,
        VISITED;

    }
}

