/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.ZKUtils;

public class ZKLocksService
extends MemoryLocksService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private static XLog LOG = XLog.getLog(ZKLocksService.class);
    private static final String LOCKS_NODE = "/locks/";

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
    }

    @Override
    public void destroy() {
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
    }

    @Override
    public LockToken getReadLock(String resource, long wait) throws InterruptedException {
        InterProcessReadWriteLock lock = new InterProcessReadWriteLock(this.zk.getClient(), LOCKS_NODE + resource);
        InterProcessMutex readLock = lock.readLock();
        return this.acquireLock(wait, readLock);
    }

    @Override
    public LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        InterProcessReadWriteLock lock = new InterProcessReadWriteLock(this.zk.getClient(), LOCKS_NODE + resource);
        InterProcessMutex readLock = lock.writeLock();
        return this.acquireLock(wait, readLock);
    }

    private LockToken acquireLock(long wait, InterProcessMutex lock) {
        ZKLockToken token = null;
        try {
            if (wait == -1L) {
                lock.acquire();
                token = new ZKLockToken(lock);
            } else if (lock.acquire(wait, TimeUnit.MILLISECONDS)) {
                token = new ZKLockToken(lock);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return token;
    }

    class ZKLockToken
    implements LockToken {
        private final InterProcessMutex lock;

        private ZKLockToken(InterProcessMutex lock) {
            this.lock = lock;
        }

        @Override
        public void release() {
            try {
                this.lock.release();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not release lock: " + ex.getMessage()), ex);
            }
        }
    }
}

