/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public class ConfigurationService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP = "configuration";
    public static final String CONF_PREFIX = "oozie.service.ConfigurationService.";
    public static final String CONF_IGNORE_SYS_PROPS = "oozie.service.ConfigurationService.ignore.system.properties";
    public static final String OOZIE_CONFIG_DIR = "oozie.config.dir";
    public static final String OOZIE_DATA_DIR = "oozie.data.dir";
    public static final String OOZIE_CONFIG_FILE = "oozie.config.file";
    private static final Set<String> IGNORE_SYS_PROPS = new HashSet<String>();
    private static final String IGNORE_TEST_SYS_PROPS = "oozie.test.";
    private static final String PASSWORD_PROPERTY_END = ".password";
    public static final String DEFAULT_CONFIG_FILE = "oozie-default.xml";
    public static final String SITE_CONFIG_FILE = "oozie-site.xml";
    private static XLog log;
    private String configDir;
    private String configFile;
    private LogChangesConfiguration configuration;

    public ConfigurationService() {
        log = XLog.getLog(ConfigurationService.class);
    }

    @Override
    public void init(Services services) throws ServiceException {
        this.configDir = ConfigurationService.getConfigurationDirectory();
        this.configFile = System.getProperty(OOZIE_CONFIG_FILE, SITE_CONFIG_FILE);
        if (this.configFile.contains("/")) {
            throw new ServiceException(ErrorCode.E0022, this.configFile);
        }
        log.info("Oozie home dir  [{0}]", Services.getOozieHome());
        log.info("Oozie conf dir  [{0}]", this.configDir);
        log.info("Oozie conf file [{0}]", this.configFile);
        this.configFile = new File(this.configDir, this.configFile).toString();
        this.configuration = this.loadConf();
    }

    public static String getConfigurationDirectory() throws ServiceException {
        File file;
        String oozieHome = Services.getOozieHome();
        String configDir = System.getProperty(OOZIE_CONFIG_DIR, null);
        File file2 = file = configDir == null ? new File(oozieHome, "conf") : new File(configDir);
        if (!file.exists()) {
            throw new ServiceException(ErrorCode.E0024, configDir);
        }
        return file.toString();
    }

    @Override
    public void destroy() {
        this.configuration = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return ConfigurationService.class;
    }

    public Configuration getConf() {
        if (this.configuration == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.configuration;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    private InputStream getDefaultConfiguration() throws ServiceException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(DEFAULT_CONFIG_FILE);
        if (inputStream == null) {
            throw new ServiceException(ErrorCode.E0023, DEFAULT_CONFIG_FILE);
        }
        return inputStream;
    }

    private LogChangesConfiguration loadConf() throws ServiceException {
        String[] ignoreSysProps;
        Iterator<Map.Entry<Object, Object>> i$;
        XConfiguration configuration;
        try {
            InputStream inputStream = this.getDefaultConfiguration();
            configuration = new XConfiguration(inputStream);
            File file = new File(this.configFile);
            if (!file.exists()) {
                log.info("Missing site configuration file [{0}]", this.configFile);
            } else {
                inputStream = new FileInputStream(this.configFile);
                XConfiguration xConfiguration = new XConfiguration(inputStream);
                XConfiguration.injectDefaults(configuration, xConfiguration);
                configuration = xConfiguration;
            }
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0024, this.configFile, ex.getMessage(), ex);
        }
        if (log.isTraceEnabled()) {
            try {
                StringWriter writer = new StringWriter();
                i$ = configuration.iterator();
                while (i$.hasNext()) {
                    Map.Entry entry = (Map.Entry)i$.next();
                    boolean maskValue = ((String)entry.getKey()).endsWith(PASSWORD_PROPERTY_END);
                    String value = maskValue ? "**MASKED**" : (String)entry.getValue();
                    writer.write(" " + (String)entry.getKey() + " = " + value + "\n");
                }
                writer.close();
                log.trace("Configuration:\n{0}---", writer.toString());
            }
            catch (IOException ex) {
                throw new ServiceException(ErrorCode.E0025, ex.getMessage(), ex);
            }
        }
        if ((ignoreSysProps = configuration.getStrings(CONF_IGNORE_SYS_PROPS)) != null) {
            IGNORE_SYS_PROPS.addAll(Arrays.asList(ignoreSysProps));
        }
        i$ = configuration.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            String sysValue = System.getProperty((String)entry.getKey());
            if (sysValue == null || IGNORE_SYS_PROPS.contains(entry.getKey())) continue;
            log.info("Configuration change via System Property, [{0}]=[{1}]", entry.getKey(), sysValue);
            configuration.set((String)entry.getKey(), sysValue);
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String name = (String)entry.getKey();
            if (IGNORE_SYS_PROPS.contains(name) || !name.startsWith("oozie.") || name.startsWith(IGNORE_TEST_SYS_PROPS) || configuration.get(name) != null) continue;
            log.warn("System property [{0}] no defined in Oozie configuration, ignored", name);
        }
        return new LogChangesConfiguration(configuration);
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable(INSTRUMENTATION_GROUP, "config.dir", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return ConfigurationService.this.configDir;
            }
        });
        instr.addVariable(INSTRUMENTATION_GROUP, "config.file", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return ConfigurationService.this.configFile;
            }
        });
        instr.setConfiguration(this.configuration);
    }

    public static Configuration maskPasswords(Configuration conf) {
        XConfiguration maskedConf = new XConfiguration();
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            boolean maskValue = name.endsWith(PASSWORD_PROPERTY_END);
            String value = maskValue ? "**MASKED**" : (String)entry.getValue();
            maskedConf.set(name, value);
        }
        return maskedConf;
    }

    static {
        IGNORE_SYS_PROPS.add(CONF_IGNORE_SYS_PROPS);
        IGNORE_SYS_PROPS.add("oozie.http.hostname");
        IGNORE_SYS_PROPS.add("oozie.http.port");
        IGNORE_SYS_PROPS.add("oozie.instance.id");
        IGNORE_SYS_PROPS.add("oozie.home.dir");
        IGNORE_SYS_PROPS.add(OOZIE_CONFIG_DIR);
        IGNORE_SYS_PROPS.add(OOZIE_CONFIG_FILE);
        IGNORE_SYS_PROPS.add(OOZIE_DATA_DIR);
        IGNORE_SYS_PROPS.add("oozie.log.dir");
        IGNORE_SYS_PROPS.add("oozie.log4j.file");
        IGNORE_SYS_PROPS.add("oozie.log4j.reload");
        log = XLog.getLog(ConfigurationService.class);
    }

    private class LogChangesConfiguration
    extends XConfiguration {
        public LogChangesConfiguration(Configuration conf) {
            for (Map.Entry entry : conf) {
                if (this.get((String)entry.getKey()) != null) continue;
                this.setValue((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public String[] getStrings(String name) {
            String s = this.get(name);
            return s != null && s.trim().length() > 0 ? super.getStrings(name) : new String[]{};
        }

        @Override
        public String get(String name, String defaultValue) {
            String value = this.get(name);
            if (value == null) {
                boolean maskValue = name.endsWith(ConfigurationService.PASSWORD_PROPERTY_END);
                value = defaultValue;
                String logValue = maskValue ? "**MASKED**" : defaultValue;
                log.warn(4, "Configuration property [{0}] not found, using default [{1}]", name, logValue);
            }
            return value;
        }

        public void set(String name, String value) {
            this.setValue(name, value);
            boolean maskValue = name.endsWith(ConfigurationService.PASSWORD_PROPERTY_END);
            value = maskValue ? "**MASKED**" : value;
            log.info(4, "Programmatic configuration change, property[{0}]=[{1}]", name, value);
        }

        private void setValue(String name, String value) {
            super.set(name, value);
        }
    }
}

