/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionGetForExternalIdJPAExecutor
implements JPAExecutor<CoordinatorActionBean> {
    private String externalId = null;

    public CoordActionGetForExternalIdJPAExecutor(String externalId) {
        ParamChecker.notNull(externalId, "externalId");
        this.externalId = externalId;
    }

    @Override
    public String getName() {
        return "CoordActionGetForExternalIdJPAExecutor";
    }

    @Override
    public CoordinatorActionBean execute(EntityManager em) throws JPAExecutorException {
        try {
            CoordinatorActionBean caBean = null;
            Query q = em.createNamedQuery("GET_COORD_ACTION_FOR_EXTERNALID");
            q.setParameter("externalId", (Object)this.externalId);
            List actionArr = q.getResultList();
            if (actionArr.size() > 0) {
                caBean = this.getBeanForRunningCoordAction((Object[])actionArr.get(0));
            }
            return caBean;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private CoordinatorActionBean getBeanForRunningCoordAction(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setJobId((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            bean.setPending((Integer)arr[3]);
        }
        if (arr[4] != null) {
            bean.setExternalId((String)arr[4]);
        }
        if (arr[5] != null) {
            bean.setLastModifiedTime(DateUtils.toDate((Timestamp)arr[5]));
        }
        if (arr[6] != null) {
            bean.setSlaXml((String)arr[6]);
        }
        if (arr[7] != null) {
            bean.setNominalTime(DateUtils.toDate((Timestamp)arr[7]));
        }
        if (arr[8] != null) {
            bean.setCreatedTime(DateUtils.toDate((Timestamp)arr[8]));
        }
        return bean;
    }
}

