/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BulkUpdateInsertJPAExecutor
implements JPAExecutor<Void> {
    private Collection<JsonBean> updateList;
    private Collection<JsonBean> insertList;

    public BulkUpdateInsertJPAExecutor(Collection<JsonBean> updateList, Collection<JsonBean> insertList) {
        this.updateList = updateList;
        this.insertList = insertList;
    }

    public BulkUpdateInsertJPAExecutor() {
    }

    public void setUpdateList(Collection<JsonBean> updateList) {
        this.updateList = updateList;
    }

    public void setInsertList(Collection<JsonBean> insertList) {
        this.insertList = insertList;
    }

    @Override
    public String getName() {
        return "BulkUpdateInsertJPAExecutor";
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        try {
            if (this.insertList != null) {
                for (JsonBean entity : this.insertList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    em.persist((Object)entity);
                }
            }
            FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
            if (this.updateList != null) {
                for (JsonBean entity : this.updateList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    em.merge((Object)entity);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

