/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.List;
import java.util.Map;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.JobXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.WorkflowsJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class JobsXCommand
extends WorkflowXCommand<WorkflowsInfo> {
    private final Map<String, List<String>> filter;
    private final int start;
    private final int len;
    private WorkflowsInfo workflows;

    public JobsXCommand(Map<String, List<String>> filter, int start, int length) {
        super("job.info", "job.info", 1, true);
        this.filter = filter;
        this.start = start;
        this.len = length;
    }

    @Override
    protected WorkflowsInfo execute() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            if (jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.workflows = jpaService.execute(new WorkflowsJobGetJPAExecutor(this.filter, this.start, this.len));
            for (WorkflowJobBean workflow : this.workflows.getWorkflows()) {
                workflow.setConsoleUrl(JobXCommand.getJobConsoleUrl(workflow.getId()));
            }
            return this.workflows;
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

