/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.executor.jpa.BulkUpdateInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;

public class ActionCheckXCommand
extends ActionXCommand<Void> {
    public static final String EXEC_DATA_MISSING = "EXEC_DATA_MISSING";
    private String actionId;
    private String jobId;
    private int actionCheckDelay;
    private WorkflowJobBean wfJob = null;
    private WorkflowActionBean wfAction = null;
    private JPAService jpaService = null;
    private ActionExecutor executor = null;
    private List<JsonBean> updateList = new ArrayList<JsonBean>();
    private boolean generateEvent = false;

    public ActionCheckXCommand(String actionId) {
        this(actionId, -1);
    }

    public ActionCheckXCommand(String actionId, int priority, int checkDelay) {
        super("action.check", "action.check", priority);
        this.actionId = actionId;
        this.actionCheckDelay = checkDelay;
        this.jobId = Services.get().get(UUIDService.class).getId(actionId);
    }

    public ActionCheckXCommand(String actionId, int checkDelay) {
        this(actionId, 0, checkDelay);
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfJob = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.jobId));
            this.wfAction = this.jpaService.execute(new WorkflowActionGetJPAExecutor(this.actionId));
            LogUtils.setLogInfo(this.wfJob, this.logInfo);
            LogUtils.setLogInfo(this.wfAction, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfJob == null) {
            throw new PreconditionException(ErrorCode.E0604, this.jobId);
        }
        if (this.wfAction == null) {
            throw new PreconditionException(ErrorCode.E0605, this.actionId);
        }
        if (this.actionCheckDelay > 0) {
            Timestamp actionCheckTs = new Timestamp(System.currentTimeMillis() - (long)(this.actionCheckDelay * 1000));
            Timestamp actionLmt = this.wfAction.getLastCheckTimestamp();
            if (actionLmt.after(actionCheckTs)) {
                throw new PreconditionException(ErrorCode.E0817, this.actionId);
            }
        }
        this.executor = Services.get().get(ActionService.class).getExecutor(this.wfAction.getType());
        if (this.executor == null) {
            throw new CommandException(ErrorCode.E0802, this.wfAction.getType());
        }
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        this.eagerLoadState();
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (!this.wfAction.isPending() || this.wfAction.getStatus() != WorkflowAction.Status.RUNNING) {
            throw new PreconditionException(ErrorCode.E0815, this.wfAction.getPending(), this.wfAction.getStatusStr());
        }
        if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING) {
            this.wfAction.setLastCheckTime(new Date());
            try {
                this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(this.wfAction));
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
            throw new PreconditionException(ErrorCode.E0818, this.wfAction.getId(), this.wfJob.getId(), this.wfJob.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED ActionCheckXCommand for wf actionId=" + this.actionId + " priority =" + this.getPriority());
        long retryInterval = Services.get().getConf().getLong("oozie.service.ActionCheckerService.action.check.interval", this.executor.getRetryInterval());
        this.executor.setRetryInterval(retryInterval);
        ActionXCommand.ActionExecutorContext context = null;
        try {
            boolean isRetry = false;
            if (this.wfAction.getRetries() > 0) {
                isRetry = true;
            }
            boolean isUserRetry = false;
            context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
            this.incrActionCounter(this.wfAction.getType(), 1);
            Instrumentation.Cron cron = new Instrumentation.Cron();
            cron.start();
            this.executor.check(context, this.wfAction);
            cron.stop();
            this.addActionCron(this.wfAction.getType(), cron);
            if (this.wfAction.isExecutionComplete()) {
                if (!context.isExecuted()) {
                    this.LOG.warn(4, "Action Completed, ActionExecutor [{0}] must call setExecutionData()", this.executor.getType());
                    this.wfAction.setErrorInfo(EXEC_DATA_MISSING, "Execution Complete, but Execution Data Missing from Action");
                    this.failJob(context);
                    this.generateEvent = true;
                } else {
                    this.wfAction.setPending();
                    this.queue(new ActionEndXCommand(this.wfAction.getId(), this.wfAction.getType()));
                }
            }
            this.wfAction.setLastCheckTime(new Date());
            this.updateList.add(this.wfAction);
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(this.wfJob);
        }
        catch (ActionExecutorException ex) {
            this.LOG.warn("Exception while executing check(). Error Code [{0}], Message[{1}]", ex.getErrorCode(), ex.getMessage(), ex);
            this.wfAction.setErrorInfo(ex.getErrorCode(), ex.getMessage());
            switch (ex.getErrorType()) {
                case FAILED: {
                    this.failJob(context, this.wfAction);
                    this.generateEvent = true;
                    break;
                }
                case ERROR: {
                    this.handleUserRetry(this.wfAction);
                    break;
                }
                case TRANSIENT: {
                    if (this.handleTransient(context, this.executor, WorkflowAction.Status.RUNNING)) break;
                    this.handleNonTransient(context, this.executor, WorkflowAction.Status.START_MANUAL);
                    this.generateEvent = true;
                    this.wfAction.setPendingAge(new Date());
                    this.wfAction.setRetries(0);
                    this.wfAction.setStartTime(null);
                }
            }
            this.wfAction.setLastCheckTime(new Date());
            this.updateList = new ArrayList<JsonBean>();
            this.updateList.add(this.wfAction);
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(this.wfJob);
        }
        finally {
            try {
                this.jpaService.execute(new BulkUpdateInsertJPAExecutor(this.updateList, null));
                if (this.generateEvent && EventHandlerService.isEnabled()) {
                    this.generateEvent(this.wfAction, this.wfJob.getUser());
                }
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
        }
        this.LOG.debug("ENDED ActionCheckXCommand for wf actionId=" + this.actionId + ", jobId=" + this.jobId);
        return null;
    }

    protected long getRetryInterval() {
        return this.executor != null ? this.executor.getRetryInterval() : 60L;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }
}

