/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.BundleJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsCountNotForPurgeFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobsCountNotForPurgeFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetFromParentIdJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class PurgeXCommand
extends XCommand<Void> {
    private JPAService jpaService = null;
    private int wfOlderThan;
    private int coordOlderThan;
    private int bundleOlderThan;
    private final int limit;
    private List<String> wfList;
    private List<String> coordList;
    private List<String> bundleList;
    private int wfDel;
    private int coordDel;
    private int bundleDel;

    public PurgeXCommand(int wfOlderThan, int coordOlderThan, int bundleOlderThan, int limit) {
        super("purge", "purge", 0);
        this.wfOlderThan = wfOlderThan;
        this.coordOlderThan = coordOlderThan;
        this.bundleOlderThan = bundleOlderThan;
        this.limit = limit;
        this.wfList = new ArrayList<String>();
        this.coordList = new ArrayList<String>();
        this.bundleList = new ArrayList<String>();
        this.wfDel = 0;
        this.coordDel = 0;
        this.bundleDel = 0;
    }

    @Override
    protected void loadState() throws CommandException {
        block6: {
            try {
                this.jpaService = Services.get().get(JPAService.class);
                if (this.jpaService != null) {
                    int size;
                    do {
                        size = this.wfList.size();
                        this.wfList.addAll((Collection<String>)this.jpaService.execute(new WorkflowJobsGetForPurgeJPAExecutor(this.wfOlderThan, this.wfList.size(), this.limit)));
                    } while (size != this.wfList.size());
                    do {
                        size = this.coordList.size();
                        this.coordList.addAll((Collection<String>)this.jpaService.execute(new CoordJobsGetForPurgeJPAExecutor(this.coordOlderThan, this.coordList.size(), this.limit)));
                    } while (size != this.coordList.size());
                    do {
                        size = this.bundleList.size();
                        this.bundleList.addAll((Collection<String>)this.jpaService.execute(new BundleJobsGetForPurgeJPAExecutor(this.bundleOlderThan, this.bundleList.size(), this.limit)));
                    } while (size != this.bundleList.size());
                    break block6;
                }
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            catch (XException ex) {
                throw new CommandException(ex);
            }
        }
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED Purge to purge Workflow Jobs older than [{0}] days, Coordinator Jobs older than [{1}] days, and Bundlejobs older than [{2}] days.", this.wfOlderThan, this.coordOlderThan, this.bundleOlderThan);
        if (!this.wfList.isEmpty()) {
            try {
                this.processWorkflows(this.wfList);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        if (!this.coordList.isEmpty()) {
            try {
                this.processCoordinators(this.coordList);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        if (!this.bundleList.isEmpty()) {
            try {
                this.processBundles(this.bundleList);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        this.LOG.debug("ENDED Purge deleted [{0}] workflows, [{1}] coordinators, [{2}] bundles", this.wfDel, this.coordDel, this.bundleDel);
        return null;
    }

    private void processWorkflows(List<String> wfs) throws JPAExecutorException {
        List<String> wfsToPurge = this.processWorkflowsHelper(wfs);
        this.purgeWorkflows(wfsToPurge);
    }

    private List<String> processWorkflowsHelper(List<String> wfs) throws JPAExecutorException {
        if (wfs.isEmpty()) {
            return wfs;
        }
        ArrayList<String> subwfs = new ArrayList<String>();
        ArrayList<String> wfsToPurge = new ArrayList<String>();
        for (String wfId : wfs) {
            int size;
            long numChildrenNotReady = this.jpaService.execute(new WorkflowJobsCountNotForPurgeFromParentIdJPAExecutor(this.wfOlderThan, wfId));
            if (numChildrenNotReady != 0L) continue;
            wfsToPurge.add(wfId);
            ArrayList children = new ArrayList();
            do {
                size = children.size();
                children.addAll(this.jpaService.execute(new WorkflowJobsGetFromParentIdJPAExecutor(wfId, children.size(), this.limit)));
            } while (size != children.size());
            subwfs.addAll(children);
        }
        wfsToPurge.addAll(this.processWorkflowsHelper(subwfs));
        return wfsToPurge;
    }

    private void processCoordinators(List<String> coords) throws JPAExecutorException {
        ArrayList<String> wfsToPurge = new ArrayList<String>();
        ArrayList<String> coordsToPurge = new ArrayList<String>();
        for (String coordId : coords) {
            int size;
            long numChildrenNotReady = this.jpaService.execute(new WorkflowJobsCountNotForPurgeFromParentIdJPAExecutor(this.wfOlderThan, coordId));
            if (numChildrenNotReady != 0L) continue;
            coordsToPurge.add(coordId);
            ArrayList children = new ArrayList();
            do {
                size = children.size();
                children.addAll(this.jpaService.execute(new WorkflowJobsGetFromParentIdJPAExecutor(coordId, children.size(), this.limit)));
            } while (size != children.size());
            wfsToPurge.addAll(children);
        }
        this.processWorkflows(wfsToPurge);
        this.purgeCoordinators(coordsToPurge);
    }

    private void processBundles(List<String> bundles) throws JPAExecutorException {
        ArrayList<String> coordsToPurge = new ArrayList<String>();
        ArrayList<String> bundlesToPurge = new ArrayList<String>();
        for (String bundleId : bundles) {
            int size;
            long numChildrenNotReady = this.jpaService.execute(new CoordJobsCountNotForPurgeFromParentIdJPAExecutor(this.coordOlderThan, bundleId));
            if (numChildrenNotReady != 0L) continue;
            bundlesToPurge.add(bundleId);
            ArrayList children = new ArrayList();
            do {
                size = children.size();
                children.addAll(this.jpaService.execute(new CoordJobsGetFromParentIdJPAExecutor(bundleId, children.size(), this.limit)));
            } while (size != children.size());
            coordsToPurge.addAll(children);
        }
        this.processCoordinators(coordsToPurge);
        this.purgeBundles(bundlesToPurge);
    }

    private void purgeWorkflows(List<String> wfs) throws JPAExecutorException {
        this.wfDel += wfs.size();
        Collections.reverse(wfs);
        int startIndex = 0;
        while (startIndex < wfs.size()) {
            int endIndex = startIndex + this.limit < wfs.size() ? startIndex + this.limit : wfs.size();
            this.jpaService.execute(new WorkflowJobsDeleteJPAExecutor(wfs.subList(startIndex, endIndex)));
            startIndex = endIndex;
        }
    }

    private void purgeCoordinators(List<String> coords) throws JPAExecutorException {
        this.coordDel += coords.size();
        int startIndex = 0;
        while (startIndex < coords.size()) {
            int endIndex = startIndex + this.limit < coords.size() ? startIndex + this.limit : coords.size();
            this.jpaService.execute(new CoordJobsDeleteJPAExecutor(coords.subList(startIndex, endIndex)));
            startIndex = endIndex;
        }
    }

    private void purgeBundles(List<String> bundles) throws JPAExecutorException {
        this.bundleDel += bundles.size();
        int startIndex = 0;
        while (startIndex < bundles.size()) {
            int endIndex = startIndex + this.limit < bundles.size() ? startIndex + this.limit : bundles.size();
            this.jpaService.execute(new BundleJobsDeleteJPAExecutor(bundles.subList(startIndex, endIndex)));
            startIndex = endIndex;
        }
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

