/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.ScriptLanguageActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class PigActionExecutor
extends ScriptLanguageActionExecutor {
    private static final String PIG_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.PigMain";
    private static final String OOZIE_PIG_STATS = "org.apache.oozie.action.hadoop.OoziePigStats";
    static final String PIG_SCRIPT = "oozie.pig.script";
    static final String PIG_PARAMS = "oozie.pig.params";
    static final String PIG_ARGS = "oozie.pig.args";

    public PigActionExecutor() {
        super("pig");
    }

    @Override
    protected List<Class> getLauncherClasses() {
        List<Class> classes = super.getLauncherClasses();
        try {
            classes.add(Class.forName(PIG_MAIN_CLASS_NAME));
            classes.add(Class.forName(OOZIE_PIG_STATS));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", PIG_MAIN_CLASS_NAME);
    }

    @Override
    void injectActionCallback(ActionExecutor.Context context, Configuration launcherConf) {
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        super.setupActionConf(actionConf, context, actionXml, appPath);
        Namespace ns = actionXml.getNamespace();
        String script = actionXml.getChild("script", ns).getTextTrim();
        String pigName = new Path(script).getName();
        List params = actionXml.getChildren("param", ns);
        String[] strParams = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            strParams[i] = ((Element)params.get(i)).getTextTrim();
        }
        String[] strArgs = null;
        List eArgs = actionXml.getChildren("argument", ns);
        if (eArgs != null && eArgs.size() > 0) {
            strArgs = new String[eArgs.size()];
            for (int i = 0; i < eArgs.size(); ++i) {
                strArgs[i] = ((Element)eArgs.get(i)).getTextTrim();
            }
        }
        PigActionExecutor.setPigScript(actionConf, pigName, strParams, strArgs);
        return actionConf;
    }

    public static void setPigScript(Configuration conf, String script, String[] params, String[] args) {
        conf.set(PIG_SCRIPT, script);
        MapReduceMain.setStrings((Configuration)conf, (String)PIG_PARAMS, (String[])params);
        MapReduceMain.setStrings((Configuration)conf, (String)PIG_ARGS, (String[])args);
    }

    @Override
    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        return false;
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return "pig";
    }

    @Override
    protected String getScriptName() {
        return PIG_SCRIPT;
    }
}

