/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class MetaStoreUtils {
    protected static final Log LOG = LogFactory.getLog((String)"hive.log");
    public static final String DEFAULT_DATABASE_NAME = "default";
    public static final String DEFAULT_DATABASE_COMMENT = "Default Hive database";
    public static final String DATABASE_WAREHOUSE_SUFFIX = ".db";
    static HashMap<String, String> typeToThriftTypeMap = new HashMap();
    private static final String FROM_SERIALIZER = "from deserializer";

    public static void printStackTrace(Exception e) {
        for (StackTraceElement s : e.getStackTrace()) {
            LOG.error((Object)s);
        }
    }

    public static Table createColumnsetSchema(String name, List<String> columns, List<String> partCols, Configuration conf) throws MetaException {
        if (columns == null) {
            throw new MetaException("columns not specified for table " + name);
        }
        Table tTable = new Table();
        tTable.setTableName(name);
        tTable.setSd(new StorageDescriptor());
        StorageDescriptor sd = tTable.getSd();
        sd.setSerdeInfo(new SerDeInfo());
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        serdeInfo.setSerializationLib(LazySimpleSerDe.class.getName());
        serdeInfo.setParameters(new HashMap<String, String>());
        serdeInfo.getParameters().put("serialization.format", "1");
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        sd.setCols(fields);
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "'default'");
            fields.add(field);
        }
        tTable.setPartitionKeys(new ArrayList<FieldSchema>());
        for (String partCol : partCols) {
            FieldSchema part = new FieldSchema();
            part.setName(partCol);
            part.setType("string");
            tTable.getPartitionKeys().add(part);
        }
        sd.setNumBuckets(-1);
        return tTable;
    }

    public static void recursiveDelete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fs;
            for (File subf : fs = f.listFiles()) {
                MetaStoreUtils.recursiveDelete(subf);
            }
        }
        if (!f.delete()) {
            throw new IOException("could not delete: " + f.getPath());
        }
    }

    public static Deserializer getDeserializer(Configuration conf, Properties schema) throws MetaException {
        String lib = schema.getProperty("serialization.lib");
        try {
            Deserializer deserializer = SerDeUtils.lookupDeserializer((String)lib);
            deserializer.initialize(conf, schema);
            return deserializer;
        }
        catch (Exception e) {
            LOG.error((Object)("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage()));
            MetaStoreUtils.printStackTrace(e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static Deserializer getDeserializer(Configuration conf, Table table) throws MetaException {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        if (lib == null) {
            return null;
        }
        try {
            Deserializer deserializer = SerDeUtils.lookupDeserializer((String)lib);
            deserializer.initialize(conf, MetaStoreUtils.getTableMetadata(table));
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage()));
            MetaStoreUtils.printStackTrace(e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static Deserializer getDeserializer(Configuration conf, Partition part, Table table) throws MetaException {
        String lib = part.getSd().getSerdeInfo().getSerializationLib();
        try {
            Deserializer deserializer = SerDeUtils.lookupDeserializer((String)lib);
            deserializer.initialize(conf, MetaStoreUtils.getPartitionMetadata(part, table));
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage()));
            MetaStoreUtils.printStackTrace(e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static void deleteWHDirectory(Path path, Configuration conf, boolean use_trash) throws MetaException {
        try {
            if (!path.getFileSystem(conf).exists(path)) {
                LOG.warn((Object)("drop data called on table/partition with no directory: " + path));
                return;
            }
            if (use_trash) {
                int count = 0;
                Path newPath = new Path("/Trash/Current" + path.getParent().toUri().getPath());
                if (!path.getFileSystem(conf).exists(newPath)) {
                    path.getFileSystem(conf).mkdirs(newPath);
                }
                do {
                    newPath = new Path("/Trash/Current" + path.toUri().getPath() + "." + count);
                    if (path.getFileSystem(conf).exists(newPath)) {
                        ++count;
                        continue;
                    }
                    if (path.getFileSystem(conf).rename(path, newPath)) break;
                } while (++count < 50);
                if (count >= 50) {
                    throw new MetaException("Rename failed due to maxing out retries");
                }
            } else {
                path.getFileSystem(conf).delete(path, true);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Got exception trying to delete data dir: " + e));
            throw new MetaException(e.getMessage());
        }
        catch (MetaException e) {
            LOG.error((Object)("Got exception trying to delete data dir: " + e));
            throw e;
        }
    }

    public static boolean validateName(String name) {
        Pattern tpat = Pattern.compile("[\\w_]+");
        Matcher m = tpat.matcher(name);
        return m.matches();
    }

    public static boolean validateColNames(List<FieldSchema> cols) {
        for (FieldSchema fieldSchema : cols) {
            if (MetaStoreUtils.validateName(fieldSchema.getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean validateSkewedColNames(List<String> cols) {
        if (null == cols) {
            return true;
        }
        for (String col : cols) {
            if (MetaStoreUtils.validateName(col)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateSkewedColNamesSubsetCol(List<String> skewedColNames, List<FieldSchema> cols) {
        if (null == skewedColNames) {
            return true;
        }
        ArrayList<String> colNames = new ArrayList<String>();
        for (FieldSchema fieldSchema : cols) {
            colNames.add(fieldSchema.getName());
        }
        ArrayList<String> copySkewedColNames = new ArrayList<String>(skewedColNames);
        copySkewedColNames.removeAll(colNames);
        return copySkewedColNames.size() <= 0;
    }

    public static String getListType(String t) {
        return "array<" + t + ">";
    }

    public static String getMapType(String k, String v) {
        return "map<" + k + "," + v + ">";
    }

    public static void setSerdeParam(SerDeInfo sdi, Properties schema, String param) {
        String val = schema.getProperty(param);
        if (StringUtils.isNotBlank((String)val)) {
            sdi.getParameters().put(param, val);
        }
    }

    public static String typeToThriftType(String type) {
        StringBuilder thriftType = new StringBuilder();
        int last = 0;
        boolean lastAlphaDigit = Character.isLetterOrDigit(type.charAt(last));
        for (int i = 1; i <= type.length(); ++i) {
            if (i != type.length() && Character.isLetterOrDigit(type.charAt(i)) == lastAlphaDigit) continue;
            String token = type.substring(last, i);
            last = i;
            String thriftToken = typeToThriftTypeMap.get(token);
            thriftType.append(thriftToken == null ? token : thriftToken);
            lastAlphaDigit = !lastAlphaDigit;
        }
        return thriftType.toString();
    }

    public static String getFullDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append(MetaStoreUtils.getDDLFromFieldSchema(structName, fieldSchemas));
        ddl.append('#');
        StringBuilder colnames = new StringBuilder();
        StringBuilder coltypes = new StringBuilder();
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                colnames.append(',');
                coltypes.append(':');
            }
            colnames.append(col.getName());
            coltypes.append(col.getType());
        }
        ddl.append((CharSequence)colnames);
        ddl.append('#');
        ddl.append((CharSequence)coltypes);
        return ddl.toString();
    }

    public static String getDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(MetaStoreUtils.typeToThriftType(col.getType()));
            ddl.append(' ');
            ddl.append(col.getName());
        }
        ddl.append("}");
        LOG.debug((Object)("DDL: " + ddl));
        return ddl.toString();
    }

    public static Properties getTableMetadata(Table table) {
        return MetaStoreUtils.getSchema(table.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartitionMetadata(Partition partition, Table table) {
        return MetaStoreUtils.getSchema(partition.getSd(), partition.getSd(), partition.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getSchema(Partition part, Table table) {
        return MetaStoreUtils.getSchema(part.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartSchemaFromTableSchema(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys, Properties tblSchema) {
        Properties schema = (Properties)tblSchema.clone();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            String tblInput = schema.getProperty("file.inputformat");
            inputFormat = tblInput == null ? SequenceFileInputFormat.class.getName() : tblInput;
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            String tblOutput = schema.getProperty("file.outputformat");
            outputFormat = tblOutput == null ? SequenceFileOutputFormat.class.getName() : tblOutput;
        }
        schema.setProperty("file.outputformat", outputFormat);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        schema.setProperty("bucket_count", Integer.toString(sd.getNumBuckets()));
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", sd.getBucketCols().get(0));
        }
        if (sd.getSerdeInfo() != null) {
            String cols = "columns";
            String colTypes = "columns.types";
            String parts = "partition_columns";
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                String key = param.getKey();
                if (schema.get(key) != null && (key.equals(cols) || key.equals(colTypes) || key.equals(parts))) continue;
                schema.put(key, param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                schema.setProperty(e.getKey(), e.getValue());
            }
        }
        return schema;
    }

    public static Properties getSchema(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys) {
        Properties schema = new Properties();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            inputFormat = SequenceFileInputFormat.class.getName();
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            outputFormat = SequenceFileOutputFormat.class.getName();
        }
        schema.setProperty("file.outputformat", outputFormat);
        schema.setProperty("name", databaseName + "." + tableName);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        schema.setProperty("bucket_count", Integer.toString(sd.getNumBuckets()));
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", sd.getBucketCols().get(0));
        }
        if (sd.getSerdeInfo() != null) {
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                schema.put(param.getKey(), param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        StringBuilder colNameBuf = new StringBuilder();
        StringBuilder colTypeBuf = new StringBuilder();
        boolean first = true;
        for (FieldSchema col : tblsd.getCols()) {
            if (!first) {
                colNameBuf.append(",");
                colTypeBuf.append(":");
            }
            colNameBuf.append(col.getName());
            colTypeBuf.append(col.getType());
            first = false;
        }
        String colNames = colNameBuf.toString();
        String colTypes = colTypeBuf.toString();
        schema.setProperty("columns", colNames);
        schema.setProperty("columns.types", colTypes);
        if (sd.getCols() != null) {
            schema.setProperty("serialization.ddl", MetaStoreUtils.getDDLFromFieldSchema(tableName, sd.getCols()));
        }
        String partString = "";
        String partStringSep = "";
        for (FieldSchema fieldSchema : partitionKeys) {
            partString = partString.concat(partStringSep);
            partString = partString.concat(fieldSchema.getName());
            if (partStringSep.length() != 0) continue;
            partStringSep = "/";
        }
        if (partString.length() > 0) {
            schema.setProperty("partition_columns", partString);
        }
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                schema.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return schema;
    }

    public static String getColumnNamesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fieldSchemas.get(i).getName());
        }
        return sb.toString();
    }

    public static String getColumnTypesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fieldSchemas.get(i).getType());
        }
        return sb.toString();
    }

    public static void makeDir(Path path, HiveConf hiveConf) throws MetaException {
        try {
            FileSystem fs = path.getFileSystem((Configuration)hiveConf);
            if (!fs.exists(path)) {
                fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            throw new MetaException("Unable to : " + path);
        }
    }

    public static void startMetaStore(final int port, final HadoopThriftAuthBridge bridge) throws Exception {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HiveMetaStore.startMetaStore(port, bridge);
                }
                catch (Throwable e) {
                    LOG.error((Object)"Metastore Thrift Server threw an exception...", e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        MetaStoreUtils.loopUntilHMSReady(port);
    }

    private static void loopUntilHMSReady(int port) throws Exception {
        int retries = 0;
        Exception exc = null;
        while (true) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(port), 5000);
                socket.close();
                return;
            }
            catch (Exception e) {
                if (retries++ <= 6) {
                    Thread.sleep(10000L);
                    continue;
                }
                exc = e;
                throw exc;
            }
            break;
        }
    }

    public static int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    static void logAndThrowMetaException(Exception e) throws MetaException {
        LOG.error((Object)("Got exception: " + e.getClass().getName() + " " + e.getMessage()));
        LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        throw new MetaException("Got exception: " + e.getClass().getName() + " " + e.getMessage());
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String tableName, Deserializer deserializer) throws SerDeException, MetaException {
        ObjectInspector oi = deserializer.getObjectInspector();
        String[] names = tableName.split("\\.");
        String last_name = names[names.length - 1];
        for (int i = 1; i < names.length; ++i) {
            MapObjectInspector moi;
            if (oi instanceof StructObjectInspector) {
                StructObjectInspector soi = (StructObjectInspector)oi;
                StructField sf = soi.getStructFieldRef(names[i]);
                if (sf == null) {
                    throw new MetaException("Invalid Field " + names[i]);
                }
                oi = sf.getFieldObjectInspector();
                continue;
            }
            if (oi instanceof ListObjectInspector && names[i].equalsIgnoreCase("$elem$")) {
                ListObjectInspector loi = (ListObjectInspector)oi;
                oi = loi.getListElementObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$key$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapKeyObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$value$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapValueObjectInspector();
                continue;
            }
            throw new MetaException("Unknown type for " + names[i]);
        }
        ArrayList<FieldSchema> str_fields = new ArrayList<FieldSchema>();
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            str_fields.add(new FieldSchema(last_name, oi.getTypeName(), FROM_SERIALIZER));
        } else {
            List fields = ((StructObjectInspector)oi).getAllStructFieldRefs();
            for (int i = 0; i < fields.size(); ++i) {
                StructField structField = (StructField)fields.get(i);
                String fieldName = structField.getFieldName();
                String fieldTypeName = structField.getFieldObjectInspector().getTypeName();
                String fieldComment = MetaStoreUtils.determineFieldComment(structField.getFieldComment());
                str_fields.add(new FieldSchema(fieldName, fieldTypeName, fieldComment));
            }
        }
        return str_fields;
    }

    private static String determineFieldComment(String comment) {
        return comment == null || comment.isEmpty() ? FROM_SERIALIZER : comment;
    }

    public static FieldSchema getFieldSchemaFromTypeInfo(String fieldName, TypeInfo typeInfo) {
        return new FieldSchema(fieldName, typeInfo.getTypeName(), "generated by TypeInfoUtils.getFieldSchemaFromTypeInfo");
    }

    public static boolean isExternalTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return "TRUE".equalsIgnoreCase(params.get("EXTERNAL"));
    }

    public static boolean isArchived(Partition part) {
        Map<String, String> params = part.getParameters();
        return "true".equalsIgnoreCase(params.get("is_archived"));
    }

    public static Path getOriginalLocation(Partition part) {
        Map<String, String> params = part.getParameters();
        assert (MetaStoreUtils.isArchived(part));
        String originalLocation = params.get("original_location");
        assert (originalLocation != null);
        return new Path(originalLocation);
    }

    public static boolean isNonNativeTable(Table table) {
        if (table == null) {
            return false;
        }
        return table.getParameters().get("storage_handler") != null;
    }

    public static boolean pvalMatches(List<String> partial, List<String> full) {
        if (partial.size() > full.size()) {
            return false;
        }
        Iterator<String> p = partial.iterator();
        Iterator<String> f = full.iterator();
        while (p.hasNext()) {
            String pval = p.next();
            String fval = f.next();
            if (pval.length() == 0 || pval.equals(fval)) continue;
            return false;
        }
        return true;
    }

    public static String getIndexTableName(String dbName, String baseTblName, String indexName) {
        return dbName + "__" + baseTblName + "_" + indexName + "__";
    }

    public static boolean isIndexTable(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.INDEX_TABLE.toString().equals(table.getTableType());
    }

    public static String makeFilterStringFromMap(Map<String, String> m) {
        StringBuilder filter = new StringBuilder();
        for (Map.Entry<String, String> e : m.entrySet()) {
            String col = e.getKey();
            String val = e.getValue();
            if (filter.length() == 0) {
                filter.append(col + "=\"" + val + "\"");
                continue;
            }
            filter.append(" and " + col + "=\"" + val + "\"");
        }
        return filter.toString();
    }

    static <T> List<T> getMetaStoreListeners(Class<T> clazz, HiveConf conf, String listenerImplList) throws MetaException {
        String[] listenerImpls;
        ArrayList listeners = new ArrayList();
        if ((listenerImplList = listenerImplList.trim()).equals("")) {
            return listeners;
        }
        for (String listenerImpl : listenerImpls = listenerImplList.split(",")) {
            try {
                Object listener = Class.forName(listenerImpl.trim(), true, JavaUtils.getClassLoader()).getConstructor(Configuration.class).newInstance(conf);
                listeners.add(listener);
            }
            catch (InvocationTargetException ie) {
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + ie.getCause());
            }
            catch (Exception e) {
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + e);
            }
        }
        return listeners;
    }

    public static Class<?> getClass(String rawStoreClassName) throws MetaException {
        try {
            return Class.forName(rawStoreClassName, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MetaException(rawStoreClassName + " class not found");
        }
    }

    public static <T> T newInstance(Class<T> theClass, Class<?>[] parameterTypes, Object[] initargs) {
        if (parameterTypes.length != initargs.length) {
            throw new IllegalArgumentException("Number of constructor parameter types doesn't match number of arguments");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> clazz = parameterTypes[i];
            if (clazz.isInstance(initargs[i])) continue;
            throw new IllegalArgumentException("Object : " + initargs[i] + " is not an instance of " + clazz);
        }
        try {
            Constructor<T> meth = theClass.getDeclaredConstructor(parameterTypes);
            meth.setAccessible(true);
            return meth.newInstance(initargs);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + theClass.getName(), e);
        }
    }

    public static Map<String, String> getMetaStoreSaslProperties(HiveConf conf) {
        return ShimLoader.getHadoopThriftAuthBridge().getHadoopSaslProperties((Configuration)conf);
    }

    static {
        typeToThriftTypeMap.put("boolean", "bool");
        typeToThriftTypeMap.put("tinyint", "byte");
        typeToThriftTypeMap.put("smallint", "i16");
        typeToThriftTypeMap.put("int", "i32");
        typeToThriftTypeMap.put("bigint", "i64");
        typeToThriftTypeMap.put("double", "double");
        typeToThriftTypeMap.put("float", "float");
        typeToThriftTypeMap.put("array", "list");
        typeToThriftTypeMap.put("map", "map");
        typeToThriftTypeMap.put("string", "string");
        typeToThriftTypeMap.put("binary", "binary");
        typeToThriftTypeMap.put("date", "date");
        typeToThriftTypeMap.put("datetime", "datetime");
        typeToThriftTypeMap.put("timestamp", "timestamp");
        typeToThriftTypeMap.put("decimal", "decimal");
    }
}

