/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.protocol;

import java.util.BitSet;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TTransport;

public final class TTupleProtocol
extends TCompactProtocol {
    public TTupleProtocol(TTransport transport) {
        super(transport);
    }

    @Override
    public Class<? extends IScheme> getScheme() {
        return TupleScheme.class;
    }

    public void writeBitSet(BitSet bs, int vectorWidth) throws TException {
        byte[] bytes;
        byte[] byArray = bytes = TTupleProtocol.toByteArray(bs, vectorWidth);
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.writeByte(b);
            ++n2;
        }
    }

    public BitSet readBitSet(int i) throws TException {
        int length = (int)Math.ceil((double)i / 8.0);
        byte[] bytes = new byte[length];
        int j = 0;
        while (j < length) {
            bytes[j] = this.readByte();
            ++j;
        }
        BitSet bs = TTupleProtocol.fromByteArray(bytes);
        return bs;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        int i = 0;
        while (i < bytes.length * 8) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) > 0) {
                bits.set(i);
            }
            ++i;
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits, int vectorWidth) {
        byte[] bytes = new byte[(int)Math.ceil((double)vectorWidth / 8.0)];
        int i = 0;
        while (i < bits.length()) {
            if (bits.get(i)) {
                int n = bytes.length - i / 8 - 1;
                bytes[n] = (byte)(bytes[n] | 1 << i % 8);
            }
            ++i;
        }
        return bytes;
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TTupleProtocol(trans);
        }
    }
}

