/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.JettyShims;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.util.VersionInfo;

public abstract class ShimLoader {
    private static HadoopShims hadoopShims;
    private static JettyShims jettyShims;
    private static final HashMap<String, String> HADOOP_SHIM_CLASSES;
    private static final HashMap<String, String> JETTY_SHIM_CLASSES;

    public static synchronized HadoopShims getHadoopShims() {
        if (hadoopShims == null) {
            hadoopShims = ShimLoader.loadShims(HADOOP_SHIM_CLASSES, HadoopShims.class);
        }
        return hadoopShims;
    }

    public static synchronized JettyShims getJettyShims() {
        if (jettyShims == null) {
            jettyShims = ShimLoader.loadShims(JETTY_SHIM_CLASSES, JettyShims.class);
        }
        return jettyShims;
    }

    public static synchronized HadoopThriftAuthBridge getHadoopThriftAuthBridge() {
        if (ShimLoader.getHadoopShims().isSecureShimImpl()) {
            return ShimLoader.createShim("org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge20S", HadoopThriftAuthBridge.class);
        }
        return new HadoopThriftAuthBridge();
    }

    private static <T> T loadShims(Map<String, String> classMap, Class<T> xface) {
        String vers = ShimLoader.getMajorVersion();
        String className = classMap.get(vers);
        return ShimLoader.createShim(className, xface);
    }

    private static <T> T createShim(String className, Class<T> xface) {
        try {
            Class<?> clazz = Class.forName(className);
            return xface.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load shims in class " + className, e);
        }
    }

    public static String getMajorVersion() {
        String majorVersion;
        block8: {
            String vers = VersionInfo.getVersion();
            String[] parts = vers.split("\\.");
            if (parts.length < 2) {
                throw new RuntimeException("Illegal Hadoop Version: " + vers + " (expected A.B.* format)");
            }
            switch (Integer.parseInt(parts[0])) {
                case 0: {
                    break;
                }
                case 1: {
                    return "0.20S";
                }
                case 2: {
                    return "0.23";
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized Hadoop major version number: " + vers);
                }
            }
            majorVersion = parts[0] + "." + parts[1];
            try {
                Class.forName("org.apache.hadoop.security.UnixUserGroupInformation");
            }
            catch (ClassNotFoundException cnf) {
                if (!"0.20".equals(majorVersion)) break block8;
                majorVersion = majorVersion + "S";
            }
        }
        return majorVersion;
    }

    private ShimLoader() {
    }

    static {
        HADOOP_SHIM_CLASSES = new HashMap();
        HADOOP_SHIM_CLASSES.put("0.20", "org.apache.hadoop.hive.shims.Hadoop20Shims");
        HADOOP_SHIM_CLASSES.put("0.20S", "org.apache.hadoop.hive.shims.Hadoop20SShims");
        HADOOP_SHIM_CLASSES.put("0.23", "org.apache.hadoop.hive.shims.Hadoop23Shims");
        JETTY_SHIM_CLASSES = new HashMap();
        JETTY_SHIM_CLASSES.put("0.20", "org.apache.hadoop.hive.shims.Jetty20Shims");
        JETTY_SHIM_CLASSES.put("0.20S", "org.apache.hadoop.hive.shims.Jetty20SShims");
        JETTY_SHIM_CLASSES.put("0.23", "org.apache.hadoop.hive.shims.Jetty23Shims");
    }
}

