/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="decimal", value="_FUNC_(a) - cast a to decimal")
public class GenericUDFToDecimal
extends GenericUDF {
    private PrimitiveObjectInspector argumentOI;
    private PrimitiveObjectInspectorConverter.BigDecimalConverter bdConverter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function DECIMAL requires at least one argument, got " + arguments.length);
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function DECIMAL takes only primitive types");
        }
        this.bdConverter = new PrimitiveObjectInspectorConverter.BigDecimalConverter(this.argumentOI, PrimitiveObjectInspectorFactory.writableBigDecimalObjectInspector);
        return PrimitiveObjectInspectorFactory.writableBigDecimalObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.bdConverter.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS DECIMAL)");
        return sb.toString();
    }
}

