/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.math.BigDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.BigDecimalWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="ceil,ceiling", value="_FUNC_(x) - Find the smallest integer not smaller than x", extended="Example:\n  > SELECT _FUNC_(-0.1) FROM src LIMIT 1;\n  0\n  > SELECT _FUNC_(5) FROM src LIMIT 1;\n  5")
public class UDFCeil
extends UDF {
    private final LongWritable longWritable = new LongWritable();
    private final BigDecimalWritable bigDecimalWritable = new BigDecimalWritable();

    public LongWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set((long)Math.ceil(i.get()));
        return this.longWritable;
    }

    public BigDecimalWritable evaluate(BigDecimalWritable i) {
        if (i == null) {
            return null;
        }
        BigDecimal bd = i.getBigDecimal();
        int origScale = bd.scale();
        this.bigDecimalWritable.set(bd.setScale(0, 2).setScale(origScale));
        return this.bigDecimalWritable;
    }
}

