/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.LoadDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class LoadTableDesc
extends LoadDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean replace;
    private String tmpDir;
    private DynamicPartitionCtx dpCtx;
    private boolean holdDDLTime;
    private boolean inheritTableSpecs = true;
    private TableDesc table;
    private Map<String, String> partitionSpec;

    public LoadTableDesc() {
        this.holdDDLTime = false;
    }

    public LoadTableDesc(Path sourcePath, String tmpDir, TableDesc table, Map<String, String> partitionSpec, boolean replace) {
        super(sourcePath);
        this.init(tmpDir, table, partitionSpec, replace);
    }

    public LoadTableDesc(Path sourcePath, String tmpDir, TableDesc table, Map<String, String> partitionSpec) {
        this(sourcePath, tmpDir, table, partitionSpec, true);
    }

    public LoadTableDesc(Path sourcePath, String tmpDir, TableDesc table, DynamicPartitionCtx dpCtx) {
        super(sourcePath);
        this.dpCtx = dpCtx;
        if (dpCtx != null && dpCtx.getPartSpec() != null && this.partitionSpec == null) {
            this.init(tmpDir, table, dpCtx.getPartSpec(), true);
        } else {
            this.init(tmpDir, table, new LinkedHashMap<String, String>(), true);
        }
    }

    private void init(String tmpDir, TableDesc table, Map<String, String> partitionSpec, boolean replace) {
        this.tmpDir = tmpDir;
        this.table = table;
        this.partitionSpec = partitionSpec;
        this.replace = replace;
        this.holdDDLTime = false;
    }

    public void setHoldDDLTime(boolean ddlTime) {
        this.holdDDLTime = ddlTime;
    }

    public boolean getHoldDDLTime() {
        return this.holdDDLTime;
    }

    @Explain(displayName="tmp directory", normalExplain=false)
    public String getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(String tmp) {
        this.tmpDir = tmp;
    }

    @Explain(displayName="table")
    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    @Explain(displayName="partition")
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public void setPartitionSpec(Map<String, String> partitionSpec) {
        this.partitionSpec = partitionSpec;
    }

    @Explain(displayName="replace")
    public boolean getReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public DynamicPartitionCtx getDPCtx() {
        return this.dpCtx;
    }

    public void setDPCtx(DynamicPartitionCtx dpCtx) {
        this.dpCtx = dpCtx;
    }

    public boolean getInheritTableSpecs() {
        return this.inheritTableSpecs;
    }

    public void setInheritTableSpecs(boolean inheritTableSpecs) {
        this.inheritTableSpecs = inheritTableSpecs;
    }
}

