/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="File Output Operator")
public class FileSinkDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private String dirName;
    private String statsKeyPref;
    private TableDesc tableInfo;
    private boolean compressed;
    private int destTableId;
    private String compressCodec;
    private String compressType;
    private boolean multiFileSpray;
    private int totalFiles;
    private ArrayList<ExprNodeDesc> partitionCols;
    private int numFiles;
    private DynamicPartitionCtx dpCtx;
    private String staticSpec;
    private boolean gatherStats;
    private boolean linkedFileSink = false;
    private String parentDir;
    private transient List<FileSinkDesc> linkedFileSinkDesc;
    private boolean statsReliable;

    public FileSinkDesc() {
    }

    public FileSinkDesc(String dirName, TableDesc tableInfo, boolean compressed, int destTableId, boolean multiFileSpray, int numFiles, int totalFiles, ArrayList<ExprNodeDesc> partitionCols, DynamicPartitionCtx dpCtx) {
        this.dirName = dirName;
        this.tableInfo = tableInfo;
        this.compressed = compressed;
        this.destTableId = destTableId;
        this.multiFileSpray = multiFileSpray;
        this.numFiles = numFiles;
        this.totalFiles = totalFiles;
        this.partitionCols = partitionCols;
        this.dpCtx = dpCtx;
    }

    public FileSinkDesc(String dirName, TableDesc tableInfo, boolean compressed) {
        this.dirName = dirName;
        this.tableInfo = tableInfo;
        this.compressed = compressed;
        this.destTableId = 0;
        this.multiFileSpray = false;
        this.numFiles = 1;
        this.totalFiles = 1;
        this.partitionCols = null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FileSinkDesc ret = new FileSinkDesc(this.dirName, this.tableInfo, this.compressed, this.destTableId, this.multiFileSpray, this.numFiles, this.totalFiles, this.partitionCols, this.dpCtx);
        ret.setCompressCodec(this.compressCodec);
        ret.setCompressType(this.compressType);
        ret.setGatherStats(this.gatherStats);
        ret.setStaticSpec(this.staticSpec);
        ret.setStatsAggPrefix(this.statsKeyPref);
        ret.setLinkedFileSink(this.linkedFileSink);
        ret.setParentDir(this.parentDir);
        ret.setLinkedFileSinkDesc(this.linkedFileSinkDesc);
        ret.setStatsReliable(this.statsReliable);
        return ret;
    }

    @Explain(displayName="directory", normalExplain=false)
    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getFinalDirName() {
        return this.linkedFileSink ? this.parentDir : this.dirName;
    }

    @Explain(displayName="table")
    public TableDesc getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableDesc tableInfo) {
        this.tableInfo = tableInfo;
    }

    @Explain(displayName="compressed")
    public boolean getCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Explain(displayName="GlobalTableId")
    public int getDestTableId() {
        return this.destTableId;
    }

    public void setDestTableId(int destTableId) {
        this.destTableId = destTableId;
    }

    public String getCompressCodec() {
        return this.compressCodec;
    }

    public void setCompressCodec(String intermediateCompressorCodec) {
        this.compressCodec = intermediateCompressorCodec;
    }

    public String getCompressType() {
        return this.compressType;
    }

    public void setCompressType(String intermediateCompressType) {
        this.compressType = intermediateCompressType;
    }

    @Explain(displayName="MultiFileSpray", normalExplain=false)
    public boolean isMultiFileSpray() {
        return this.multiFileSpray;
    }

    public void setMultiFileSpray(boolean multiFileSpray) {
        this.multiFileSpray = multiFileSpray;
    }

    @Explain(displayName="TotalFiles", normalExplain=false)
    public int getTotalFiles() {
        return this.totalFiles;
    }

    public void setTotalFiles(int totalFiles) {
        this.totalFiles = totalFiles;
    }

    public ArrayList<ExprNodeDesc> getPartitionCols() {
        return this.partitionCols;
    }

    public void setPartitionCols(ArrayList<ExprNodeDesc> partitionCols) {
        this.partitionCols = partitionCols;
    }

    @Explain(displayName="NumFilesPerFileSink", normalExplain=false)
    public int getNumFiles() {
        return this.numFiles;
    }

    public void setNumFiles(int numFiles) {
        this.numFiles = numFiles;
    }

    public void setDynPartCtx(DynamicPartitionCtx dpc) {
        this.dpCtx = dpc;
    }

    public DynamicPartitionCtx getDynPartCtx() {
        return this.dpCtx;
    }

    public void setStaticSpec(String staticSpec) {
        this.staticSpec = staticSpec;
    }

    @Explain(displayName="Static Partition Specification", normalExplain=false)
    public String getStaticSpec() {
        return this.staticSpec;
    }

    public void setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
    }

    @Explain(displayName="GatherStats", normalExplain=false)
    public boolean isGatherStats() {
        return this.gatherStats;
    }

    @Explain(displayName="Stats Publishing Key Prefix", normalExplain=false)
    public String getStatsAggPrefix() {
        return this.statsKeyPref;
    }

    public void setStatsAggPrefix(String k) {
        this.statsKeyPref = k.endsWith("/") ? k : k + "/";
    }

    public boolean isLinkedFileSink() {
        return this.linkedFileSink;
    }

    public void setLinkedFileSink(boolean linkedFileSink) {
        this.linkedFileSink = linkedFileSink;
    }

    public String getParentDir() {
        return this.parentDir;
    }

    public void setParentDir(String parentDir) {
        this.parentDir = parentDir;
    }

    public boolean isStatsReliable() {
        return this.statsReliable;
    }

    public void setStatsReliable(boolean statsReliable) {
        this.statsReliable = statsReliable;
    }

    public List<FileSinkDesc> getLinkedFileSinkDesc() {
        return this.linkedFileSinkDesc;
    }

    public void setLinkedFileSinkDesc(List<FileSinkDesc> linkedFileSinkDesc) {
        this.linkedFileSinkDesc = linkedFileSinkDesc;
    }
}

