/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.unionproc;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;

public class UnionProcContext
implements NodeProcessorCtx {
    private boolean mapOnlySubq = true;
    private ParseContext parseContext;
    private final Map<UnionOperator, UnionParseContext> uCtxMap = new HashMap<UnionOperator, UnionParseContext>();

    public boolean isMapOnlySubq() {
        return this.mapOnlySubq;
    }

    public void setMapOnlySubq(boolean mapOnlySubq) {
        this.mapOnlySubq = mapOnlySubq;
    }

    public void setUnionParseContext(UnionOperator u, UnionParseContext uCtx) {
        this.uCtxMap.put(u, uCtx);
    }

    public UnionParseContext getUnionParseContext(UnionOperator u) {
        return this.uCtxMap.get(u);
    }

    public ParseContext getParseContext() {
        return this.parseContext;
    }

    public void setParseContext(ParseContext parseContext) {
        this.parseContext = parseContext;
    }

    public static class UnionParseContext {
        private final transient boolean[] mapOnlySubq;
        private final transient boolean[] mapOnlySubqSet;
        private final transient boolean[] rootTask;
        private final transient boolean[] mapJoinSubq;
        private final transient int numInputs;
        private transient boolean mapJoinQuery;

        public UnionParseContext(int numInputs) {
            this.numInputs = numInputs;
            this.mapOnlySubq = new boolean[numInputs];
            this.rootTask = new boolean[numInputs];
            this.mapJoinSubq = new boolean[numInputs];
            this.mapOnlySubqSet = new boolean[numInputs];
        }

        public boolean getMapOnlySubq(int pos) {
            return this.mapOnlySubq[pos];
        }

        public void setMapOnlySubq(int pos, boolean mapOnlySubq) {
            this.mapOnlySubq[pos] = mapOnlySubq;
            this.mapOnlySubqSet[pos] = true;
        }

        public boolean getMapJoinSubq(int pos) {
            return this.mapJoinSubq[pos];
        }

        public void setMapJoinSubq(int pos, boolean mapJoinSubq) {
            this.mapJoinSubq[pos] = mapJoinSubq;
            if (mapJoinSubq) {
                this.mapJoinQuery = true;
            }
        }

        public boolean getMapJoinQuery() {
            return this.mapJoinQuery;
        }

        public boolean getRootTask(int pos) {
            return this.rootTask[pos];
        }

        public void setRootTask(int pos, boolean rootTask) {
            this.rootTask[pos] = rootTask;
        }

        public int getNumInputs() {
            return this.numInputs;
        }

        public boolean allMapOnlySubQ() {
            return this.isAllTrue(this.mapOnlySubq);
        }

        public boolean allMapOnlySubQSet() {
            return this.isAllTrue(this.mapOnlySubqSet);
        }

        public boolean allRootTasks() {
            return this.isAllTrue(this.rootTask);
        }

        public boolean isAllTrue(boolean[] array) {
            for (boolean value : array) {
                if (value) continue;
                return false;
            }
            return true;
        }
    }
}

