/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;

public class HookContext {
    private QueryPlan queryPlan;
    private HiveConf conf;
    private List<TaskRunner> completeTaskList;
    private Set<ReadEntity> inputs;
    private Set<WriteEntity> outputs;
    private LineageInfo linfo;
    private UserGroupInformation ugi;
    private HookType hookType;
    private final Map<String, ContentSummary> inputPathToContentSummary;
    private final String ipAddress;
    private final String userName;

    public HookContext(QueryPlan queryPlan, HiveConf conf) throws Exception {
        this(queryPlan, conf, new ConcurrentHashMap<String, ContentSummary>(), null, null);
    }

    public HookContext(QueryPlan queryPlan, HiveConf conf, Map<String, ContentSummary> inputPathToContentSummary, String userName, String ipAddress) throws Exception {
        this.queryPlan = queryPlan;
        this.conf = conf;
        this.inputPathToContentSummary = inputPathToContentSummary;
        this.completeTaskList = new ArrayList<TaskRunner>();
        this.inputs = queryPlan.getInputs();
        this.outputs = queryPlan.getOutputs();
        this.ugi = ShimLoader.getHadoopShims().getUGIForConf(conf);
        this.linfo = null;
        if (SessionState.get() != null) {
            this.linfo = SessionState.get().getLineageState().getLineageInfo();
        }
        this.ipAddress = ipAddress;
        this.userName = userName;
    }

    public QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    public void setQueryPlan(QueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public List<TaskRunner> getCompleteTaskList() {
        return this.completeTaskList;
    }

    public void setCompleteTaskList(List<TaskRunner> completeTaskList) {
        this.completeTaskList = completeTaskList;
    }

    public void addCompleteTask(TaskRunner completeTaskRunner) {
        this.completeTaskList.add(completeTaskRunner);
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public void setInputs(Set<ReadEntity> inputs) {
        this.inputs = inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Set<WriteEntity> outputs) {
        this.outputs = outputs;
    }

    public LineageInfo getLinfo() {
        return this.linfo;
    }

    public void setLinfo(LineageInfo linfo) {
        this.linfo = linfo;
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public void setUgi(UserGroupInformation ugi) {
        this.ugi = ugi;
    }

    public Map<String, ContentSummary> getInputPathToContentSummary() {
        return this.inputPathToContentSummary;
    }

    public HookType getHookType() {
        return this.hookType;
    }

    public void setHookType(HookType hookType) {
        this.hookType = hookType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getOperationName() {
        return this.queryPlan.getOperationName();
    }

    public String getUserName() {
        return this.userName;
    }

    public static enum HookType {
        PRE_EXEC_HOOK,
        POST_EXEC_HOOK,
        ON_FAILURE_HOOK;

    }
}

