/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.errors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.errors.DataCorruptErrorHeuristic;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.ErrorHeuristic;
import org.apache.hadoop.hive.ql.exec.errors.MapAggrMemErrorHeuristic;
import org.apache.hadoop.hive.ql.exec.errors.ScriptErrorHeuristic;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;

public class TaskLogProcessor {
    private final Log LOG = LogFactory.getLog(TaskLogProcessor.class);
    private final Map<ErrorHeuristic, HeuristicStats> heuristics = new HashMap<ErrorHeuristic, HeuristicStats>();
    private final List<String> taskLogUrls = new ArrayList<String>();
    private JobConf conf = null;
    private String query = null;

    public TaskLogProcessor(JobConf conf) {
        this.conf = conf;
        this.query = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVEQUERYSTRING);
        this.heuristics.put(new ScriptErrorHeuristic(), new HeuristicStats());
        this.heuristics.put(new MapAggrMemErrorHeuristic(), new HeuristicStats());
        this.heuristics.put(new DataCorruptErrorHeuristic(), new HeuristicStats());
        for (ErrorHeuristic e : this.heuristics.keySet()) {
            e.init(this.query, conf);
        }
    }

    public void addTaskAttemptLogUrl(String url) {
        this.taskLogUrls.add(url);
    }

    public List<ErrorAndSolution> getErrors() {
        for (String urlString : this.taskLogUrls) {
            URL taskAttemptLogUrl;
            try {
                taskAttemptLogUrl = new URL(urlString);
            }
            catch (MalformedURLException e) {
                this.LOG.error((Object)"Bad task log URL", (Throwable)e);
                continue;
            }
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(taskAttemptLogUrl.openStream()));
                while ((inputLine = in.readLine()) != null) {
                    for (ErrorHeuristic e : this.heuristics.keySet()) {
                        e.processLogLine(inputLine);
                    }
                }
                in.close();
            }
            catch (IOException e) {
                this.LOG.error((Object)"Error while reading from task log URL", (Throwable)e);
                continue;
            }
            for (Map.Entry<ErrorHeuristic, HeuristicStats> ent : this.heuristics.entrySet()) {
                ErrorHeuristic eh = ent.getKey();
                HeuristicStats hs = ent.getValue();
                ErrorAndSolution es = eh.getErrorAndSolution();
                if (es == null) continue;
                hs.incTriggerCount();
                hs.addErrorAndSolution(es);
            }
        }
        int max = 0;
        for (HeuristicStats hs : this.heuristics.values()) {
            if (hs.getTriggerCount() <= max) continue;
            max = hs.getTriggerCount();
        }
        ArrayList<ErrorAndSolution> errors = new ArrayList<ErrorAndSolution>();
        for (HeuristicStats hs : this.heuristics.values()) {
            if (hs.getTriggerCount() != max || hs.getErrorAndSolutions().size() <= 0) continue;
            errors.add(hs.getErrorAndSolutions().get(0));
        }
        return errors;
    }

    public List<List<String>> getStackTraces() {
        ArrayList<List<String>> stackTraces = new ArrayList<List<String>>();
        for (String urlString : this.taskLogUrls) {
            URL taskAttemptLogUrl;
            try {
                taskAttemptLogUrl = new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Bad task log url", e);
            }
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(taskAttemptLogUrl.openStream()));
                String lastLine = null;
                boolean lastLineMatched = false;
                ArrayList<String> stackTrace = null;
                Pattern stackTracePattern = Pattern.compile("^\tat .*", 2);
                Pattern endStackTracePattern = Pattern.compile("^\t... [0-9]+ more.*", 2);
                while ((inputLine = ShimLoader.getHadoopShims().unquoteHtmlChars(in.readLine())) != null) {
                    if (stackTracePattern.matcher(inputLine).matches() || endStackTracePattern.matcher(inputLine).matches()) {
                        if (stackTrace == null) {
                            stackTrace = new ArrayList<String>();
                            stackTrace.add(lastLine);
                        } else if (!lastLineMatched) {
                            stackTrace.add(lastLine);
                        }
                        stackTrace.add(inputLine);
                        lastLineMatched = true;
                    } else {
                        if (!lastLineMatched && stackTrace != null) {
                            stackTraces.add(stackTrace);
                            stackTrace = null;
                        }
                        lastLineMatched = false;
                    }
                    lastLine = inputLine;
                }
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading from task log url", e);
            }
        }
        return stackTraces;
    }

    private static class HeuristicStats {
        private int triggerCount = 0;
        private final List<ErrorAndSolution> ens = new ArrayList<ErrorAndSolution>();

        HeuristicStats() {
        }

        int getTriggerCount() {
            return this.triggerCount;
        }

        void incTriggerCount() {
            ++this.triggerCount;
        }

        List<ErrorAndSolution> getErrorAndSolutions() {
            return this.ens;
        }

        void addErrorAndSolution(ErrorAndSolution e) {
            this.ens.add(e);
        }
    }
}

