/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CachingPrintStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SecureCmdDoAs;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.HashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class MapredLocalTask
extends Task<MapredLocalWork>
implements Serializable {
    private Map<String, FetchOperator> fetchOperators;
    protected HadoopJobExecHelper jobExecHelper;
    private JobConf job;
    public static final transient Log l4j = LogFactory.getLog(MapredLocalTask.class);
    static final String HADOOP_MEM_KEY = "HADOOP_HEAPSIZE";
    static final String HADOOP_OPTS_KEY = "HADOOP_OPTS";
    static final String[] HIVE_SYS_PROP = new String[]{"build.dir", "build.dir.hive"};
    public static MemoryMXBean memoryMXBean;
    private static final Log LOG;
    private final ExecMapperContext execContext = new ExecMapperContext();
    private Process executor;

    public MapredLocalTask() {
    }

    public MapredLocalTask(MapredLocalWork plan, JobConf job, boolean isSilent) throws HiveException {
        this.setWork(plan);
        this.job = job;
        this.console = new SessionState.LogHelper(LOG, isSilent);
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        super.initialize(conf, queryPlan, driverContext);
        this.job = new JobConf((Configuration)conf, ExecDriver.class);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, null);
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        return sdf.format(cal.getTime());
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            Context ctx = driverContext.getCtx();
            String hiveJar = this.conf.getJar();
            String hadoopExec = this.conf.getVar(HiveConf.ConfVars.HADOOPBIN);
            Path planPath = new Path(ctx.getLocalTmpFileURI(), "plan.xml");
            FSDataOutputStream out = FileSystem.getLocal((Configuration)this.conf).create(planPath);
            MapredLocalWork plan = (MapredLocalWork)this.getWork();
            LOG.info((Object)("Generating plan file " + planPath.toString()));
            Utilities.serializeMapRedLocalWork(plan, (OutputStream)out);
            String isSilent = "true".equalsIgnoreCase(System.getProperty("test.silent")) ? "-nolog" : "";
            String jarCmd = hiveJar + " " + ExecDriver.class.getName();
            String hiveConfArgs = ExecDriver.generateCmdLine(this.conf, ctx);
            String cmdLine = hadoopExec + " jar " + jarCmd + " -localtask -plan " + planPath.toString() + " " + isSilent + " " + hiveConfArgs;
            String workDir = new File(".").getCanonicalPath();
            String files = Utilities.getResourceFiles(this.conf, SessionState.ResourceType.FILE);
            if (!files.isEmpty()) {
                cmdLine = cmdLine + " -files " + files;
                workDir = new Path(ctx.getLocalTmpFileURI()).toUri().getPath();
                if (!new File(workDir).mkdir()) {
                    throw new IOException("Cannot create tmp working dir: " + workDir);
                }
                for (String f : StringUtils.split(files, ',')) {
                    String link;
                    Path p = new Path(f);
                    String target = p.toUri().getPath();
                    if (FileUtil.symLink((String)target, (String)(link = workDir + "/" + p.getName())) == 0) continue;
                    throw new IOException("Cannot link to added file: " + target + " from: " + link);
                }
            }
            StringBuilder sb = new StringBuilder();
            Properties p = System.getProperties();
            for (String element : HIVE_SYS_PROP) {
                if (!p.containsKey(element)) continue;
                sb.append(" -D" + element + "=" + p.getProperty(element));
            }
            String hadoopOpts = sb.toString();
            HashMap<String, String> variables = new HashMap<String, String>(System.getenv());
            int hadoopMem = this.conf.getIntVar(HiveConf.ConfVars.HIVEHADOOPMAXMEM);
            if (hadoopMem == 0) {
                variables.remove(HADOOP_MEM_KEY);
            } else {
                this.console.printInfo(" set heap size\t" + hadoopMem + "MB");
                variables.put(HADOOP_MEM_KEY, String.valueOf(hadoopMem));
            }
            HadoopShims shim = ShimLoader.getHadoopShims();
            String endUserName = shim.getShortUserName(shim.getUGIForConf((Configuration)this.job));
            this.console.printInfo("setting HADOOP_USER_NAME\t" + endUserName);
            variables.put("HADOOP_USER_NAME", endUserName);
            if (variables.containsKey(HADOOP_OPTS_KEY)) {
                variables.put(HADOOP_OPTS_KEY, (String)variables.get(HADOOP_OPTS_KEY) + hadoopOpts);
            } else {
                variables.put(HADOOP_OPTS_KEY, hadoopOpts);
            }
            if (variables.containsKey("HIVE_DEBUG_RECURSIVE")) {
                MapRedTask.configureDebugVariablesForChildJVM(variables);
            }
            if (ShimLoader.getHadoopShims().isSecurityEnabled() && ShimLoader.getHadoopShims().isLoginKeytabBased()) {
                SecureCmdDoAs secureDoAs = new SecureCmdDoAs(this.conf);
                secureDoAs.addEnv(variables);
            }
            String[] env = new String[variables.size()];
            int pos = 0;
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                env[pos++] = name + "=" + value;
                LOG.debug((Object)("Setting env: " + env[pos - 1]));
            }
            LOG.info((Object)("Executing: " + cmdLine));
            this.executor = Runtime.getRuntime().exec(cmdLine, env, new File(workDir));
            CachingPrintStream errPrintStream = new CachingPrintStream(System.err);
            Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(this.executor.getInputStream(), null, System.out);
            Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(this.executor.getErrorStream(), null, errPrintStream);
            outPrinter.start();
            errPrinter.start();
            int exitVal = this.jobExecHelper.progressLocal(this.executor, this.getId());
            if (exitVal != 0) {
                LOG.error((Object)("Execution failed with exit status: " + exitVal));
                if (SessionState.get() != null) {
                    SessionState.get().addLocalMapRedErrors(this.getId(), errPrintStream.getOutput());
                }
            } else {
                LOG.info((Object)"Execution completed successfully");
                this.console.printInfo("Mapred Local Task Succeeded . Convert the Join into MapJoin");
            }
            return exitVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)("Exception: " + e.getMessage()));
            return 1;
        }
    }

    public int executeFromChildJVM(DriverContext driverContext) {
        if (this.work == null) {
            return -1;
        }
        memoryMXBean = ManagementFactory.getMemoryMXBean();
        long startTime = System.currentTimeMillis();
        this.console.printInfo(Utilities.now() + "\tStarting to launch local task to process map join;\tmaximum memory = " + memoryMXBean.getHeapMemoryUsage().getMax());
        this.fetchOperators = new HashMap<String, FetchOperator>();
        HashMap<FetchOperator, JobConf> fetchOpJobConfMap = new HashMap<FetchOperator, JobConf>();
        this.execContext.setJc(this.job);
        this.execContext.setLocalWork((MapredLocalWork)this.work);
        boolean inputFileChangeSenstive = ((MapredLocalWork)this.work).getInputFileChangeSensitive();
        try {
            this.initializeOperators(fetchOpJobConfMap);
            if (inputFileChangeSenstive) {
                for (Map<String, List<String>> bigTableBucketFiles : ((MapredLocalWork)this.work).getBucketMapjoinContext().getAliasBucketFileNameMapping().values()) {
                    for (String bigTableBucket : bigTableBucketFiles.keySet()) {
                        this.startForward(inputFileChangeSenstive, bigTableBucket);
                    }
                }
            } else {
                this.startForward(inputFileChangeSenstive, null);
            }
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - startTime;
            this.console.printInfo(Utilities.now() + "\tEnd of local task; Time Taken: " + Utilities.showTime(elapsed) + " sec.");
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError || e instanceof HiveException && e.getMessage().equals("RunOutOfMeomoryUsage")) {
                return 3;
            }
            l4j.error((Object)"Hive Runtime Error: Map local work failed");
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    private void startForward(boolean inputFileChangeSenstive, String bigTableBucket) throws Exception {
        block0: for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
            int fetchOpRows = 0;
            String alias = entry.getKey();
            FetchOperator fetchOp = entry.getValue();
            if (inputFileChangeSenstive) {
                fetchOp.clearFetchContext();
                this.setUpFetchOpContext(fetchOp, alias, bigTableBucket);
            }
            Operator<? extends OperatorDesc> forwardOp = ((MapredLocalWork)this.work).getAliasToWork().get(alias);
            if (fetchOp.isEmptyTable()) {
                this.generateDummyHashTable(alias, bigTableBucket);
                forwardOp.close(false);
                continue;
            }
            do {
                InspectableObject row;
                if ((row = fetchOp.getNextRow()) == null) {
                    if (inputFileChangeSenstive) {
                        this.execContext.setCurrentBigBucketFile(bigTableBucket);
                        forwardOp.reset();
                    }
                    forwardOp.close(false);
                    continue block0;
                }
                ++fetchOpRows;
                forwardOp.process(row.o, 0);
            } while (!forwardOp.getDone());
        }
    }

    private void initializeOperators(Map<FetchOperator, JobConf> fetchOpJobConfMap) throws HiveException {
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : ((MapredLocalWork)this.work).getAliasToWork().entrySet()) {
            LOG.debug((Object)("initializeOperators: " + entry.getKey() + ", children = " + entry.getValue().getChildOperators()));
        }
        for (Map.Entry<String, Serializable> entry : ((MapredLocalWork)this.work).getAliasToFetchWork().entrySet()) {
            ArrayList<Integer> list;
            JobConf jobClone = new JobConf((Configuration)this.job);
            Operator<? extends OperatorDesc> tableScan = ((MapredLocalWork)this.work).getAliasToWork().get(entry.getKey());
            boolean setColumnsNeeded = false;
            if (tableScan instanceof TableScanOperator && (list = ((TableScanOperator)tableScan).getNeededColumnIDs()) != null) {
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobClone, list);
                setColumnsNeeded = true;
            }
            if (!setColumnsNeeded) {
                ColumnProjectionUtils.setFullyReadColumns((Configuration)jobClone);
            }
            FetchOperator fetchOp = new FetchOperator((FetchWork)entry.getValue(), jobClone);
            fetchOpJobConfMap.put(fetchOp, jobClone);
            this.fetchOperators.put(entry.getKey(), fetchOp);
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " created"));
        }
        for (Map.Entry<String, Serializable> entry : this.fetchOperators.entrySet()) {
            String alias = entry.getKey();
            Operator<? extends OperatorDesc> forwardOp = ((MapredLocalWork)this.work).getAliasToWork().get(alias);
            forwardOp.setExecContext(this.execContext);
            FetchOperator fetchOp = (FetchOperator)entry.getValue();
            JobConf jobConf = fetchOpJobConfMap.get(fetchOp);
            if (jobConf == null) {
                jobConf = this.job;
            }
            ObjectInspector objectInspector = fetchOp.getOutputObjectInspector();
            forwardOp.initialize((Configuration)jobConf, new ObjectInspector[]{objectInspector});
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " initialized"));
        }
    }

    private void generateDummyHashTable(String alias, String bigBucketFileName) throws HiveException, IOException {
        LOG.debug((Object)("generating dummy for " + alias));
        Operator<? extends OperatorDesc> parentOp = ((MapredLocalWork)this.work).getAliasToWork().get(alias);
        Operator<OperatorDesc> childOp = parentOp.getChildOperators().get(0);
        while (childOp != null && !(childOp instanceof HashTableSinkOperator)) {
            parentOp = childOp;
            assert (parentOp.getChildOperators().size() == 1);
            childOp = parentOp.getChildOperators().get(0);
        }
        if (childOp == null) {
            throw new HiveException("Cannot find HashTableSink op by tracing down the table scan operator tree");
        }
        byte tag = (byte)childOp.getParentOperators().indexOf(parentOp);
        String tmpURI = ((MapredLocalWork)this.getWork()).getTmpFileURI();
        HashMapWrapper hashTable = new HashMapWrapper();
        String fileName = ((MapredLocalWork)this.work).getBucketFileName(bigBucketFileName);
        HashTableSinkOperator htso = (HashTableSinkOperator)childOp;
        String tmpURIPath = Utilities.generatePath(tmpURI, ((HashTableSinkDesc)htso.getConf()).getDumpFilePrefix(), tag, fileName);
        this.console.printInfo(Utilities.now() + "\tDump the hashtable into file: " + tmpURIPath);
        Path path = new Path(tmpURIPath);
        FileSystem fs = path.getFileSystem((Configuration)this.job);
        File file = new File(path.toUri().getPath());
        fs.create(path);
        long fileLength = hashTable.flushMemoryCacheToPersistent(file);
        this.console.printInfo(Utilities.now() + "\tUpload 1 File to: " + tmpURIPath + " File size: " + fileLength);
        hashTable.close();
    }

    private void setUpFetchOpContext(FetchOperator fetchOp, String alias, String currentInputFile) throws Exception {
        BucketMapJoinContext bucketMatcherCxt = ((MapredLocalWork)this.work).getBucketMapjoinContext();
        Class<? extends BucketMatcher> bucketMatcherCls = bucketMatcherCxt.getBucketMatcherClass();
        BucketMatcher bucketMatcher = (BucketMatcher)ReflectionUtils.newInstance(bucketMatcherCls, null);
        bucketMatcher.setAliasBucketFileNameMapping(bucketMatcherCxt.getAliasBucketFileNameMapping());
        List<Path> aliasFiles = bucketMatcher.getAliasBucketFiles(currentInputFile, bucketMatcherCxt.getMapJoinBigTableAlias(), alias);
        fetchOp.setupContext(aliasFiles);
    }

    @Override
    public void localizeMRTmpFilesImpl(Context ctx) {
    }

    @Override
    public boolean isMapRedLocalTask() {
        return true;
    }

    @Override
    public Collection<Operator<? extends OperatorDesc>> getTopOperators() {
        return ((MapredLocalWork)this.getWork()).getAliasToWork().values();
    }

    @Override
    public String getName() {
        return "MAPREDLOCAL";
    }

    @Override
    public StageType getType() {
        return StageType.MAPREDLOCAL;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.executor != null) {
            this.executor.destroy();
            this.executor = null;
        }
    }

    static {
        LOG = LogFactory.getLog(MapredLocalTask.class);
    }
}

