/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

public class ColumnStatsTask
extends Task<ColumnStatsWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FetchOperator ftOp;
    private int totalRows;
    private int numRows = 0;
    private static final transient Log LOG = LogFactory.getLog(ColumnStatsTask.class);

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        ((ColumnStatsWork)this.work).initializeForFetch();
        try {
            JobConf job = new JobConf((Configuration)conf, ExecDriver.class);
            this.ftOp = new FetchOperator(((ColumnStatsWork)this.work).getfWork(), job);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private void unpackBooleanStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        long v = ((LongObjectInspector)oi).get(o);
        if (fName.equals("counttrues")) {
            statsObj.getStatsData().getBooleanStats().setNumTrues(v);
        } else if (fName.equals("countfalses")) {
            statsObj.getStatsData().getBooleanStats().setNumFalses(v);
        } else if (fName.equals("countnulls")) {
            statsObj.getStatsData().getBooleanStats().setNumNulls(v);
        }
    }

    private void unpackDoubleStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setNumDVs(v);
        } else if (fName.equals("max")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setHighValue(d);
        } else if (fName.equals("min")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getDoubleStats().setLowValue(d);
        }
    }

    private void unpackLongStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setNumDVs(v);
        } else if (fName.equals("max")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setHighValue(v);
        } else if (fName.equals("min")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getLongStats().setLowValue(v);
        }
    }

    private void unpackStringStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setNumNulls(v);
        } else if (fName.equals("numdistinctvalues")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setNumDVs(v);
        } else if (fName.equals("avglength")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setAvgColLen(d);
        } else if (fName.equals("maxlength")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getStringStats().setMaxColLen(v);
        }
    }

    private void unpackBinaryStats(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj statsObj) {
        if (fName.equals("countnulls")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getBinaryStats().setNumNulls(v);
        } else if (fName.equals("avglength")) {
            double d = ((DoubleObjectInspector)oi).get(o);
            statsObj.getStatsData().getBinaryStats().setAvgColLen(d);
        } else if (fName.equals("maxlength")) {
            long v = ((LongObjectInspector)oi).get(o);
            statsObj.getStatsData().getBinaryStats().setMaxColLen(v);
        }
    }

    private void unpackPrimitiveObject(ObjectInspector oi, Object o, String fieldName, ColumnStatisticsObj statsObj) {
        if (fieldName.equals("columntype")) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
            String s = ((StringObjectInspector)poi).getPrimitiveJavaObject(o);
            ColumnStatisticsData statsData = new ColumnStatisticsData();
            if (s.equalsIgnoreCase("long")) {
                LongColumnStatsData longStats = new LongColumnStatsData();
                statsData.setLongStats(longStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("double")) {
                DoubleColumnStatsData doubleStats = new DoubleColumnStatsData();
                statsData.setDoubleStats(doubleStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("string")) {
                StringColumnStatsData stringStats = new StringColumnStatsData();
                statsData.setStringStats(stringStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("boolean")) {
                BooleanColumnStatsData booleanStats = new BooleanColumnStatsData();
                statsData.setBooleanStats(booleanStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase("binary")) {
                BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
                statsData.setBinaryStats(binaryStats);
                statsObj.setStatsData(statsData);
            }
        } else if (statsObj.getStatsData().isSetBooleanStats()) {
            this.unpackBooleanStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            this.unpackLongStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            this.unpackDoubleStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            this.unpackStringStats(oi, o, fieldName, statsObj);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            this.unpackBinaryStats(oi, o, fieldName, statsObj);
        }
    }

    private void unpackStructObject(ObjectInspector oi, Object o, String fName, ColumnStatisticsObj cStatsObj) {
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new RuntimeException("Invalid object datatype : " + oi.getCategory().toString());
        }
        StructObjectInspector soi = (StructObjectInspector)oi;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(o);
        for (int i = 0; i < fields.size(); ++i) {
            ObjectInspector foi = fields.get(i).getFieldObjectInspector();
            Object f = list == null ? null : list.get(i);
            String fieldName = fields.get(i).getFieldName();
            if (foi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                this.unpackPrimitiveObject(foi, f, fieldName, cStatsObj);
                continue;
            }
            this.unpackStructObject(foi, f, fieldName, cStatsObj);
        }
    }

    private ColumnStatistics constructColumnStatsFromPackedRow(ObjectInspector oi, Object o) throws HiveException {
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new HiveException("Unexpected object type encountered while unpacking row");
        }
        String dbName = this.db.getCurrentDatabase();
        String tableName = ((ColumnStatsWork)this.work).getColStats().getTableName();
        String partName = null;
        List<String> colName = ((ColumnStatsWork)this.work).getColStats().getColName();
        List<String> colType = ((ColumnStatsWork)this.work).getColStats().getColType();
        boolean isTblLevel = ((ColumnStatsWork)this.work).getColStats().isTblLevel();
        if (!isTblLevel) {
            partName = ((ColumnStatsWork)this.work).getColStats().getPartName();
        }
        ColumnStatisticsDesc statsDesc = this.getColumnStatsDesc(dbName, tableName, partName, isTblLevel);
        ArrayList<ColumnStatisticsObj> statsObjs = new ArrayList<ColumnStatisticsObj>();
        StructObjectInspector soi = (StructObjectInspector)oi;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(o);
        for (int i = 0; i < fields.size(); ++i) {
            ObjectInspector foi = fields.get(i).getFieldObjectInspector();
            Object f = list == null ? null : list.get(i);
            String fieldName = fields.get(i).getFieldName();
            ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
            statsObj.setColName(colName.get(i));
            statsObj.setColType(colType.get(i));
            this.unpackStructObject(foi, f, fieldName, statsObj);
            statsObjs.add(statsObj);
        }
        ColumnStatistics colStats = new ColumnStatistics();
        colStats.setStatsDesc(statsDesc);
        colStats.setStatsObj(statsObjs);
        return colStats;
    }

    private ColumnStatisticsDesc getColumnStatsDesc(String dbName, String tableName, String partName, boolean isTblLevel) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setDbName(dbName);
        statsDesc.setTableName(tableName);
        statsDesc.setIsTblLevel(isTblLevel);
        if (!isTblLevel) {
            statsDesc.setPartName(partName);
        } else {
            statsDesc.setPartName(null);
        }
        return statsDesc;
    }

    private int persistPartitionStats() throws HiveException {
        InspectableObject io = null;
        try {
            io = this.fetchColumnStats();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CommandNeedRetryException e) {
            e.printStackTrace();
        }
        if (io != null) {
            ColumnStatistics colStats = this.constructColumnStatsFromPackedRow(io.oi, io.o);
            try {
                this.db.updatePartitionColumnStatistics(colStats);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private int persistTableStats() throws HiveException {
        InspectableObject io = null;
        try {
            io = this.fetchColumnStats();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CommandNeedRetryException e) {
            e.printStackTrace();
        }
        if (io != null) {
            ColumnStatistics colStats = this.constructColumnStatsFromPackedRow(io.oi, io.o);
            try {
                this.db.updateTableColumnStatistics(colStats);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            if (((ColumnStatsWork)this.work).getColStats().isTblLevel()) {
                return this.persistTableStats();
            }
            return this.persistPartitionStats();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private InspectableObject fetchColumnStats() throws IOException, CommandNeedRetryException {
        InspectableObject io = null;
        try {
            int rowsRet = ((ColumnStatsWork)this.work).getLeastNumRows();
            if (rowsRet <= 0) {
                int n = rowsRet = ColumnStatsWork.getLimit() >= 0 ? Math.min(ColumnStatsWork.getLimit() - this.totalRows, 1) : 1;
            }
            if (rowsRet <= 0) {
                this.ftOp.clearFetchContext();
                return null;
            }
            while (this.numRows < rowsRet) {
                io = this.ftOp.getNextRow();
                if (io == null && ((ColumnStatsWork)this.work).getLeastNumRows() > 0) {
                    throw new CommandNeedRetryException();
                }
                ++this.numRows;
            }
            return io;
        }
        catch (CommandNeedRetryException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public StageType getType() {
        return StageType.COLUMNSTATS;
    }

    @Override
    public String getName() {
        return "COLUMNSTATS TASK";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
        ArrayList<String> ls;
        FetchWork fWork = ((ColumnStatsWork)this.work).getfWork();
        String s = fWork.getTblDir();
        if (s != null && ctx.isMRTmpFileURI(s)) {
            fWork.setTblDir(ctx.localizeMRTmpFileURI(s));
        }
        if ((ls = fWork.getPartDir()) != null) {
            ctx.localizePaths(ls);
        }
    }
}

