/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.HiveDriverFilterHook;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookContextImpl;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookResult;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.PostExecute;
import org.apache.hadoop.hive.ql.hooks.PreExecute;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContextImpl;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class Driver
implements CommandProcessor {
    private static final Log LOG = LogFactory.getLog((String)Driver.class.getName());
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private static final Object compileMonitor = new Object();
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private HiveConf conf;
    private DataInput resStream;
    private Context ctx;
    private QueryPlan plan;
    private Schema schema;
    private HiveLockManager hiveLockMgr;
    private String errorMessage;
    private String SQLState;
    private int maxthreads;
    private static final int SLEEP_TIME = 2000;
    protected int tryCount = Integer.MAX_VALUE;
    private String ipAddress;
    private String userName;
    private HiveOperation hiveOperation;

    private boolean checkLockManager() {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (!supportConcurrency) {
            return false;
        }
        if (this.hiveLockMgr == null) {
            try {
                this.setLockManager();
            }
            catch (SemanticException e) {
                this.errorMessage = "FAILED: Error in semantic analysis: " + e.getMessage();
                this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return false;
            }
        }
        this.ctx.setHiveLockMgr(this.hiveLockMgr);
        return this.hiveLockMgr != null;
    }

    private void setLockManager() throws SemanticException {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (supportConcurrency) {
            String lockMgr = this.conf.getVar(HiveConf.ConfVars.HIVE_LOCK_MANAGER);
            if (lockMgr == null || lockMgr.isEmpty()) {
                throw new SemanticException(ErrorMsg.LOCKMGR_NOT_SPECIFIED.getMsg());
            }
            try {
                this.hiveLockMgr = (HiveLockManager)ReflectionUtils.newInstance((Class)this.conf.getClassByName(lockMgr), (Configuration)this.conf);
                this.hiveLockMgr.setContext(new HiveLockManagerCtx(this.conf));
            }
            catch (Exception e) {
                if (this.hiveLockMgr != null) {
                    try {
                        this.hiveLockMgr.close();
                    }
                    catch (LockException e1) {
                        // empty catch block
                    }
                    this.hiveLockMgr = null;
                }
                throw new SemanticException(ErrorMsg.LOCKMGR_NOT_INITIALIZED.getMsg() + e.getMessage());
            }
        }
    }

    @Override
    public void init() {
        Operator.resetId();
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf, ExecDriver.class);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning cluster status: " + cs.toString()));
        return cs;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Schema getSchema(BaseSemanticAnalyzer sem, HiveConf conf) {
        Schema schema = null;
        if (sem != null) {
            if (sem.getResultSchema() != null) {
                List<FieldSchema> lst = sem.getResultSchema();
                schema = new Schema(lst, null);
            } else if (sem.getFetchTask() != null) {
                FetchTask ft = sem.getFetchTask();
                TableDesc td = ft.getTblDesc();
                if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    LOG.info((Object)"No returning schema.");
                } else {
                    String tableName = "result";
                    List lst = null;
                    try {
                        lst = MetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)td.getDeserializer());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error getting schema: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
                    }
                    if (lst != null) {
                        schema = new Schema(lst, null);
                    }
                }
            }
        }
        if (schema == null) {
            schema = new Schema();
        }
        LOG.info((Object)("Returning Hive schema: " + schema));
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(MetaStoreUtils.typeToThriftType((String)f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning Thrift schema: " + schema));
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean hasReduceTasks(List<Task<? extends Serializable>> tasks) {
        if (tasks == null) {
            return false;
        }
        boolean hasReduce = false;
        for (Task<? extends Serializable> task : tasks) {
            if (task.hasReduce()) {
                return true;
            }
            hasReduce = hasReduce || this.hasReduceTasks(task.getChildTasks());
        }
        return hasReduce;
    }

    public Driver(HiveConf conf) {
        this.conf = conf;
    }

    public Driver(HiveConf conf, String ipAddress, String userName) {
        this.conf = conf;
        this.ipAddress = ipAddress;
        this.userName = userName;
    }

    public Driver() {
        if (SessionState.get() != null) {
            this.conf = SessionState.get().getConf();
        }
    }

    public int compile(String command) {
        return this.compile(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse compileAndRespond(String command) {
        int ret;
        Object object = compileMonitor;
        synchronized (object) {
            ret = this.compile(command);
        }
        if (ret != 0) {
            this.releaseLocks(this.ctx.getHiveLocks());
        }
        return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState);
    }

    public void saveSession(QueryState qs) {
        SessionState oldss = SessionState.get();
        if (oldss != null && oldss.getHiveOperation() != null) {
            qs.init(oldss.getHiveOperation(), oldss.getCmd());
        }
    }

    public void restoreSession(QueryState qs) {
        SessionState ss = SessionState.get();
        if (ss != null && qs != null && qs.isInitialized()) {
            ss.setCmd(qs.getCmd());
            ss.setCommandType(qs.getOp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String command, boolean resetTaskIds) {
        ErrorMsg error;
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(LOG, "compile");
        QueryState queryState = new QueryState();
        if (this.plan != null) {
            this.close();
            this.plan = null;
        }
        if (resetTaskIds) {
            TaskFactory.resetId();
        }
        this.saveSession(queryState);
        try {
            command = new VariableSubstitution().substitute(this.conf, command);
            this.ctx = new Context(this.conf);
            this.ctx.setTryCount(this.getTryCount());
            this.ctx.setCmd(command);
            this.ctx.setHDFSCleanup(true);
            ParseDriver pd = new ParseDriver();
            ASTNode tree = pd.parse(command, this.ctx);
            tree = ParseUtils.findRootNonNullToken(tree);
            BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.conf, tree);
            List<AbstractSemanticAnalyzerHook> saHooks = this.getHooks(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, AbstractSemanticAnalyzerHook.class);
            if (saHooks != null) {
                HiveSemanticAnalyzerHookContextImpl hookCtx = new HiveSemanticAnalyzerHookContextImpl();
                hookCtx.setConf(this.conf);
                hookCtx.setUserName(this.userName);
                hookCtx.setIpAddress(this.ipAddress);
                hookCtx.setCommand(command);
                for (AbstractSemanticAnalyzerHook hook : saHooks) {
                    tree = hook.preAnalyze(hookCtx, tree);
                }
                sem.analyze(tree, this.ctx);
                hookCtx.update(sem);
                for (AbstractSemanticAnalyzerHook hook : saHooks) {
                    hook.postAnalyze(hookCtx, sem.getRootTasks());
                }
            } else {
                sem.analyze(tree, this.ctx);
            }
            LOG.info((Object)"Semantic Analysis Completed");
            sem.validate();
            this.hiveOperation = SessionState.get().getHiveOperation();
            this.plan = new QueryPlan(command, sem, perfLogger.getStartTime("Driver.run"), SessionState.get().getCommandType());
            if ("true".equalsIgnoreCase(System.getProperty("test.serialize.qplan"))) {
                String queryPlanFileName = this.ctx.getLocalScratchDir(true) + '/' + "queryplan.xml";
                LOG.info((Object)("query plan = " + queryPlanFileName));
                queryPlanFileName = new Path(queryPlanFileName).toUri().getPath();
                FileOutputStream fos = new FileOutputStream(queryPlanFileName);
                Utilities.serializeQueryPlan(this.plan, fos);
                fos.close();
                FileInputStream fis = new FileInputStream(queryPlanFileName);
                QueryPlan newPlan = Utilities.deserializeQueryPlan(fis, this.conf);
                fis.close();
                this.plan = newPlan;
            }
            if (this.plan.getFetchTask() != null) {
                this.plan.getFetchTask().initialize(this.conf, this.plan, null);
            }
            this.schema = Driver.getSchema(sem, this.conf);
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
                try {
                    perfLogger.PerfLogBegin(LOG, "doAuthorization");
                    this.doAuthorization(sem);
                }
                catch (AuthorizationException authExp) {
                    console.printError("Authorization failed:" + authExp.getMessage() + ". Use show grant to get more details.");
                    int n = 403;
                    perfLogger.PerfLogEnd(LOG, "compile");
                    this.restoreSession(queryState);
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            error = ErrorMsg.getErrorMsg(e.getMessage());
            this.errorMessage = "FAILED: " + e.getClass().getSimpleName();
            if (error != ErrorMsg.GENERIC_ERROR) {
                this.errorMessage = this.errorMessage + " [Error " + error.getErrorCode() + "]:";
            }
            this.errorMessage = e instanceof IllegalArgumentException && e.getMessage() == null && e.getCause() != null ? this.errorMessage + " " + e.getCause().getMessage() : this.errorMessage + " " + e.getMessage();
            this.SQLState = error.getSQLState();
        }
        {
            finally {
                perfLogger.PerfLogEnd(LOG, "doAuthorization");
            }
        }
        {
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = error.getErrorCode();
            return n;
        }
        finally {
            perfLogger.PerfLogEnd(LOG, "compile");
            this.restoreSession(queryState);
        }
    }

    private void doAuthorization(BaseSemanticAnalyzer sem) throws HiveException, AuthorizationException {
        HashSet<ReadEntity> inputs = sem.getInputs();
        HashSet<WriteEntity> outputs = sem.getOutputs();
        SessionState ss = SessionState.get();
        HiveOperation op = ss.getHiveOperation();
        Hive db = sem.getDb();
        if (op != null) {
            ImportSemanticAnalyzer isa;
            if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.CREATETABLE)) {
                ss.getAuthorizer().authorize(db.getDatabase(db.getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
            } else if (op.equals((Object)HiveOperation.IMPORT) && !(isa = (ImportSemanticAnalyzer)sem).existsTable()) {
                ss.getAuthorizer().authorize(db.getDatabase(db.getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
            }
            if (outputs != null && outputs.size() > 0) {
                for (WriteEntity write : outputs) {
                    Partition part;
                    if (write.getType() == Entity.Type.PARTITION && (part = db.getPartition(write.getTable(), write.getPartition().getSpec(), false)) != null) {
                        ss.getAuthorizer().authorize(write.getPartition(), null, op.getOutputRequiredPrivileges());
                        continue;
                    }
                    if (write.getTable() == null) continue;
                    ss.getAuthorizer().authorize(write.getTable(), null, op.getOutputRequiredPrivileges());
                }
            }
        }
        if (inputs != null && inputs.size() > 0) {
            HashMap tab2Cols = new HashMap();
            HashMap part2Cols = new HashMap();
            HashMap<String, Boolean> tableUsePartLevelAuth = new HashMap<String, Boolean>();
            for (ReadEntity read : inputs) {
                boolean usePartLevelPriv;
                String tblName;
                Table tbl = read.getTable();
                if (read.getPartition() == null && !tbl.isPartitioned() || tableUsePartLevelAuth.get(tblName = tbl.getTableName()) != null) continue;
                boolean bl = usePartLevelPriv = tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE") != null && "TRUE".equalsIgnoreCase(tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"));
                if (usePartLevelPriv) {
                    tableUsePartLevelAuth.put(tblName, Boolean.TRUE);
                    continue;
                }
                tableUsePartLevelAuth.put(tblName, Boolean.FALSE);
            }
            if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.QUERY)) {
                SemanticAnalyzer querySem = (SemanticAnalyzer)sem;
                ParseContext parseCtx = querySem.getParseContext();
                HashMap<TableScanOperator, Table> tsoTopMap = parseCtx.getTopToTable();
                for (Map.Entry<String, Operator<? extends OperatorDesc>> topOpMap : querySem.getParseContext().getTopOps().entrySet()) {
                    int i;
                    Operator<? extends OperatorDesc> topOp = topOpMap.getValue();
                    if (!(topOp instanceof TableScanOperator) || !tsoTopMap.containsKey(topOp)) continue;
                    TableScanOperator tableScanOp = (TableScanOperator)topOp;
                    Table tbl = (Table)tsoTopMap.get(tableScanOp);
                    ArrayList<Integer> neededColumnIds = tableScanOp.getNeededColumnIDs();
                    List<FieldSchema> columns = tbl.getCols();
                    ArrayList<String> cols = new ArrayList<String>();
                    if (neededColumnIds != null && neededColumnIds.size() > 0) {
                        for (i = 0; i < neededColumnIds.size(); ++i) {
                            cols.add(columns.get((Integer)neededColumnIds.get(i)).getName());
                        }
                    } else {
                        for (i = 0; i < columns.size(); ++i) {
                            cols.add(columns.get(i).getName());
                        }
                    }
                    if (tbl.isPartitioned() && tableUsePartLevelAuth.get(tbl.getTableName()) == Boolean.TRUE) {
                        String alias_id = topOpMap.getKey();
                        PrunedPartitionList partsList = PartitionPruner.prune(parseCtx.getTopToTable().get(topOp), parseCtx.getOpToPartPruner().get(topOp), parseCtx.getConf(), alias_id, parseCtx.getPrunedPartitions());
                        HashSet<Partition> parts = new HashSet<Partition>();
                        parts.addAll(partsList.getConfirmedPartns());
                        parts.addAll(partsList.getUnknownPartns());
                        for (Partition part : parts) {
                            ArrayList existingCols = (ArrayList)part2Cols.get(part);
                            if (existingCols == null) {
                                existingCols = new ArrayList();
                            }
                            existingCols.addAll(cols);
                            part2Cols.put(part, existingCols);
                        }
                        continue;
                    }
                    ArrayList existingCols = (ArrayList)tab2Cols.get(tbl);
                    if (existingCols == null) {
                        existingCols = new ArrayList();
                    }
                    existingCols.addAll(cols);
                    tab2Cols.put(tbl, existingCols);
                }
            }
            HashSet<String> tableAuthChecked = new HashSet<String>();
            for (ReadEntity read : inputs) {
                Partition partition;
                Table tbl = read.getTable();
                if (read.getPartition() != null && tableUsePartLevelAuth.get((tbl = (partition = read.getPartition()).getTable()).getTableName()) == Boolean.TRUE) {
                    List cols = (List)part2Cols.get(partition);
                    if (cols != null && cols.size() > 0) {
                        ss.getAuthorizer().authorize(partition.getTable(), partition, cols, op.getInputRequiredPrivileges(), null);
                        continue;
                    }
                    ss.getAuthorizer().authorize(partition, op.getInputRequiredPrivileges(), null);
                    continue;
                }
                if (tbl == null || tableAuthChecked.contains(tbl.getTableName()) || tableUsePartLevelAuth.get(tbl.getTableName()) == Boolean.TRUE) continue;
                List cols = (List)tab2Cols.get(tbl);
                if (cols != null && cols.size() > 0) {
                    ss.getAuthorizer().authorize(tbl, null, cols, op.getInputRequiredPrivileges(), null);
                } else {
                    ss.getAuthorizer().authorize(tbl, op.getInputRequiredPrivileges(), null);
                }
                tableAuthChecked.add(tbl.getTableName());
            }
        }
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    private List<HiveLockObj> getLockObjects(Table t, Partition p, HiveLockMode mode) throws SemanticException {
        LinkedList<HiveLockObj> locks = new LinkedList<HiveLockObj>();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(this.plan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT", this.plan.getQueryStr());
        if (t != null) {
            locks.add(new HiveLockObj(new HiveLockObject(t, lockData), mode));
            mode = HiveLockMode.SHARED;
            locks.add(new HiveLockObj(new HiveLockObject(t.getDbName(), lockData), mode));
            return locks;
        }
        if (p != null) {
            if (!(p instanceof DummyPartition)) {
                locks.add(new HiveLockObj(new HiveLockObject(p, lockData), mode));
            }
            mode = HiveLockMode.SHARED;
            String name = p.getName();
            if (p instanceof DummyPartition) {
                name = p.getName().split("@")[2];
            }
            String partialName = "";
            String[] partns = name.split("/");
            int len = p instanceof DummyPartition ? partns.length : partns.length - 1;
            LinkedHashMap<String, String> partialSpec = new LinkedHashMap<String, String>();
            for (int idx = 0; idx < len; ++idx) {
                String partn = partns[idx];
                partialName = partialName + partn;
                String[] nameValue = partn.split("=");
                assert (nameValue.length == 2);
                partialSpec.put(nameValue[0], nameValue[1]);
                try {
                    locks.add(new HiveLockObj(new HiveLockObject(new DummyPartition(p.getTable(), p.getTable().getDbName() + "/" + p.getTable().getTableName() + "/" + partialName, partialSpec), lockData), mode));
                    partialName = partialName + "/";
                    continue;
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage());
                }
            }
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable(), lockData), mode));
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable().getDbName(), lockData), mode));
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireReadWriteLocks() {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(LOG, "acquireReadWriteLocks");
        try {
            boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
            if (!supportConcurrency) {
                int n = 0;
                return n;
            }
            ArrayList<HiveLockObj> lockObjects = new ArrayList<HiveLockObj>();
            for (ReadEntity input : this.plan.getInputs()) {
                if (input.getType() == Entity.Type.TABLE) {
                    lockObjects.addAll(this.getLockObjects(input.getTable(), null, HiveLockMode.SHARED));
                    continue;
                }
                lockObjects.addAll(this.getLockObjects(null, input.getPartition(), HiveLockMode.SHARED));
            }
            for (WriteEntity output : this.plan.getOutputs()) {
                if (output.getTyp() == Entity.Type.TABLE) {
                    lockObjects.addAll(this.getLockObjects(output.getTable(), null, output.isComplete() ? HiveLockMode.EXCLUSIVE : HiveLockMode.SHARED));
                    continue;
                }
                if (output.getTyp() == Entity.Type.PARTITION) {
                    lockObjects.addAll(this.getLockObjects(null, output.getPartition(), HiveLockMode.EXCLUSIVE));
                    continue;
                }
                if (output.getTyp() != Entity.Type.DUMMYPARTITION) continue;
                lockObjects.addAll(this.getLockObjects(null, output.getPartition(), HiveLockMode.SHARED));
            }
            if (lockObjects.isEmpty() && !this.ctx.isNeedLockMgr()) {
                int i$ = 0;
                return i$;
            }
            HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(this.plan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT", this.plan.getQueryStr());
            try {
                Hive db = Hive.get(this.conf);
                lockObjects.add(new HiveLockObj(new HiveLockObject(db.getCurrentDatabase(), lockData), HiveLockMode.SHARED));
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage());
            }
            List<HiveLock> hiveLocks = this.ctx.getHiveLockMgr().lock(lockObjects, false);
            if (hiveLocks == null) {
                throw new SemanticException(ErrorMsg.LOCK_CANNOT_BE_ACQUIRED.getMsg());
            }
            this.ctx.setHiveLocks(hiveLocks);
            int n = 0;
            return n;
        }
        catch (SemanticException e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 10;
            return n;
        }
        catch (LockException e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 10;
            return n;
        }
        finally {
            perfLogger.PerfLogEnd(LOG, "acquireReadWriteLocks");
        }
    }

    private void releaseLocks(List<HiveLock> hiveLocks) {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(LOG, "releaseLocks");
        if (hiveLocks != null) {
            this.ctx.getHiveLockMgr().releaseLocks(hiveLocks);
        }
        this.ctx.setHiveLocks(null);
        perfLogger.PerfLogEnd(LOG, "releaseLocks");
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandNeedRetryException {
        return this.run(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse run(String command, boolean compileQuery) throws CommandNeedRetryException {
        int ret;
        List<HiveDriverRunHook> driverRunHooks;
        this.errorMessage = null;
        this.SQLState = null;
        if (!this.validateConfVariables()) {
            return new CommandProcessorResponse(12, this.errorMessage, this.SQLState);
        }
        HiveDriverRunHookContextImpl hookContext = new HiveDriverRunHookContextImpl(this.conf, command);
        try {
            driverRunHooks = this.getHooks(HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, HiveDriverRunHook.class);
            for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                driverRunHook.preDriverRun(hookContext);
            }
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e) + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage);
            return new CommandProcessorResponse(12, this.errorMessage, this.SQLState);
        }
        PerfLogger perfLogger = PerfLogger.getPerfLogger(true);
        perfLogger.PerfLogBegin(LOG, "Driver.run");
        perfLogger.PerfLogBegin(LOG, "TimeToSubmit");
        if (compileQuery) {
            int ret2;
            Object object = compileMonitor;
            synchronized (object) {
                ret2 = this.compile(command);
            }
            if (ret2 != 0) {
                this.releaseLocks(this.ctx.getHiveLocks());
                return new CommandProcessorResponse(ret2, this.errorMessage, this.SQLState);
            }
        }
        boolean requireLock = false;
        boolean ckLock = this.checkLockManager();
        if (ckLock) {
            boolean lockOnlyMapred = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY);
            if (lockOnlyMapred) {
                LinkedList<Task<? extends Serializable>> taskQueue = new LinkedList<Task<? extends Serializable>>();
                taskQueue.addAll(this.plan.getRootTasks());
                while (taskQueue.peek() != null) {
                    Task tsk = (Task)taskQueue.remove();
                    boolean bl = requireLock = requireLock || tsk.requireLock();
                    if (!requireLock) {
                        if (tsk instanceof ConditionalTask) {
                            taskQueue.addAll(((ConditionalTask)tsk).getListTasks());
                        }
                        if (tsk.getChildTasks() == null) continue;
                        taskQueue.addAll(tsk.getChildTasks());
                        continue;
                    }
                    break;
                }
            } else {
                requireLock = true;
            }
        }
        if (requireLock && (ret = this.acquireReadWriteLocks()) != 0) {
            this.releaseLocks(this.ctx.getHiveLocks());
            return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState);
        }
        ret = this.execute();
        if (ret != 0) {
            this.releaseLocks(this.ctx.getHiveLocks());
            return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState);
        }
        this.releaseLocks(this.ctx.getHiveLocks());
        perfLogger.PerfLogEnd(LOG, "Driver.run");
        perfLogger.close(LOG, this.plan);
        try {
            for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                driverRunHook.postDriverRun(hookContext);
            }
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e) + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            console.printError(this.errorMessage);
            return new CommandProcessorResponse(12, this.errorMessage, this.SQLState);
        }
        return new CommandProcessorResponse(ret);
    }

    private boolean validateConfVariables() {
        boolean valid = true;
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES) && (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_INTERNAL_DDL_LIST_BUCKETING_ENABLE) || this.conf.getBoolVar(HiveConf.ConfVars.HADOOPMAPREDINPUTDIRRECURSIVE) || this.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTLISTBUCKETING))) {
            this.errorMessage = "FAILED: Hive Internal Error: " + ErrorMsg.SUPPORT_DIR_MUST_TRUE_FOR_LIST_BUCKETING.getMsg();
            this.SQLState = ErrorMsg.findSQLState(this.errorMessage);
            console.printError(this.errorMessage + "\n");
            valid = false;
        }
        return valid;
    }

    private List<Hook> getHooks(HiveConf.ConfVars hookConfVar) throws Exception {
        return this.getHooks(hookConfVar, Hook.class);
    }

    private <T extends Hook> List<T> getHooks(HiveConf.ConfVars hookConfVar, Class<T> clazz) throws Exception {
        String[] hookClasses;
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        String csHooks = this.conf.getVar(hookConfVar);
        if (csHooks == null) {
            return hooks;
        }
        if ((csHooks = csHooks.trim()).equals("")) {
            return hooks;
        }
        for (String hookClass : hookClasses = csHooks.split(",")) {
            try {
                Hook hook = (Hook)Class.forName(hookClass.trim(), true, JavaUtils.getClassLoader()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                console.printError(hookConfVar.varname + " Class not found:" + e.getMessage());
                throw e;
            }
        }
        return hooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws CommandNeedRetryException {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(LOG, "Driver.execute");
        boolean noName = StringUtils.isEmpty(this.conf.getVar(HiveConf.ConfVars.HADOOPJOBNAME));
        int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
        String queryId = this.plan.getQueryId();
        String queryStr = this.plan.getQueryStr();
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, queryStr);
        this.maxthreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.EXECPARALLETHREADNUMBER);
        try {
            LOG.info((Object)("Starting command: " + queryStr));
            this.plan.setStarted();
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().startQuery(queryStr, this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            this.resStream = null;
            HookContext hookContext = new HookContext(this.plan, this.conf, this.ctx.getPathToCS(), this.userName, this.ipAddress);
            hookContext.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
            for (Hook peh : this.getHooks(HiveConf.ConfVars.PREEXECHOOKS)) {
                if (peh instanceof ExecuteWithHookContext) {
                    perfLogger.PerfLogBegin(LOG, "PreHook." + peh.getClass().getName());
                    ((ExecuteWithHookContext)peh).run(hookContext);
                    perfLogger.PerfLogEnd(LOG, "PreHook." + peh.getClass().getName());
                    continue;
                }
                if (!(peh instanceof PreExecute)) continue;
                perfLogger.PerfLogBegin(LOG, "PreHook." + peh.getClass().getName());
                ((PreExecute)peh).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), ShimLoader.getHadoopShims().getUGIForConf(this.conf));
                perfLogger.PerfLogEnd(LOG, "PreHook." + peh.getClass().getName());
            }
            int jobs = Utilities.getMRTasks(this.plan.getRootTasks()).size();
            if (jobs > 0) {
                console.printInfo("Total MapReduce jobs = " + jobs);
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_NUM_TASKS, String.valueOf(jobs));
                SessionState.get().getHiveHistory().setIdToTableMap(this.plan.getIdToTableNameMap());
            }
            String jobname = Utilities.abbreviate(queryStr, maxlen - 6);
            ConcurrentLinkedQueue<Task<? extends Serializable>> runnable = new ConcurrentLinkedQueue<Task<? extends Serializable>>();
            HashMap<TaskResult, TaskRunner> running = new HashMap<TaskResult, TaskRunner>();
            DriverContext driverCxt = new DriverContext(runnable, this.ctx);
            this.ctx.setHDFSCleanup(true);
            SessionState.get().setLastMapRedStatsList(new ArrayList<MapRedStats>());
            SessionState.get().setStackTraces(new HashMap<String, List<List<String>>>());
            SessionState.get().setLocalMapRedErrors(new HashMap<String, List<String>>());
            for (Task<? extends Serializable> tsk : this.plan.getRootTasks()) {
                driverCxt.addToRunnable(tsk);
            }
            perfLogger.PerfLogEnd(LOG, "TimeToSubmit");
            while (running.size() != 0 || runnable.peek() != null) {
                while (runnable.peek() != null && running.size() < this.maxthreads) {
                    Task tsk = (Task)runnable.remove();
                    this.launchTask(tsk, queryId, noName, running, jobname, jobs, driverCxt);
                }
                TaskResult tskRes = this.pollTasks(running.keySet());
                TaskRunner tskRun = (TaskRunner)running.remove(tskRes);
                Task<? extends Serializable> tsk = tskRun.getTask();
                hookContext.addCompleteTask(tskRun);
                int exitVal = tskRes.getExitVal();
                if (exitVal != 0) {
                    ErrorMsg em;
                    if (tsk.ifRetryCmdWhenFail()) {
                        if (running.size() != 0) {
                            this.taskCleanup(running);
                        }
                        this.ctx.restoreOriginalTracker();
                        throw new CommandNeedRetryException();
                    }
                    Task<Serializable> backupTask = tsk.getAndInitBackupTask();
                    if (backupTask != null) {
                        this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
                        em = ErrorMsg.getErrorMsg(exitVal);
                        if (em != null) {
                            this.errorMessage = this.errorMessage + ". " + em.getMsg();
                        }
                        console.printError(this.errorMessage);
                        this.errorMessage = "ATTEMPT: Execute BackupTask: " + backupTask.getClass().getName();
                        console.printError(this.errorMessage);
                        if (!DriverContext.isLaunchable(backupTask)) continue;
                        driverCxt.addToRunnable(backupTask);
                        continue;
                    }
                    hookContext.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
                    for (Hook ofh : this.getHooks(HiveConf.ConfVars.ONFAILUREHOOKS)) {
                        perfLogger.PerfLogBegin(LOG, "FailureHook." + ofh.getClass().getName());
                        ((ExecuteWithHookContext)ofh).run(hookContext);
                        perfLogger.PerfLogEnd(LOG, "FailureHook." + ofh.getClass().getName());
                    }
                    this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
                    em = ErrorMsg.getErrorMsg(exitVal);
                    if (em != null) {
                        this.errorMessage = this.errorMessage + ". " + em.getMsg();
                    }
                    this.SQLState = "08S01";
                    console.printError(this.errorMessage);
                    if (running.size() != 0) {
                        this.taskCleanup(running);
                    }
                    this.ctx.restoreOriginalTracker();
                    int n = exitVal;
                    return n;
                }
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setTaskProperty(queryId, tsk.getId(), HiveHistory.Keys.TASK_RET_CODE, String.valueOf(exitVal));
                    SessionState.get().getHiveHistory().endTask(queryId, tsk);
                }
                if (tsk.getChildTasks() == null) continue;
                for (Task<Serializable> child : tsk.getChildTasks()) {
                    if (!DriverContext.isLaunchable(child)) continue;
                    driverCxt.addToRunnable(child);
                }
            }
            this.ctx.restoreOriginalTracker();
            HashSet<WriteEntity> remOutputs = new HashSet<WriteEntity>();
            for (WriteEntity output : this.plan.getOutputs()) {
                if (output.isComplete()) continue;
                remOutputs.add(output);
            }
            for (WriteEntity output : remOutputs) {
                this.plan.getOutputs().remove(output);
            }
            hookContext.setHookType(HookContext.HookType.POST_EXEC_HOOK);
            for (Hook peh : this.getHooks(HiveConf.ConfVars.POSTEXECHOOKS)) {
                if (peh instanceof ExecuteWithHookContext) {
                    perfLogger.PerfLogBegin(LOG, "PostHook." + peh.getClass().getName());
                    ((ExecuteWithHookContext)peh).run(hookContext);
                    perfLogger.PerfLogEnd(LOG, "PostHook." + peh.getClass().getName());
                    continue;
                }
                if (!(peh instanceof PostExecute)) continue;
                perfLogger.PerfLogBegin(LOG, "PostHook." + peh.getClass().getName());
                ((PostExecute)peh).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), SessionState.get() != null ? SessionState.get().getLineageState().getLineageInfo() : null, ShimLoader.getHadoopShims().getUGIForConf(this.conf));
                perfLogger.PerfLogEnd(LOG, "PostHook." + peh.getClass().getName());
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(0));
                SessionState.get().getHiveHistory().printRowCount(queryId);
            }
        }
        catch (CommandNeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.ctx.restoreOriginalTracker();
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(12));
            }
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = "08S01";
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 12;
            return n;
        }
        finally {
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().endQuery(queryId);
            }
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, "");
            }
            perfLogger.PerfLogEnd(LOG, "Driver.execute");
            if (SessionState.get().getLastMapRedStatsList() != null && SessionState.get().getLastMapRedStatsList().size() > 0) {
                long totalCpu = 0L;
                console.printInfo("MapReduce Jobs Launched: ");
                for (int i = 0; i < SessionState.get().getLastMapRedStatsList().size(); ++i) {
                    console.printInfo("Job " + i + ": " + SessionState.get().getLastMapRedStatsList().get(i));
                    totalCpu += SessionState.get().getLastMapRedStatsList().get(i).getCpuMSec();
                }
                console.printInfo("Total MapReduce CPU Time Spent: " + Utilities.formatMsecToStr(totalCpu));
            }
        }
        this.plan.setDone();
        if (SessionState.get() != null) {
            try {
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        console.printInfo("OK");
        return 0;
    }

    public void launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, Map<TaskResult, TaskRunner> running, String jobname, int jobs, DriverContext cxt) {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask() && !(tsk instanceof ConditionalTask)) {
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, jobname + "(" + tsk.getId() + ")");
            }
            cxt.incCurJobNo(1);
            console.printInfo("Launching Job " + cxt.getCurJobNo() + " out of " + jobs);
        }
        tsk.initialize(this.conf, this.plan, cxt);
        TaskResult tskRes = new TaskResult();
        TaskRunner tskRun = new TaskRunner(tsk, tskRes);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.isMapRedTask()) {
            tskRun.start();
        } else {
            tskRun.runSequential();
        }
        running.put(tskRes, tskRun);
    }

    public void taskCleanup(Map<TaskResult, TaskRunner> running) {
        for (Map.Entry<TaskResult, TaskRunner> entry : running.entrySet()) {
            if (!entry.getKey().isRunning()) continue;
            entry.getValue().getTask().shutdown();
        }
        running.clear();
    }

    public TaskResult pollTasks(Set<TaskResult> results) {
        Iterator<TaskResult> resultIterator = results.iterator();
        while (true) {
            if (resultIterator.hasNext()) {
                TaskResult tskRes = resultIterator.next();
                if (tskRes.isRunning()) continue;
                return tskRes;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resultIterator = results.iterator();
        }
    }

    private boolean isExecMetadataLookup(HiveOperation hiveOperation) {
        Object[] commands = new String[]{"SHOWDATABASES", "SHOWTABLES"};
        return Arrays.binarySearch(commands, hiveOperation.getOperationName().toUpperCase()) >= 0;
    }

    private void fireFilterHooks(List<String> res) throws CommandNeedRetryException {
        List<HiveDriverFilterHook> filterHooks = null;
        try {
            filterHooks = this.getHooks(HiveConf.ConfVars.HIVE_EXEC_FILTER_HOOK, HiveDriverFilterHook.class);
            if (res != null && !res.isEmpty() && filterHooks != null && !filterHooks.isEmpty() && this.isExecMetadataLookup(this.hiveOperation)) {
                String currentDbName = Hive.get().getCurrentDatabase();
                HiveDriverFilterHookContextImpl hookCtx = new HiveDriverFilterHookContextImpl(this.conf, this.hiveOperation, this.userName, res, currentDbName);
                List<String> filteredValues = null;
                for (HiveDriverFilterHook hook : filterHooks) {
                    HiveDriverFilterHookResult hookResult = hook.postDriverFetch(hookCtx);
                    filteredValues = hookResult.getResult();
                    hookCtx.setResult(filteredValues);
                }
                res.clear();
                res.addAll(filteredValues);
            }
        }
        catch (Exception e) {
            throw new CommandNeedRetryException(e);
        }
    }

    public boolean getResults(ArrayList<String> res) throws IOException, CommandNeedRetryException {
        if (this.plan != null && this.plan.getFetchTask() != null) {
            FetchTask ft = this.plan.getFetchTask();
            ft.setMaxRows(this.maxRows);
            boolean ret = ft.fetch(res);
            this.fireFilterHooks(res);
            return ret;
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getCount() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getCount(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                res = null;
                return false;
            }
            this.fireFilterHooks(res);
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    public void resetFetch() {
        if (this.plan != null && this.plan.getFetchTask() != null) {
            try {
                this.plan.getFetchTask().clearFetch();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error closing the current fetch task", (Throwable)e);
            }
            this.plan.getFetchTask().initialize(this.conf, this.plan, null);
        } else {
            this.ctx.resetStream();
            this.resStream = null;
        }
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public int close() {
        try {
            FetchTask fetchTask;
            if (this.plan != null && null != (fetchTask = this.plan.getFetchTask())) {
                try {
                    fetchTask.clearFetch();
                }
                catch (Exception e) {
                    LOG.debug((Object)" Exception while clearing the Fetch task ", (Throwable)e);
                }
            }
            if (this.ctx != null) {
                this.ctx.clear();
            }
            if (null != this.resStream) {
                try {
                    ((FSDataInputStream)this.resStream).close();
                }
                catch (Exception e) {
                    LOG.debug((Object)" Exception while closing the resStream ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            console.printError("FAILED: Hive Internal Error: " + Utilities.getNameMessage(e) + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 13;
        }
        return 0;
    }

    public void destroy() {
        if (this.ctx != null) {
            this.releaseLocks(this.ctx.getHiveLocks());
        }
        if (this.hiveLockMgr != null) {
            try {
                this.hiveLockMgr.close();
            }
            catch (LockException e) {
                LOG.warn((Object)("Exception in closing hive lock manager. " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }

    private static class QueryState {
        private HiveOperation op;
        private String cmd;
        private boolean init = false;

        private QueryState() {
        }

        public void init(HiveOperation op, String cmd) {
            this.op = op;
            this.cmd = cmd;
            this.init = true;
        }

        public boolean isInitialized() {
            return this.init;
        }

        public HiveOperation getOp() {
            return this.op;
        }

        public String getCmd() {
            return this.cmd;
        }
    }
}

