/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.util.collections;

public class HeirarchicalLinkedListItem
implements Cloneable {
    private HeirarchicalLinkedListItem parent;
    private HeirarchicalLinkedListItem prev;
    private HeirarchicalLinkedListItem next;
    private HeirarchicalLinkedListItem firstChild;
    private HeirarchicalLinkedListItem lastChild;
    private long modNumber = 0L;

    public long getModNumber() {
        return this.modNumber;
    }

    public HeirarchicalLinkedListItem getParentItem() {
        return this.parent;
    }

    public HeirarchicalLinkedListItem getPreviousItem() {
        return this.prev;
    }

    public HeirarchicalLinkedListItem getNextItem() {
        return this.next;
    }

    public HeirarchicalLinkedListItem getFirstChildItem() {
        return this.firstChild;
    }

    public HeirarchicalLinkedListItem getLastChildItem() {
        return this.lastChild;
    }

    public void removeItem() {
        boolean modified = false;
        if (this.prev != null) {
            this.prev.next = this.next;
            modified = true;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
            modified = true;
        }
        if (this.parent != null) {
            if (this.equals(this.parent.firstChild)) {
                this.parent.firstChild = this.next;
            }
            if (this.equals(this.parent.lastChild)) {
                this.parent.lastChild = this.prev;
            }
            modified = true;
        }
        if (modified) {
            this.markModified();
        }
        this.parent = null;
        this.prev = null;
        this.next = null;
    }

    public int getChildCount() {
        int count = 0;
        HeirarchicalLinkedListItem item = this.firstChild;
        while (item != null) {
            ++count;
            item = item.next;
        }
        return count;
    }

    public HeirarchicalLinkedListItem getNextDepthFirstItem() {
        if (this.firstChild != null) {
            return this.firstChild;
        }
        if (this.next != null) {
            return this.next;
        }
        HeirarchicalLinkedListItem item = this;
        while (item != null && item.next == null) {
            item = item.parent;
        }
        return item == null ? null : item.next;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void addChildItem(HeirarchicalLinkedListItem newChild) throws IllegalArgumentException {
        this.addLastChildItem(newChild);
        this.markModified();
    }

    protected void insertAfter(HeirarchicalLinkedListItem newChild, HeirarchicalLinkedListItem target) throws IllegalArgumentException, IllegalStateException {
        if (newChild == null || target == null) {
            throw new IllegalArgumentException();
        }
        HeirarchicalLinkedListItem foundTarget = this.findChildItem(target);
        if (foundTarget == null) {
            throw new IllegalArgumentException("Could not find target child!");
        }
        foundTarget.addNextItem(newChild);
        if (this.lastChild.equals(target)) {
            this.lastChild = newChild;
        }
        this.markModified();
    }

    protected void insertBefore(HeirarchicalLinkedListItem newChild, HeirarchicalLinkedListItem target) throws IllegalArgumentException, IllegalStateException {
        if (newChild == null || target == null) {
            throw new IllegalArgumentException();
        }
        HeirarchicalLinkedListItem foundTarget = this.findChildItem(target);
        if (foundTarget == null) {
            throw new IllegalArgumentException("Could not find target child!");
        }
        foundTarget.addPreviousItem(newChild);
        if (this.firstChild.equals(target)) {
            this.firstChild = newChild;
        }
        this.markModified();
    }

    protected void addFirstChildItem(HeirarchicalLinkedListItem newChild) throws IllegalArgumentException, IllegalStateException {
        if (this.firstChild == null) {
            this.addChildItem(newChild);
        } else {
            this.insertBefore(newChild, this.firstChild);
        }
        this.markModified();
    }

    protected void addLastChildItem(HeirarchicalLinkedListItem newChild) throws IllegalArgumentException, IllegalStateException {
        if (newChild == null) {
            throw new IllegalArgumentException();
        }
        if (this.lastChild != null) {
            this.insertAfter(newChild, this.lastChild);
        } else {
            newChild.setParentItem(this);
            this.firstChild = newChild;
            this.lastChild = newChild;
            newChild.prev = null;
            newChild.next = null;
        }
        this.markModified();
    }

    private void setParentItem(HeirarchicalLinkedListItem newParent) throws IllegalArgumentException, IllegalStateException {
        if (newParent == null) {
            throw new IllegalArgumentException();
        }
        if (this.parent != null && !this.parent.equals(newParent)) {
            throw new IllegalStateException();
        }
        this.parent = newParent;
        this.markModified();
    }

    private HeirarchicalLinkedListItem findChildItem(HeirarchicalLinkedListItem itemToFind) {
        HeirarchicalLinkedListItem searchItem = this.firstChild;
        while (searchItem != null) {
            if (searchItem.equals(itemToFind)) {
                return searchItem;
            }
            searchItem = searchItem.next;
        }
        return null;
    }

    private void addPreviousItem(HeirarchicalLinkedListItem newItem) throws IllegalArgumentException, IllegalStateException {
        if (newItem == null) {
            throw new IllegalArgumentException();
        }
        newItem.setParentItem(this.parent);
        newItem.prev = this.prev;
        newItem.next = this;
        if (this.prev != null) {
            this.prev.next = newItem;
        }
        this.prev = newItem;
        this.markModified();
    }

    private void addNextItem(HeirarchicalLinkedListItem newItem) throws IllegalArgumentException, IllegalStateException {
        if (newItem == null) {
            throw new IllegalArgumentException();
        }
        newItem.setParentItem(this.parent);
        newItem.prev = this;
        newItem.next = this.next;
        if (this.next != null) {
            this.next.prev = newItem;
        }
        this.next = newItem;
        this.markModified();
    }

    protected void markModified() {
        ++this.modNumber;
        if (this.parent != null) {
            this.parent.markModified();
        }
    }
}

