/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.utils;

import java.awt.BasicStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyle;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.keys.border.BorderWidth;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class StrokeFactory {
    private static final Log logger = LogFactory.getLog(StrokeFactory.class);
    private static StrokeFactory strokeFacObj;
    private static final float THIN = 1.0f;
    private static final float MEDIUM = 2.0f;
    private static final float THICK = 4.0f;
    private static final String CENTIMETER = "cm";
    private static final String PIXEL = "px";
    private static final float CENTIMETER_TO_PIXEL = 37.8f;

    private StrokeFactory() {
    }

    public static synchronized StrokeFactory getInstance() {
        if (strokeFacObj == null) {
            strokeFacObj = new StrokeFactory();
        }
        return strokeFacObj;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public BasicStroke getBorderStroke(ChartElement element) {
        if (element == null) {
            return null;
        }
        return this.getBasicStroke(element, BorderStyleKeys.BORDER_TOP_STYLE, BorderStyleKeys.BORDER_TOP_WIDTH);
    }

    public BasicStroke getLineStroke(ChartElement element) {
        if (element == null) {
            return null;
        }
        return this.getBasicStroke(element, ChartStyleKeys.LINE_STYLE, ChartStyleKeys.LINE_WIDTH);
    }

    private BasicStroke getBasicStroke(ChartElement chartElement, StyleKey styleStyleKey, StyleKey widthStyleKey) {
        CSSValue borderStyle;
        CSSValue cssValue = chartElement.getLayoutStyle().getValue(widthStyleKey);
        String borderWidth = cssValue != null ? cssValue.getCSSText() : null;
        float width = 0.0f;
        if (borderWidth != null) {
            if (borderWidth.equalsIgnoreCase(BorderWidth.THIN.toString())) {
                width = 1.0f;
            } else if (borderWidth.equalsIgnoreCase(BorderWidth.MEDIUM.toString())) {
                width = 2.0f;
            } else if (borderWidth.equalsIgnoreCase(BorderWidth.THICK.toString())) {
                width = 4.0f;
            } else if (borderWidth.endsWith(PIXEL)) {
                String borderWidthPixels = borderWidth.substring(0, borderWidth.indexOf(PIXEL)).trim();
                width = Integer.parseInt(borderWidthPixels);
            } else if (borderWidth.endsWith(CENTIMETER)) {
                String borderWidthCms = borderWidth.substring(0, borderWidth.indexOf(CENTIMETER)).trim();
                width = (float)Integer.parseInt(borderWidthCms) * 37.8f;
            }
        }
        if ((borderStyle = chartElement.getLayoutStyle().getValue(styleStyleKey)) == null || BorderStyle.NONE.getCSSText().equals(borderStyle.getCSSText())) {
            logger.warn((Object)String.format("************style %s has value %s; stroke will be null", styleStyleKey.name, BorderStyle.NONE.getCSSText()));
            return null;
        }
        BasicStroke stroke = null;
        if (BorderStyle.SOLID.equals((Object)borderStyle)) {
            stroke = new BasicStroke(width);
        } else if (BorderStyle.DASHED.equals((Object)borderStyle)) {
            stroke = new BasicStroke(width, 0, 0, 10.0f, new float[]{10.0f, 3.0f}, 0.0f);
        } else if (BorderStyle.DOT_DASH.equals((Object)borderStyle)) {
            stroke = new BasicStroke(width, 0, 0, 10.0f, new float[]{10.0f, 3.0f, 2.0f, 2.0f}, 0.0f);
        } else if (BorderStyle.DOTTED.equals((Object)borderStyle)) {
            stroke = new BasicStroke(width, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        }
        return stroke;
    }
}

