/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.utils;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;

public class CylinderRenderer
extends BarRenderer3D {
    private static final long serialVersionUID = 1L;

    public CylinderRenderer() {
    }

    public CylinderRenderer(double xOffset, double yOffset) {
        super(xOffset, yOffset);
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        EntityCollection entities;
        CategoryItemLabelGenerator generator;
        Ellipse2D.Double top;
        Arc2D.Double arc;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        Rectangle2D.Double adjusted = new Rectangle2D.Double(dataArea.getX(), dataArea.getY() + this.getYOffset(), dataArea.getWidth() - this.getXOffset(), dataArea.getHeight() - this.getYOffset());
        PlotOrientation orientation = plot.getOrientation();
        double barW0 = this.calculateBarW0(plot, orientation, adjusted, domainAxis, state, row, column);
        double[] barL0L1 = this.calculateBarL0L1(value);
        if (barL0L1 == null) {
            return;
        }
        RectangleEdge edge = plot.getRangeAxisEdge();
        float transL0 = (float)rangeAxis.valueToJava2D(barL0L1[0], (Rectangle2D)adjusted, edge);
        float transL1 = (float)rangeAxis.valueToJava2D(barL0L1[1], (Rectangle2D)adjusted, edge);
        float barL0 = Math.min(transL0, transL1);
        float barLength = Math.abs(transL1 - transL0);
        GeneralPath bar = new GeneralPath();
        if (orientation == PlotOrientation.HORIZONTAL) {
            bar.moveTo((float)((double)barL0 + this.getXOffset() / 2.0), (float)barW0);
            bar.lineTo((float)((double)(barL0 + barLength) + this.getXOffset() / 2.0), (float)barW0);
            arc = new Arc2D.Double(barL0 + barLength, barW0, this.getXOffset(), state.getBarWidth(), 90.0, 180.0, 0);
            bar.append(arc, true);
            bar.lineTo((float)((double)barL0 + this.getXOffset() / 2.0), (float)(barW0 + state.getBarWidth()));
            arc = new Arc2D.Double(barL0, barW0, this.getXOffset(), state.getBarWidth(), 270.0, -180.0, 0);
            bar.append(arc, true);
            bar.closePath();
            top = new Ellipse2D.Double(barL0 + barLength, barW0, this.getXOffset(), state.getBarWidth());
        } else {
            bar.moveTo((float)barW0, (float)((double)barL0 - this.getYOffset() / 2.0));
            bar.lineTo((float)barW0, (float)((double)(barL0 + barLength) - this.getYOffset() / 2.0));
            arc = new Arc2D.Double(barW0, (double)(barL0 + barLength) - this.getYOffset(), state.getBarWidth(), this.getYOffset(), 180.0, 180.0, 0);
            bar.append(arc, true);
            bar.lineTo((float)(barW0 + state.getBarWidth()), (float)((double)barL0 - this.getYOffset() / 2.0));
            arc = new Arc2D.Double(barW0, (double)barL0 - this.getYOffset(), state.getBarWidth(), this.getYOffset(), 0.0, -180.0, 0);
            bar.append(arc, true);
            bar.closePath();
            top = new Ellipse2D.Double(barW0, (double)barL0 - this.getYOffset(), state.getBarWidth(), this.getYOffset());
        }
        Paint itemPaint = this.getItemPaint(row, column);
        if (this.getGradientPaintTransformer() != null && itemPaint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)itemPaint;
            itemPaint = this.getGradientPaintTransformer().transform(gp, (Shape)bar);
        }
        g2.setPaint(itemPaint);
        g2.fill(bar);
        if (itemPaint instanceof GradientPaint) {
            g2.setPaint(((GradientPaint)itemPaint).getColor2());
        }
        if (top != null) {
            g2.fill(top);
        }
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            g2.setStroke(this.getItemOutlineStroke(row, column));
            g2.setPaint(this.getItemOutlinePaint(row, column));
            g2.draw(bar);
            if (top != null) {
                g2.draw(top);
            }
        }
        if ((generator = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, generator, bar.getBounds2D(), value < 0.0);
        }
        if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
            String tip = null;
            CategoryToolTipGenerator tipster = this.getToolTipGenerator(row, column);
            if (tipster != null) {
                tip = tipster.generateToolTip(dataset, row, column);
            }
            String url = null;
            if (this.getItemURLGenerator(row, column) != null) {
                url = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity entity = new CategoryItemEntity((Shape)bar.getBounds2D(), tip, url, dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
            entities.add((ChartEntity)entity);
        }
    }
}

