/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart.line;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartLineVisibleType;
import org.pentaho.chart.css.styles.ChartMarkerVisibleType;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.chart.JFreeChartGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.ChartMarkerFilledType;
import org.pentaho.chart.plugin.jfreechart.utils.ShapeFactory;
import org.pentaho.chart.plugin.jfreechart.utils.StrokeFactory;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class JFreeLineChartGenerator
extends JFreeChartGenerator {
    @Override
    protected JFreeChart doCreateChart(ChartDocumentContext chartDocContext, ChartTableModel data) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        String title = JFreeLineChartGenerator.getTitle(chartDocument);
        String valueCategoryLabel = JFreeLineChartGenerator.getValueCategoryLabel(chartDocument);
        String valueAxisLabel = JFreeLineChartGenerator.getValueAxisLabel(chartDocument);
        PlotOrientation orientation = this.getPlotOrientation(chartDocument);
        boolean legend = JFreeLineChartGenerator.getShowLegend(chartDocument);
        boolean toolTips = JFreeLineChartGenerator.getShowToolTips(chartDocument);
        DefaultCategoryDataset categoryDataset = this.datasetGeneratorFactory.createDefaultCategoryDataset(chartDocContext, data);
        JFreeChart chart = ChartFactory.createLineChart((String)title, (String)valueCategoryLabel, (String)valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)toolTips, (boolean)toolTips);
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        if (categoryPlot != null && seriesElements != null) {
            this.setSeriesAttributes(seriesElements, data, categoryPlot);
        }
        return chart;
    }

    protected void setSeriesAttributes(ChartElement[] seriesElements, ChartTableModel data, CategoryPlot categoryPlot) {
        this.setSeriesItemLabel(categoryPlot, seriesElements, data);
        this.setSeriesPaint(categoryPlot, seriesElements, data);
        JFreeLineChartGenerator.setSeriesMarkerStyles(categoryPlot, seriesElements);
        JFreeLineChartGenerator.setSeriesLineStyles(categoryPlot, seriesElements);
    }

    private static void setSeriesMarkerStyles(CategoryPlot categoryPlot, ChartElement[] seriesElements) {
        int length = seriesElements.length;
        ShapeFactory shapeFacObj = ShapeFactory.getInstance();
        for (int i = 0; i < length; ++i) {
            ChartElement currElement = seriesElements[i];
            if (!(categoryPlot.getRenderer() instanceof LineAndShapeRenderer)) continue;
            LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
            lineAndShapeRenderer.setSeriesShapesVisible(i, JFreeLineChartGenerator.isMarkerVisible(currElement));
            lineAndShapeRenderer.setSeriesShape(i, shapeFacObj.getShape(currElement));
            lineAndShapeRenderer.setSeriesShapesFilled(i, JFreeLineChartGenerator.isShapeFilled(currElement));
        }
    }

    private static boolean isMarkerVisible(ChartElement currElement) {
        CSSValue visibleStr = currElement.getLayoutStyle().getValue(ChartStyleKeys.MARKER_VISIBLE);
        return ChartMarkerVisibleType.VISIBLE.equals((Object)visibleStr);
    }

    private static boolean isShapeFilled(ChartElement currElement) {
        CSSValue filledStr = currElement.getLayoutStyle().getValue(ChartStyleKeys.MARKER_FILLED);
        return ChartMarkerFilledType.FILLED.equals((Object)filledStr);
    }

    public static void setSeriesLineStyles(CategoryPlot categoryPlot, ChartElement[] seriesElements) {
        int length = seriesElements.length;
        StrokeFactory strokeFacObj = StrokeFactory.getInstance();
        for (int i = 0; i < length; ++i) {
            ChartElement currElement = seriesElements[i];
            if (!(categoryPlot.getRenderer() instanceof LineAndShapeRenderer)) continue;
            LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
            CSSValue visibleStr = currElement.getLayoutStyle().getValue(ChartStyleKeys.LINE_VISIBLE);
            lineAndShapeRenderer.setSeriesLinesVisible(i, !ChartLineVisibleType.HIDDEN.equals((Object)visibleStr));
            BasicStroke lineStyleStroke = strokeFacObj.getLineStroke(currElement);
            if (lineStyleStroke == null) continue;
            lineAndShapeRenderer.setSeriesStroke(i, (Stroke)lineStyleStroke);
        }
    }
}

