/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CssStyle
extends HashMap<String, String>
implements Serializable {
    public static final String BACKGROUND_COLOR_STYLE = "background-color";
    public static final String BORDER_WIDTH_STYLE = "border-top-width";
    public static final String BORDER_COLOR_STYLE = "border-top-color";
    public static final String BORDER_LINE_STYLE = "border-top-style";
    public static final String FONT_SIZE_STYLE = "font-size";
    public static final String FONT_WEIGHT_STYLE = "font-weight";
    public static final String FONT_STYLE = "font-style";
    public static final String FONT_FAMILY_STYLE = "font-family";
    public static final String COLOR_STYLE = "color";
    public static final String VISIBILITY_STYLE = "color";
    public static final String TEXT_ALIGNMENT_STYLE = "text-align";
    public static final String OPACITY_STYLE = "opacity";

    public LineStyle getBorderLineStyle() {
        LineStyle style = LineStyle.SOLID;
        String str = (String)this.get(BORDER_LINE_STYLE);
        if (str != null) {
            try {
                style = Enum.valueOf(LineStyle.class, str.toUpperCase());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return style;
    }

    public void setBorderLineStyle(LineStyle lineStyle) {
        if (lineStyle == null) {
            this.remove(BORDER_LINE_STYLE);
        } else {
            this.put(BORDER_LINE_STYLE, lineStyle.toString().toLowerCase());
        }
    }

    public Integer getBorderWidth() {
        Integer width = null;
        String str = (String)this.get(BORDER_WIDTH_STYLE);
        if (str != null) {
            try {
                width = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return width;
    }

    public void setBorderWidth(Integer width) {
        if (width == null) {
            this.remove(BORDER_WIDTH_STYLE);
        } else {
            this.put(BORDER_WIDTH_STYLE, width.toString());
        }
    }

    public Integer getBorderColor() {
        Integer color = null;
        String str = (String)this.get(BORDER_COLOR_STYLE);
        if (str != null) {
            int index = str.indexOf("#");
            try {
                color = Integer.parseInt(str.substring(index + 1), 16);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return color;
    }

    public void setBorderColor(Integer color) {
        if (color == null) {
            this.remove(BORDER_COLOR_STYLE);
        } else {
            StringBuffer colorStr = new StringBuffer("#" + Integer.toString(color & 0xFFFFFF, 16));
            while (colorStr.length() < 7) {
                colorStr.insert(1, 0);
            }
            this.put(BORDER_COLOR_STYLE, colorStr.toString());
        }
    }

    public Integer getBackgroundColor() {
        Integer color = null;
        String str = (String)this.get(BACKGROUND_COLOR_STYLE);
        if (str != null) {
            int index = str.indexOf("#");
            try {
                color = Integer.parseInt(str.substring(index + 1), 16);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return color;
    }

    public void setBackgroundColor(Integer color) {
        if (color == null) {
            this.remove(BACKGROUND_COLOR_STYLE);
        } else {
            StringBuffer colorStr = new StringBuffer("#" + Integer.toString(color & 0xFFFFFF, 16));
            while (colorStr.length() < 7) {
                colorStr.insert(1, 0);
            }
            this.put(BACKGROUND_COLOR_STYLE, colorStr.toString());
        }
    }

    public FontStyle getFontStyle() {
        FontStyle fontStyle = null;
        String str = (String)this.get(FONT_STYLE);
        if (str != null) {
            try {
                fontStyle = Enum.valueOf(FontStyle.class, str.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fontStyle == null ? FontStyle.NORMAL : fontStyle;
    }

    public void setFontStyle(FontStyle style) {
        if (style == null || style == FontStyle.NORMAL) {
            this.remove(FONT_STYLE);
        } else {
            this.put(FONT_STYLE, style.toString().toLowerCase());
        }
    }

    public FontWeight getFontWeight() {
        FontWeight fontWeight = null;
        String str = (String)this.get(FONT_WEIGHT_STYLE);
        if (str != null) {
            try {
                fontWeight = Enum.valueOf(FontWeight.class, str.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fontWeight == null ? FontWeight.NORMAL : fontWeight;
    }

    public void setFontWeight(FontWeight weight) {
        if (weight == null || weight == FontWeight.NORMAL) {
            this.remove(FONT_WEIGHT_STYLE);
        } else {
            this.put(FONT_WEIGHT_STYLE, weight.toString().toLowerCase());
        }
    }

    public Integer getFontSize() {
        Integer size = null;
        String str = (String)this.get(FONT_SIZE_STYLE);
        if (str != null) {
            try {
                if (str.endsWith("px")) {
                    str = str.substring(0, str.indexOf("px"));
                }
                size = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return size;
    }

    public void setFontSize(Integer size) {
        if (size == null) {
            this.remove(FONT_SIZE_STYLE);
        } else {
            this.put(FONT_SIZE_STYLE, size.toString() + "px");
        }
    }

    public String getFontFamily() {
        return (String)this.get(FONT_FAMILY_STYLE);
    }

    public void setFontFamily(String family) {
        if (family == null) {
            this.remove(FONT_FAMILY_STYLE);
        } else {
            this.put(FONT_FAMILY_STYLE, family);
        }
    }

    public void setFont(String family, Integer size) {
        this.setFontFamily(family);
        this.setFontSize(size);
    }

    public void setFont(String family, Integer size, FontStyle fontStyle, FontWeight fontWeight) {
        this.setFontFamily(family);
        this.setFontSize(size);
        this.setFontStyle(fontStyle);
        this.setFontWeight(fontWeight);
    }

    public Integer getColor() {
        Integer color = null;
        String str = (String)this.get("color");
        if (str != null) {
            int index = str.indexOf("#");
            try {
                color = Integer.parseInt(str.substring(index + 1), 16);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return color;
    }

    public void setColor(Integer color) {
        if (color == null) {
            this.remove("color");
        } else {
            StringBuffer colorStr = new StringBuffer("#" + Integer.toString(color & 0xFFFFFF, 16));
            while (colorStr.length() < 7) {
                colorStr.insert(1, 0);
            }
            this.put("color", colorStr.toString());
        }
    }

    public VisibilityStyle getVisibility() {
        VisibilityStyle style = VisibilityStyle.VISIBLE;
        String str = (String)this.get("color");
        if (str != null) {
            try {
                style = Enum.valueOf(VisibilityStyle.class, str.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return style;
    }

    public void setVisibility(VisibilityStyle visibility) {
        if (visibility == null) {
            this.remove("color");
        } else {
            this.put("color", visibility.toString().toLowerCase());
        }
    }

    public void setOpacity(Float opacity) {
        if (opacity == null) {
            this.remove(OPACITY_STYLE);
        } else {
            this.put(OPACITY_STYLE, opacity.toString());
        }
    }

    public Float getOpacity() {
        Float opacity = null;
        String str = (String)this.get(OPACITY_STYLE);
        if (str != null) {
            try {
                opacity = Float.valueOf(Float.parseFloat(str));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return opacity;
    }

    @Override
    public String toString() {
        return "CssStyle[" + this.getStyleString() + "]";
    }

    public String getStyleString() {
        StringBuffer cssStyleString = new StringBuffer();
        for (Map.Entry entry : this.entrySet()) {
            if (cssStyleString.length() > 0) {
                cssStyleString.append(" ");
            }
            cssStyleString.append((String)entry.getKey() + ": " + (String)entry.getValue() + ";");
        }
        return cssStyleString.toString();
    }

    public boolean getBorderVisible() {
        return this.getBorderWidth() != null;
    }

    public void setBorderVisible(boolean visible) {
        if (!visible) {
            this.setBorderColor(null);
            this.setBorderWidth(null);
        } else if (this.getBorderWidth() == null) {
            this.setBorderWidth(1);
        }
    }

    public void setStyleString(String cssStyle) {
        this.clear();
        if (cssStyle != null) {
            String[] styles;
            for (String styleStr : styles = cssStyle.split(";")) {
                String[] styleNameValue = styleStr.split(":");
                if (styleNameValue.length != 2) continue;
                String styleName = styleNameValue[0].trim();
                String styleValue = styleNameValue[1].trim();
                if (styleName.length() <= 0 || styleValue.length() <= 0) continue;
                this.put(styleName, styleValue);
            }
        }
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        if (textAlignment == null) {
            this.remove(TEXT_ALIGNMENT_STYLE);
        } else {
            this.put(TEXT_ALIGNMENT_STYLE, textAlignment.toString().toLowerCase());
        }
    }

    public TextAlignment getTextAlignment() {
        TextAlignment textAlignment = null;
        String str = (String)this.get(TEXT_ALIGNMENT_STYLE);
        if (str != null) {
            try {
                textAlignment = Enum.valueOf(TextAlignment.class, str.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return textAlignment;
    }

    public static enum VisibilityStyle {
        VISIBLE,
        HIDDEN;

    }

    public static enum LineStyle {
        SOLID,
        DASHED,
        DOTTED;

    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum FontStyle {
        NORMAL,
        ITALIC,
        OBLIQUE;

    }

    public static enum FontWeight {
        NORMAL,
        BOLD;

    }
}

