/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.data.XYDataModel;
import org.pentaho.chart.data.XYDataPoint;

public class MultiSeriesXYDataModel
implements IChartDataModel {
    LinkedHashMap<String, XYDataModel> chartData = new LinkedHashMap();

    public void addDataPoint(String seriesName, Number domainValue, Number rangeValue) {
        XYDataModel xyDataModel = this.chartData.get(seriesName);
        if (xyDataModel == null) {
            xyDataModel = new XYDataModel();
            this.chartData.put(seriesName, xyDataModel);
        }
        xyDataModel.add(new XYDataPoint(domainValue, rangeValue));
    }

    public Series getSeries(String seriesName) {
        Series series = null;
        XYDataModel xyDataModel = this.chartData.get(seriesName);
        if (xyDataModel != null) {
            series = new Series(seriesName);
            series.addAll(xyDataModel);
        }
        return series;
    }

    public List<Series> getSeries() {
        ArrayList<Series> seriesList = new ArrayList<Series>();
        for (Map.Entry<String, XYDataModel> mapEntry : this.chartData.entrySet()) {
            Series series = new Series(mapEntry.getKey());
            series.addAll(mapEntry.getValue());
            seriesList.add(series);
        }
        return seriesList;
    }

    public class Series
    extends XYDataModel {
        String seriesName;

        Series() {
        }

        Series(String seriesName) {
            this.seriesName = seriesName;
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public void setSeriesName(String seriesName) {
            this.seriesName = seriesName;
        }
    }
}

