/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.data;

import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.chart.ChartData;
import org.pentaho.util.messages.Messages;

class BaseChartTableModel
extends AbstractTableModel
implements ChartData {
    private static final long serialVersionUID = -3841939975394981180L;
    private static final Log logger = LogFactory.getLog(BaseChartTableModel.class);
    private static final String ROW = "row";
    private static final String COL = "col";
    private static final String CELL = "cell";
    public static final String ROW_NAME = "row-name";
    public static final String COL_NAME = "col-name";
    private MultiKeyMap metadataMap = MultiKeyMap.decorate((AbstractHashedMap)new HashedMap());
    private Object[][] data;
    private int rowCount;
    private int colCount;

    BaseChartTableModel() {
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getColumnName(int col) {
        String colName = null;
        if (col >= 0) {
            colName = (String)this.metadataMap.get((Object)COL, (Object)col, (Object)COL_NAME);
        } else {
            logger.error((Object)Messages.getErrorString("ChartTableModel.ERROR_0001_COLUMN_NUM_LOWER_THAN_ZERO"));
        }
        return colName;
    }

    @Override
    public String getRowName(int row) {
        String rowName = null;
        if (row >= 0) {
            rowName = (String)this.metadataMap.get((Object)ROW, (Object)row, (Object)ROW_NAME);
        } else {
            logger.error((Object)Messages.getErrorString("ChartTableModel.ERROR_0009_INVALID_ROW_NUMBER", "" + row));
        }
        return rowName;
    }

    @Override
    public void setColumnName(int col, String name) {
        if (col < 0) {
            logger.error((Object)Messages.getErrorString("ChartTableModel.ERROR_0001_COLUMN_NUM_LOWER_THAN_ZERO"));
        } else if (null == name || name.trim().length() == 0) {
            logger.warn((Object)Messages.getErrorString("ChartTableModel.WARN_NAME_SHOULD_NOT_BE_NULL"));
        } else {
            this.metadataMap.put((Object)COL, (Object)col, (Object)COL_NAME, (Object)name);
        }
    }

    @Override
    public void setRowName(int row, String name) {
        if (row >= 0) {
            this.metadataMap.put((Object)ROW, (Object)row, (Object)ROW_NAME, (Object)name);
        } else {
            logger.warn((Object)Messages.getErrorString("ChartTableModel.ERROR_0010_ROW_NAME_NOT_SET", "" + row));
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object retData = null;
        if (null == this.data) {
            logger.error((Object)Messages.getErrorString("ChartTableModel.ERROR_0005_NO_DATA_AVAILABLE"));
        } else if (row < 0 || row > this.getRowCount()) {
            logger.error((Object)Messages.getErrorString("ChartTableModel.ERROR_0004_ROW_NUM_OUT_OF_BOUNDS"));
        } else if (col < 0 || col > this.data[row].length) {
            logger.error((Object)Messages.getErrorString("ChartTableModel.ERROR_0002_COLUMN_NUM_OUT_OF_BOUNDS"));
        } else {
            retData = this.data[row][col];
        }
        return retData;
    }

    @Override
    public void setValueAt(Object value, int row, int col) throws ArrayIndexOutOfBoundsException, IllegalStateException {
        if (row > this.getRowCount() || row < 0) {
            throw new ArrayIndexOutOfBoundsException(Messages.getErrorString("ChartTableModel.ERROR_0004_ROW_NUM_OUT_OF_BOUNDS"));
        }
        if (col > this.getColumnCount() || col < 0) {
            throw new ArrayIndexOutOfBoundsException(Messages.getErrorString("ChartTableModel.ERROR_0002_COLUMN_NUM_OUT_OF_BOUNDS"));
        }
        if (null == this.data) {
            throw new IllegalStateException("Data array not initialized.");
        }
        this.data[row][col] = value;
    }

    public void setData(Object[][] inData) throws IllegalStateException {
        this.rowCount = 0;
        this.colCount = 0;
        this.data = null;
        if (null != inData) {
            for (int i = 0; i < inData.length; ++i) {
                if (null != inData[i]) {
                    if (inData[i].length <= this.colCount) continue;
                    this.colCount = inData[i].length;
                    continue;
                }
                throw new IllegalStateException(Messages.getErrorString("ChartTableModel.ERROR_0008_DATA_HAS_NULL_ELEMENTS"));
            }
            this.data = inData;
            this.rowCount = inData.length;
        }
    }

    @Override
    public void setRowMetadata(int row, Object key, Object value) throws IllegalArgumentException {
        if (row < 0) {
            throw new IllegalArgumentException("Row number cannot be less than zero.");
        }
        if (null == key) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0006_KEY_IS_NULL"));
        }
        this.metadataMap.put((Object)ROW, (Object)row, key, value);
    }

    @Override
    public Object getRowMetadata(int row, Object key) throws IllegalArgumentException {
        if (row < 0) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0003_ROW_NUM_LOWER_THAN_ZERO"));
        }
        if (null == key) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0005_KEY_IS_NULL"));
        }
        Object metadata = this.metadataMap.get((Object)ROW, (Object)row, key);
        return metadata;
    }

    @Override
    public void setColMetadata(int col, Object key, Object value) throws IllegalArgumentException {
        if (col < 0) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0001_COLUMN_NUM_LOWER_THAN_ZERO"));
        }
        if (null == key) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0006_KEY_IS_NULL"));
        }
        this.metadataMap.put((Object)COL, (Object)col, key, value);
    }

    @Override
    public Object getColMetadata(int col, Object key) throws IllegalArgumentException {
        if (col < 0) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0001_COLUMN_NUM_LOWER_THAN_ZERO"));
        }
        if (null == key) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0006_KEY_IS_NULL"));
        }
        Object metadata = this.metadataMap.get((Object)COL, (Object)col, key);
        return metadata;
    }

    @Override
    public void setCellMetadata(int row, int col, Object key, Object value) throws IllegalArgumentException {
        if (col < 0 || row < 0) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0007_ROW_COL_IS_OUT_OF_BOUNDS"));
        }
        if (null == key) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0006_KEY_IS_NULL"));
        }
        this.metadataMap.put((Object)CELL, (Object)row, (Object)col, key, value);
    }

    @Override
    public Object getCellMetadata(int row, int col, Object key) {
        if (row < 0 || col < 0) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0007_ROW_COL_IS_OUT_OF_BOUNDS"));
        }
        if (null == key) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartTableModel.ERROR_0006_KEY_IS_NULL"));
        }
        Object metadata = this.metadataMap.get((Object)CELL, (Object)row, (Object)col, key);
        return metadata;
    }

    @Override
    public int findRow(String rowName) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            String name = this.getRowName(i);
            if (!name.equals(rowName)) continue;
            return i;
        }
        return -1;
    }
}

