/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.css.parser.stylehandler;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.parser.stylehandler.ChartGradientColorReadHandler;
import org.pentaho.chart.css.parser.stylehandler.ChartGradientPositionReadHandler;
import org.pentaho.chart.css.parser.stylehandler.ChartGradientTypeReadHandler;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class ChartGradientReadHandler
implements CSSCompoundValueReadHandler {
    private final ChartGradientColorReadHandler gradientColor = new ChartGradientColorReadHandler();
    private final ChartGradientTypeReadHandler gradientType = new ChartGradientTypeReadHandler();
    private final ChartGradientPositionReadHandler gradientPos = new ChartGradientPositionReadHandler();

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{ChartStyleKeys.GRADIENT_COLOR, ChartStyleKeys.GRADIENT_TYPE, ChartStyleKeys.GRADIENT_START, ChartStyleKeys.GRADIENT_END};
    }

    public Map createValues(LexicalUnit unit) {
        HashMap<StyleKey, CSSValue> map;
        CSSValue color = null;
        if (unit != null && (color = this.gradientColor.createValue(null, unit)) != null) {
            unit = CSSValueFactory.parseComma((LexicalUnit)unit).getNextLexicalUnit();
        }
        CSSValue type = null;
        if (unit != null && (type = this.gradientType.createValue(null, unit)) != null) {
            unit = unit.getNextLexicalUnit();
        }
        CSSValue start = null;
        if (unit != null) {
            start = this.gradientPos.createValue(null, unit);
            unit = CSSValueFactory.parseComma((LexicalUnit)unit).getNextLexicalUnit();
        }
        CSSValue end = null;
        if (unit != null) {
            end = this.gradientPos.createValue(null, unit);
        }
        if (color != null && type != null && start != null && end != null) {
            map = new HashMap<StyleKey, CSSValue>();
            map.put(ChartStyleKeys.GRADIENT_COLOR, color);
            map.put(ChartStyleKeys.GRADIENT_TYPE, type);
            map.put(ChartStyleKeys.GRADIENT_START, start);
            map.put(ChartStyleKeys.GRADIENT_END, end);
        } else {
            map = null;
        }
        return map;
    }
}

