/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.core;

import java.util.ArrayList;
import org.pentaho.chart.core.AxisSeriesLinkInfo;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ChartDocument {
    private ChartElement rootElement;
    private ResourceManager resourceManager;
    private ResourceKey resourceKey;
    private ChartElement[] cachedSeriesElements = null;
    private long cachedSeriesElementModNumber = 0L;
    private ChartElement[] cachedGroupElements = null;
    private long cachedGroupElementModNumber = 0L;
    private ChartElement cachedPlotElement = null;
    private long cachedPlotElementModNumber = 0L;
    private ChartElement[] cachedAxisElements = null;
    private long cachedAxisElementModNumber = 0L;
    private boolean processedAxisElements = false;
    private AxisSeriesLinkInfo axisSeriesLinkInfo;

    public ChartDocument(ChartElement rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException("Root Element can not be null");
        }
        this.rootElement = rootElement;
    }

    public ChartElement getRootElement() {
        return this.rootElement;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setResourceKey(ResourceKey resourceKey) {
        this.resourceKey = resourceKey;
    }

    public long getModNumber() {
        return this.rootElement.getModNumber();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        if (this.rootElement == null) {
            sb.append(" [null]");
        } else {
            sb.append("\n").append(this.rootElement.toString("  "));
        }
        return sb.toString();
    }

    public boolean isCategorical() {
        boolean result = false;
        ChartElement root = this.getRootElement();
        if (root != null && "chart".equals(root.getTagName())) {
            result = ChartDocument.booleanAttributeValue(root, "categorical", false);
        }
        return result;
    }

    public boolean isByRow() {
        boolean result = false;
        ChartElement root = this.getRootElement();
        if (root != null && "chart".equals(root.getTagName())) {
            result = ChartDocument.booleanAttributeValue(root, "byrow", false);
        }
        return result;
    }

    protected static boolean booleanAttributeValue(ChartElement element, String attributeName, boolean defaultResult) {
        Object value;
        boolean result = defaultResult;
        if (element != null && (value = element.getAttribute(attributeName)) != null) {
            result = StringUtils.toBoolean((String)value.toString());
        }
        return result;
    }

    public ChartElement[] getSeriesChartElements() {
        long currentModNumber = this.getModNumber();
        if (this.cachedSeriesElementModNumber != currentModNumber) {
            this.cachedSeriesElements = this.getChartLevelElements("series");
            this.cachedSeriesElementModNumber = currentModNumber;
        }
        return this.cachedSeriesElements;
    }

    public ChartElement[] getGroupChartElements() {
        long currentModNumber = this.getModNumber();
        if (this.cachedGroupElementModNumber != currentModNumber) {
            this.cachedGroupElements = this.getChartLevelElements("group");
            this.cachedGroupElementModNumber = currentModNumber;
        }
        return this.cachedGroupElements;
    }

    public ChartElement getPlotElement() {
        long currentModNumber = this.getModNumber();
        if (this.cachedPlotElementModNumber != currentModNumber) {
            this.cachedPlotElement = this.getChartLevelElement("plot");
            this.cachedPlotElementModNumber = currentModNumber;
        }
        return this.cachedPlotElement;
    }

    public ChartElement[] getAxisElements() {
        long currentModNumber = this.getModNumber();
        if (this.cachedAxisElementModNumber != currentModNumber) {
            this.cachedAxisElements = this.getChartLevelElements("axis");
            this.cachedAxisElementModNumber = currentModNumber;
        }
        return this.cachedAxisElements;
    }

    public CSSValue getPlotOrientation() {
        ChartElement plotElement = this.getPlotElement();
        CSSValue value = null;
        if (plotElement != null) {
            value = plotElement.getStyle(ChartStyleKeys.ORIENTATION);
        }
        return value;
    }

    public ChartElement getChartLevelElement(String tagName) {
        ChartElement returnValue = null;
        if (this.rootElement != null && "chart".equals(this.rootElement.getTagName())) {
            for (ChartElement element = this.rootElement.getFirstChildItem(); element != null; element = element.getNextItem()) {
                if (!tagName.equals(element.getTagName())) continue;
                returnValue = element;
                break;
            }
        }
        return returnValue;
    }

    private ChartElement[] getChartLevelElements(String tagname) {
        ArrayList<ChartElement> elements = new ArrayList<ChartElement>();
        for (ChartElement element = this.rootElement.getFirstChildItem(); element != null; element = element.getNextItem()) {
            if (!tagname.equals(element.getTagName())) continue;
            elements.add(element);
        }
        return elements.toArray(new ChartElement[elements.size()]);
    }

    public AxisSeriesLinkInfo getAxisSeriesLinkInfo() {
        if (!this.processedAxisElements) {
            this.axisSeriesLinkInfo = new AxisSeriesLinkInfo();
            for (ChartElement element = this.rootElement.getFirstChildItem(); element != null; element = element.getNextItem()) {
                Object axisId;
                if ("axis".equals(element.getTagName())) {
                    axisId = element.getAttribute("id");
                    if (axisId == null) continue;
                    this.axisSeriesLinkInfo.setAxisElement(axisId, element);
                    continue;
                }
                if (!"series".equalsIgnoreCase(element.getTagName()) || (axisId = element.getAttribute("axis-id")) == null) continue;
                this.axisSeriesLinkInfo.setSeriesElements(axisId, element);
            }
            this.processedAxisElements = true;
        }
        return this.axisSeriesLinkInfo;
    }
}

