/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.pentaho.chart.core.ChartElement;

public class AxisSeriesLinkInfo {
    private final MultiKeyMap axisSeriesMap = MultiKeyMap.decorate((AbstractHashedMap)new LinkedMap());
    private final String RANGE = "range";
    private final String DOMAIN = "domain";
    private final int AXIS_ID_POSN = 0;
    private final int ELEMENT_TYPE_POSN = 1;

    public void setAxisElement(Object axisID, ChartElement axisElement) {
        if (axisID != null && axisElement != null) {
            this.axisSeriesMap.put(axisID, (Object)"axis", (Object)axisElement);
        }
    }

    public ChartElement getAxisElement(Object axisID) {
        if (axisID != null) {
            return (ChartElement)this.axisSeriesMap.get(axisID, (Object)"axis");
        }
        return null;
    }

    public void setSeriesElements(Object axisID, ChartElement seriesElement) {
        if (axisID != null && seriesElement != null) {
            ArrayList<ChartElement> seriesElementsList = (ArrayList<ChartElement>)this.axisSeriesMap.get(axisID, (Object)"series");
            if (seriesElementsList == null) {
                seriesElementsList = new ArrayList<ChartElement>();
            }
            seriesElementsList.add(seriesElement);
            this.axisSeriesMap.put(axisID, (Object)"series", seriesElementsList);
        }
    }

    public ArrayList<ChartElement> getSeriesElements(Object axisID) {
        if (axisID == null) {
            return null;
        }
        return (ArrayList)this.axisSeriesMap.get(axisID, (Object)"series");
    }

    public ArrayList<ChartElement> getRangeAxisElements() {
        return this.getAxisElements("range");
    }

    public ArrayList<ChartElement> getDomainAxisElements() {
        return this.getAxisElements("domain");
    }

    private ArrayList<ChartElement> getAxisElements(String axisType) {
        ArrayList<ChartElement> axisElements = null;
        Set setOfAxisSeriesMap = this.axisSeriesMap.entrySet();
        if (setOfAxisSeriesMap != null) {
            axisElements = new ArrayList<ChartElement>();
            for (Map.Entry currSetEntry : setOfAxisSeriesMap) {
                String currentType;
                Object axisID;
                ChartElement currentAxisElement;
                MultiKey key = (MultiKey)currSetEntry.getKey();
                if (!key.getKey(1).equals("axis") || (currentAxisElement = (ChartElement)this.axisSeriesMap.get(axisID = key.getKey(0), (Object)"axis")) == null || (currentType = (String)currentAxisElement.getAttribute("type")) == null || !axisType.equalsIgnoreCase(currentType)) continue;
                axisElements.add(currentAxisElement);
            }
        }
        return axisElements;
    }
}

