/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.chart.ChartFactory;
import org.pentaho.chart.IChartThemeFactory;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.model.Theme;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.color.ColorStyleKeys;

public abstract class AbstractChartThemeFactory
implements IChartThemeFactory {
    protected List<Theme> themes = null;

    protected AbstractChartThemeFactory() {
    }

    @Override
    public Theme getTheme(Theme.ChartTheme chartTheme) {
        Theme theme = null;
        if (chartTheme != null && chartTheme.ordinal() < this.getThemes().size()) {
            theme = this.getThemes().get(chartTheme.ordinal());
        }
        return theme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Theme> getThemes() {
        if (this.themes == null) {
            AbstractChartThemeFactory abstractChartThemeFactory = this;
            synchronized (abstractChartThemeFactory) {
                if (this.themes == null) {
                    this.themes = new ArrayList<Theme>();
                    for (File themeFile : this.getThemeFiles()) {
                        try {
                            ChartDocument themeDocument = ChartFactory.getChartDocument(themeFile.toURL(), true);
                            Theme chartTheme = new Theme();
                            chartTheme.setId(themeFile.getAbsolutePath());
                            for (ChartElement seriesTheme : themeDocument.getRootElement().findChildrenByName("series")) {
                                Color color;
                                LayoutStyle seriesStyle = seriesTheme.getLayoutStyle();
                                Color color2 = color = seriesStyle != null ? (Color)seriesStyle.getValue(ColorStyleKeys.COLOR) : null;
                                if (color == null) continue;
                                chartTheme.getColors().add(0xFFFFFF & color.getRGB());
                            }
                            this.themes.add(chartTheme);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return this.themes;
    }

    protected abstract List<File> getThemeFiles();
}

