/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.csv;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.beans.BogoPojo;
import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ColumnInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvTransformGeneratorException;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTOUtil;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceServiceAsync;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.CsvPhysicalStep;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.FileTransformStats;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.StageDataStep;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class CsvDatasource
extends AbstractXulEventHandler
implements IWizardDatasource {
    private ICsvDatasourceServiceAsync csvDatasourceService;
    private DatasourceModel datasourceModel;
    public FileTransformStats stats;
    private StageDataStep stageStep;
    private CsvPhysicalStep csvStep;
    private boolean finishable;
    private IXulAsyncDSWDatasourceService datasourceService;
    private IWizardModel wizardModel;

    public CsvDatasource(DatasourceModel datasourceModel, IXulAsyncDSWDatasourceService datasourceService, ICsvDatasourceServiceAsync csvDatasourceService) {
        this.datasourceModel = datasourceModel;
        this.datasourceService = datasourceService;
        this.csvDatasourceService = csvDatasourceService;
        ServiceDefTarget endpoint = (ServiceDefTarget)this.csvDatasourceService;
        endpoint.setServiceEntryPoint(this.getDatasourceURL());
        this.csvStep = new CsvPhysicalStep(datasourceModel, this, csvDatasourceService);
        this.stageStep = new StageDataStep(datasourceModel, this, csvDatasourceService);
        csvDatasourceService.gwtWorkaround(new BogoPojo(), new AsyncCallback<BogoPojo>(){

            public void onFailure(Throwable throwable) {
            }

            public void onSuccess(BogoPojo bogoPojo) {
                bogoPojo.getAggType();
            }
        });
    }

    public String getDatasourceURL() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "gwtrpc/CsvDatasourceService";
        }
        return moduleUrl + "CsvDatasourceService";
    }

    @Override
    public void activating() throws XulException {
        this.csvStep.activating();
        this.stageStep.activating();
    }

    @Override
    public void deactivating() {
        this.csvStep.deactivate();
        this.stageStep.deactivate();
    }

    @Override
    public void init(XulDomContainer container, IWizardModel wizardModel) throws XulException {
        this.wizardModel = wizardModel;
        container.addEventHandler((XulEventHandler)this.csvStep);
        container.addEventHandler((XulEventHandler)this.stageStep);
        this.csvStep.init(wizardModel);
        this.stageStep.init(wizardModel);
    }

    @Override
    @Bindable
    public String getName() {
        return MessageHandler.getString("csv.datasource.name");
    }

    @Override
    public List<IWizardStep> getSteps() {
        ArrayList<IWizardStep> steps = new ArrayList<IWizardStep>();
        steps.add(this.csvStep);
        steps.add(this.stageStep);
        return steps;
    }

    @Override
    public void onFinish(final XulServiceCallback<IDatasourceSummary> callback) {
        this.datasourceModel.getGuiStateModel().setDataStagingComplete(false);
        this.setColumnIdsToColumnNames();
        this.datasourceModel.getModelInfo().setStageTableName(this.datasourceModel.generateTableName());
        String tmpFileName = this.datasourceModel.getModelInfo().getFileInfo().getTmpFilename();
        String fileName = this.datasourceModel.getModelInfo().getFileInfo().getFilename();
        if (fileName == null && tmpFileName != null && tmpFileName.endsWith(".tmp")) {
            tmpFileName = tmpFileName.substring(0, tmpFileName.lastIndexOf(".tmp"));
            this.datasourceModel.getModelInfo().getFileInfo().setFilename(tmpFileName);
        }
        this.datasourceModel.getModelInfo().setDatasourceName(this.datasourceModel.getDatasourceName());
        this.csvDatasourceService.generateDomain(DatasourceDTOUtil.generateDTO(this.datasourceModel), new AsyncCallback<IDatasourceSummary>(){

            public void onFailure(Throwable th) {
                MessageHandler.getInstance().closeWaitingDialog();
                if (th instanceof CsvTransformGeneratorException) {
                    MessageHandler.getInstance().showErrorDetailsDialog(MessageHandler.getString("ERROR"), th.getMessage(), ((CsvTransformGeneratorException)th).getCauseMessage() + ((CsvTransformGeneratorException)th).getCauseStackTrace());
                } else {
                    MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), th.getMessage());
                }
                th.printStackTrace();
            }

            public void onSuccess(IDatasourceSummary stats) {
                CsvDatasource.this.stats = (FileTransformStats)stats;
                MessageHandler.getInstance().closeWaitingDialog();
                callback.success((Object)stats);
            }
        });
    }

    private void setColumnIdsToColumnNames() {
        for (ColumnInfo ci : this.datasourceModel.getModelInfo().getColumns()) {
            ci.setId(ci.getTitle());
        }
    }

    @Override
    public String getId() {
        return "CSV";
    }

    @Override
    public boolean isFinishable() {
        return this.finishable;
    }

    @Override
    public void setFinishable(boolean finishable) {
        boolean prevFinishable = this.finishable;
        this.finishable = finishable;
        this.firePropertyChange("finishable", prevFinishable, finishable);
    }

    @Override
    public void restoreSavedDatasource(Domain previousDomain, final XulServiceCallback<Void> callback) {
        String serializedDatasource = (String)((LogicalModel)previousDomain.getLogicalModels().get(0)).getProperty("datasourceModel");
        this.datasourceService.deSerializeModelState(serializedDatasource, new XulServiceCallback<DatasourceDTO>(){

            public void success(DatasourceDTO datasourceDTO) {
                DatasourceDTO.populateModel(datasourceDTO, CsvDatasource.this.datasourceModel);
                CsvDatasource.this.datasourceModel.getGuiStateModel().setDirty(false);
                CsvDatasource.this.wizardModel.setEditing(true);
                callback.success(null);
            }

            public void error(String s, Throwable throwable) {
                MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("DatasourceEditor.ERROR_0002_UNABLE_TO_SHOW_DIALOG", throwable.getLocalizedMessage()));
                callback.error(s, throwable);
            }
        });
    }

    @Override
    public void reset() {
        this.datasourceModel.clearModel();
    }
}

