/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.engine.core.system.PathBasedSystemSettings;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneApplicationContext;
import org.pentaho.platform.engine.core.system.objfac.StandaloneSpringPentahoObjectFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PentahoSystemHelper {
    private static final Log logger = LogFactory.getLog(PentahoSystemHelper.class);
    private static final String SYSTEM_FOLDER = "system";
    private static final String SOLUTION_PATH = "test-res/solution1/";
    private static final String ALT_SOLUTION_PATH = "test-res/solution11";
    private static final String PENTAHO_XML_PATH = "system/pentaho.xml";

    public static void init() {
        if (PentahoSystem.getInitializedOK()) {
            return;
        }
        try {
            PentahoSystem.setSystemSettingsService((ISystemSettings)new PathBasedSystemSettings());
            if (PentahoSystem.getApplicationContext() == null) {
                String inContainer;
                StandaloneApplicationContext applicationContext = new StandaloneApplicationContext(PentahoSystemHelper.getSolutionPath(), "");
                if (PentahoRequestContextHolder.getRequestContext() != null) {
                    applicationContext.setFullyQualifiedServerURL(PentahoRequestContextHolder.getRequestContext().getContextPath());
                }
                if ((inContainer = System.getProperty("incontainer", "false")).equalsIgnoreCase("false")) {
                    System.setProperty("java.naming.factory.initial", "org.osjava.sj.SimpleContextFactory");
                    System.setProperty("org.osjava.sj.root", PentahoSystemHelper.getSolutionPath() + "/system/simple-jndi");
                    System.setProperty("org.osjava.sj.delimiter", "/");
                }
                ApplicationContext springApplicationContext = PentahoSystemHelper.getSpringApplicationContext();
                StandaloneSpringPentahoObjectFactory pentahoObjectFactory = new StandaloneSpringPentahoObjectFactory();
                pentahoObjectFactory.init(null, (Object)springApplicationContext);
                PentahoSystem.registerObjectFactory((IPentahoObjectFactory)pentahoObjectFactory);
                springApplicationContext.getBean("pentahoSystemProxy");
                PentahoSystem.init((IApplicationContext)applicationContext);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static String getSolutionPath() {
        File file = new File("test-res/solution1/system/pentaho.xml");
        if (file.exists()) {
            System.out.println("File exist returning test-res/solution1/");
            return SOLUTION_PATH;
        }
        System.out.println("File does not exist returning test-res/solution11");
        return ALT_SOLUTION_PATH;
    }

    private static ApplicationContext getSpringApplicationContext() {
        String[] fns = new String[]{"pentahoObjects.spring.xml", "adminPlugins.xml", "sessionStartupActions.xml", "systemListeners.xml", "pentahoSystemConfig.xml"};
        GenericApplicationContext appCtx = new GenericApplicationContext();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appCtx);
        for (String fn : fns) {
            File f = new File(PentahoSystemHelper.getSolutionPath() + SYSTEM_FOLDER + "/" + fn);
            if (!f.exists()) continue;
            FileSystemResource fsr = new FileSystemResource(f);
            xmlReader.loadBeanDefinitions((Resource)fsr);
        }
        String[] beanNames = appCtx.getBeanDefinitionNames();
        System.out.println("Loaded Beans: ");
        for (String n : beanNames) {
            System.out.println("bean: " + n);
        }
        return appCtx;
    }
}

