/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessViewPermissionHandler;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.Authentication;

public class SimpleDataAccessViewPermissionHandler
implements IDataAccessViewPermissionHandler {
    private Log logger = LogFactory.getLog(SimpleDataAccessViewPermissionHandler.class);
    private IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);

    @Override
    public List<String> getPermittedRoleList(IPentahoSession session) {
        ArrayList<String> roleList = new ArrayList<String>();
        Authentication auth = SecurityHelper.getInstance().getAuthentication(session, true);
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String roles = null;
        try {
            roles = resLoader.getPluginSetting(this.getClass(), "settings/data-access-view-roles");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting plugin setting", (Throwable)e);
        }
        if (roles != null && roles.length() > 0) {
            String[] roleArr;
            for (String role : roleArr = roles.split(",")) {
                if (role == null || role.trim().length() <= 0) continue;
                roleList.add(role);
            }
        }
        return roleList;
    }

    @Override
    public List<String> getPermittedUserList(IPentahoSession session) {
        ArrayList<String> userList = new ArrayList<String>();
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String users = null;
        try {
            users = resLoader.getPluginSetting(this.getClass(), "settings/data-access-view-users");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting plugin setting", (Throwable)e);
        }
        if (users != null && users.length() > 0) {
            String[] userArr;
            for (String user : userArr = users.split(",")) {
                if (user == null || user.trim().length() <= 0) continue;
                userList.add(user);
            }
        }
        return userList;
    }

    @Override
    public int getDefaultAcls(IPentahoSession session) {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String defaultAclsAsString = null;
        int defaultAcls = -1;
        try {
            defaultAclsAsString = resLoader.getPluginSetting(this.getClass(), "settings/data-access-default-view-acls");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting plugin setting", (Throwable)e);
        }
        if (defaultAclsAsString != null && defaultAclsAsString.length() > 0) {
            defaultAcls = Integer.parseInt(defaultAclsAsString);
        }
        return defaultAcls;
    }

    @Override
    public boolean hasDataAccessViewPermission(IPentahoSession session) {
        return this.getPermittedUserList(session).size() > 0 || this.getPermittedRoleList(session).size() > 0;
    }
}

