/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.agilebi.modeler.IModelerMessages;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.gwt.BogoPojo;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.services.IModelerService;
import org.pentaho.agilebi.modeler.util.SpoonModelerMessages;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DSWDatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.InlineSqlModelerSource;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.plugin.action.kettle.KettleSystemListener;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;

public class ModelerService
extends PentahoBase
implements IModelerService {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(ModelerService.class);
    public static final String TMP_FILE_PATH = File.separatorChar + "system" + File.separatorChar + File.separatorChar + "tmp" + File.separatorChar;
    private SimpleDataAccessPermissionHandler dataAccessPermHandler = new SimpleDataAccessPermissionHandler();

    public Log getLogger() {
        return logger;
    }

    protected void initKettle() {
        try {
            KettleSystemListener.environmentInit((IPentahoSession)PentahoSessionHolder.getSession());
            if (!Props.isInitialized()) {
                Props.init((int)0);
            }
        }
        catch (KettleException e) {
            logger.error((Object)e);
            throw new IllegalStateException("Failed to initialize Kettle system");
        }
    }

    @Deprecated
    public Domain generateDomain(String connectionName, String tableName, String dbType, String query, String datasourceName) throws Exception {
        this.initKettle();
        try {
            DatabaseMeta database = AgileHelper.getDatabaseMeta();
            Object source = tableName != null ? new TableModelerSource(database, tableName, null, datasourceName) : new InlineSqlModelerSource(connectionName, dbType, query, datasourceName);
            return source.generateDomain();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception(e.getLocalizedMessage());
        }
    }

    public Domain generateCSVDomain(String tableName, String datasourceName) throws Exception {
        this.initKettle();
        try {
            DatabaseMeta database = AgileHelper.getDatabaseMeta();
            TableModelerSource source = new TableModelerSource(database, tableName, null, datasourceName);
            return source.generateDomain();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception(e.getLocalizedMessage());
        }
    }

    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return new BogoPojo();
    }

    public String serializeModels(Domain domain, String name) throws Exception {
        return this.serializeModels(domain, name, true);
    }

    public String serializeModels(final Domain domain, final String name, final boolean doOlap) throws Exception {
        String domainId = null;
        this.initKettle();
        if (this.dataAccessPermHandler.hasDataAccessPermission(PentahoSessionHolder.getSession())) {
            SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        IMetadataDomainRepository metadataDomainRep;
                        DSWDatasourceServiceImpl datasourceService = new DSWDatasourceServiceImpl();
                        ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper(), datasourceService.getGeoContext());
                        model.setModelName(name);
                        model.setDomain(domain);
                        domain.setId(name + ".xmi");
                        LogicalModel lModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
                        if (lModel == null) {
                            lModel = model.getLogicalModel(ModelerPerspective.REPORTING);
                        }
                        lModel.setProperty("AGILE_BI_GENERATED_SCHEMA", (Object)"TRUE");
                        lModel.setProperty("WIZARD_GENERATED_SCHEMA", (Object)"TRUE");
                        String catName = lModel.getName(Locale.getDefault().toString());
                        catName = catName.replace("_OLAP", "");
                        if (doOlap) {
                            lModel.setProperty("MondrianCatalogRef", (Object)catName);
                        }
                        if ((metadataDomainRep = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class)) != null) {
                            metadataDomainRep.storeDomain(model.getDomain(), true);
                        }
                        if (doOlap) {
                            MondrianModelExporter exporter = new MondrianModelExporter(lModel, Locale.getDefault().toString());
                            String mondrianSchema = exporter.createMondrianModelXML();
                            IPentahoSession session = PentahoSessionHolder.getSession();
                            if (session != null) {
                                session.setAttribute("MONDRIAN_SCHEMA_XML_CONTENT", (Object)mondrianSchema);
                                String catConnectStr = "Provider=mondrian;DataSource=" + ModelerService.getMondrianDatasource(domain);
                                ModelerService.this.addCatalog(catName, catConnectStr, session);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        return domainId;
    }

    public static String getMondrianDatasource(Domain domain) {
        return ((SqlPhysicalModel)domain.getPhysicalModels().get(0)).getId();
    }

    private void addCatalog(String catName, String catConnectStr, IPentahoSession session) {
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)session);
        String dsUrl = PentahoSystem.getApplicationContext().getBaseUrl();
        if (!dsUrl.endsWith("/")) {
            dsUrl = dsUrl + "/";
        }
        dsUrl = dsUrl + "Xmla";
        MondrianCatalog cat = new MondrianCatalog(catName, catConnectStr, "", new MondrianSchema(catName, new ArrayList()));
        mondrianCatalogService.addCatalog(cat, true, session);
    }

    public Domain loadDomain(String id) throws Exception {
        IMetadataDomainRepository repo = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class);
        return repo.getDomain(id);
    }

    static {
        try {
            ModelerMessagesHolder.setMessages((IModelerMessages)new SpoonModelerMessages());
        }
        catch (IllegalStateException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
    }
}

