/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataResource;
import org.pentaho.platform.web.http.api.resources.JaxbList;

@Path(value="/data-access/api/datasource/metadata")
public class MetadataDatasourceService
extends MetadataResource {
    @GET
    @Path(value="/ids")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public JaxbList<String> getMetadataDatasourceIds() {
        return super.listDomains();
    }

    @GET
    @Path(value="/{domainId : .+}/download")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export Metadata datasource."), @ResponseCode(code=500, condition="Failure to export Metadata datasource.")})
    public Response doGetMetadataFilesAsDownload(@PathParam(value="domainId") String domainId) {
        return super.downloadMetadata(domainId);
    }

    @POST
    @Path(value="/{domainId : .+}/remove")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource removed."), @ResponseCode(code=401, condition="User is not authorized to delete the Metadata datasource.")})
    public Response doRemoveMetadata(@PathParam(value="domainId") String domainId) {
        return super.deleteMetadata(domainId);
    }

    @Override
    @PUT
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource import succeeded. A response of:\n   *  2: Unspecified general error has occurred\n   *  3: Indicates successful import\n   *  9: Content already exists (use overwrite flag to force)\n   * 10: Import failed because publish is prohibited"), @ResponseCode(code=500, condition="Metadata datasource import failed.  Error code or message included in response entity")})
    public Response importMetadataDatasource(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo) {
        return super.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo);
    }
}

