/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.geo.GeoContextConfigProvider;
import org.pentaho.agilebi.modeler.geo.GeoContextFactory;
import org.pentaho.agilebi.modeler.geo.GeoContextPropertiesProvider;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.InlineEtlPhysicalModel;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.repository.InMemoryMetadataDomainRepository;
import org.pentaho.metadata.util.SQLModelGenerator;
import org.pentaho.metadata.util.SQLModelGeneratorException;
import org.pentaho.platform.dataaccess.datasource.beans.BogoPojo;
import org.pentaho.platform.dataaccess.datasource.beans.BusinessData;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.beans.SerializedResultSet;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.QueryValidationException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DebugDataAccessViewPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.DatasourceInMemoryServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryDatasourceSummary;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.util.messages.LocaleHelper;

public class InMemoryDSWDatasourceServiceImpl
implements IDSWDatasourceService {
    public static final IMetadataDomainRepository METADATA_DOMAIN_REPO = new InMemoryMetadataDomainRepository();
    private static final Log logger = LogFactory.getLog(InMemoryDSWDatasourceServiceImpl.class);
    public static final String DEFAULT_UPLOAD_FILEPATH_FILE_NAME = "debug_upload_filepath.properties";
    public static final String UPLOAD_FILE_PATH = "upload.file.path";
    private static final String BEFORE_QUERY = " SELECT * FROM (";
    private static final String AFTER_QUERY = ")";
    private IMetadataDomainRepository metadataDomainRepository = METADATA_DOMAIN_REPO;

    public InMemoryDSWDatasourceServiceImpl() {
        this(new ConnectionServiceImpl());
    }

    public InMemoryDSWDatasourceServiceImpl(ConnectionServiceImpl connectionService) {
    }

    @Override
    public boolean deleteLogicalModel(String domainId, String modelName) throws DatasourceServiceException {
        try {
            this.metadataDomainRepository.removeModel(domainId, modelName);
        }
        catch (DomainStorageException dse) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0017_UNABLE_TO_STORE_DOMAIN", domainId), (Throwable)dse);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0016_UNABLE_TO_STORE_DOMAIN", domainId), dse);
        }
        catch (DomainIdNullException dne) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceDelegate.ERROR_0019_DOMAIN_IS_NULL"), (Throwable)dne);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0019_DOMAIN_IS_NULL"), dne);
        }
        return true;
    }

    protected List<String> getPermittedRoleList() {
        DebugDataAccessViewPermissionHandler dataAccessViewPermHandler = new DebugDataAccessViewPermissionHandler();
        return dataAccessViewPermHandler.getPermittedRoleList(PentahoSessionHolder.getSession());
    }

    protected List<String> getPermittedUserList() {
        DebugDataAccessViewPermissionHandler dataAccessViewPermHandler = new DebugDataAccessViewPermissionHandler();
        return dataAccessViewPermHandler.getPermittedUserList(PentahoSessionHolder.getSession());
    }

    protected int getDefaultAcls() {
        DebugDataAccessViewPermissionHandler dataAccessViewPermHandler = new DebugDataAccessViewPermissionHandler();
        return dataAccessViewPermHandler.getDefaultAcls(PentahoSessionHolder.getSession());
    }

    private IPentahoResultSet executeQuery(String connectionName, String query, String previewLimit) throws QueryValidationException {
        SQLConnection sqlConnection = null;
        int limit = previewLimit != null && previewLimit.length() > 0 ? Integer.parseInt(previewLimit) : -1;
        try {
            sqlConnection = DatasourceInMemoryServiceHelper.getConnection(connectionName);
            sqlConnection.setMaxRows(limit);
            sqlConnection.setReadOnly(true);
            IPentahoResultSet iPentahoResultSet = sqlConnection.executeQuery(BEFORE_QUERY + query + AFTER_QUERY);
            return iPentahoResultSet;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new QueryValidationException(e.getLocalizedMessage(), e);
        }
        finally {
            if (sqlConnection != null) {
                sqlConnection.close();
            }
        }
    }

    @Override
    public SerializedResultSet doPreview(String connectionName, String query, String previewLimit) throws DatasourceServiceException {
        SerializedResultSet returnResultSet;
        try {
            this.executeQuery(connectionName, query, previewLimit);
            returnResultSet = DatasourceInMemoryServiceHelper.getSerializeableResultSet(connectionName, query, Integer.parseInt(previewLimit), null);
        }
        catch (QueryValidationException e) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        return returnResultSet;
    }

    public boolean testDataSourceConnection(String connectionName) throws DatasourceServiceException {
        Connection conn = null;
        try {
            conn = DatasourceInMemoryServiceHelper.getDataSourceConnection(connectionName);
        }
        catch (DatasourceServiceException dme) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connectionName), (Throwable)dme);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connectionName), dme);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connectionName), (Throwable)e);
                throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connectionName), e);
            }
        }
        return true;
    }

    @Override
    public BusinessData generateLogicalModel(String modelName, String connectionName, String dbType, String query, String previewLimit) throws DatasourceServiceException {
        try {
            this.executeQuery(connectionName, query, previewLimit);
            Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
            SerializedResultSet resultSet = DatasourceInMemoryServiceHelper.getSerializeableResultSet(connectionName, query, Integer.parseInt(previewLimit), null);
            SQLModelGenerator sqlModelGenerator = new SQLModelGenerator(modelName, connectionName, dbType, resultSet.getColumnTypes(), resultSet.getColumns(), query, securityEnabled, this.getPermittedRoleList(), this.getPermittedUserList(), this.getDefaultAcls(), "joe");
            Domain domain = sqlModelGenerator.generate();
            return new BusinessData(domain, resultSet.getData());
        }
        catch (SQLModelGeneratorException smge) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0016_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), (Throwable)smge);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0015_UNABLE_TO_GENERATE_MODEL"), smge);
        }
        catch (QueryValidationException e) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
    }

    public IMetadataDomainRepository getMetadataDomainRepository() {
        return this.metadataDomainRepository;
    }

    public void setMetadataDomainRepository(IMetadataDomainRepository metadataDomainRepository) {
        this.metadataDomainRepository = metadataDomainRepository;
    }

    @Override
    public BusinessData loadBusinessData(String domainId, String modelId) throws DatasourceServiceException {
        Domain domain = this.getMetadataDomainRepository().getDomain(domainId);
        List<List<String>> data = null;
        if (domain.getPhysicalModels().get(0) instanceof InlineEtlPhysicalModel) {
            InlineEtlPhysicalModel model = (InlineEtlPhysicalModel)domain.getPhysicalModels().get(0);
            data = DatasourceInMemoryServiceHelper.getCsvDataSample(model.getFileLocation(), model.getHeaderPresent(), model.getDelimiter(), model.getEnclosure(), 5);
        } else {
            SqlPhysicalModel model = (SqlPhysicalModel)domain.getPhysicalModels().get(0);
            String query = ((SqlPhysicalTable)model.getPhysicalTables().get(0)).getTargetTable();
            SerializedResultSet resultSet = DatasourceInMemoryServiceHelper.getSerializeableResultSet(model.getDatasource().getDatabaseName(), query, 5, null);
            data = resultSet.getData();
        }
        return new BusinessData(domain, data);
    }

    @Override
    public boolean saveLogicalModel(Domain domain, boolean overwrite) throws DatasourceServiceException {
        String domainName = domain.getId();
        try {
            this.getMetadataDomainRepository().storeDomain(domain, overwrite);
            return true;
        }
        catch (DomainStorageException dse) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0017_UNABLE_TO_STORE_DOMAIN", domainName), (Throwable)dse);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0016_UNABLE_TO_STORE_DOMAIN", domainName), dse);
        }
        catch (DomainAlreadyExistsException dae) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0018_DOMAIN_ALREADY_EXIST", domainName), (Throwable)dae);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0018_DOMAIN_ALREADY_EXIST", domainName), dae);
        }
        catch (DomainIdNullException dne) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0019_DOMAIN_IS_NULL"), (Throwable)dne);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0019_DOMAIN_IS_NULL"), dne);
        }
    }

    @Override
    public boolean hasPermission() {
        return true;
    }

    @Override
    public List<LogicalModelSummary> getLogicalModels(String context) throws DatasourceServiceException {
        ArrayList<LogicalModelSummary> logicalModelSummaries = new ArrayList<LogicalModelSummary>();
        for (String domainId : this.getMetadataDomainRepository().getDomainIds()) {
            Domain domain = this.getMetadataDomainRepository().getDomain(domainId);
            String locale = LocaleHelper.getLocale().toString();
            String[] locales = new String[domain.getLocales().size()];
            for (int i = 0; i < domain.getLocales().size(); ++i) {
                locales[i] = ((LocaleType)domain.getLocales().get(i)).getCode();
            }
            locale = LocaleHelper.getClosestLocale((String)locale, (String[])locales);
            for (LogicalModel model : domain.getLogicalModels()) {
                String vis = (String)model.getProperty("visible");
                if (vis != null) {
                    String[] visibleContexts = vis.split(",");
                    boolean visibleToContext = false;
                    for (String c : visibleContexts) {
                        if (!context.equals(c.trim())) continue;
                        visibleToContext = true;
                        break;
                    }
                    if (!visibleToContext) continue;
                }
                logicalModelSummaries.add(new LogicalModelSummary(domainId, model.getId(), model.getName().getString(locale)));
            }
        }
        return logicalModelSummaries;
    }

    @Override
    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return pojo;
    }

    @Override
    public String serializeModelState(DatasourceDTO dto) throws DatasourceServiceException {
        XStream xs = new XStream();
        return xs.toXML((Object)dto);
    }

    @Override
    public DatasourceDTO deSerializeModelState(String dtoStr) throws DatasourceServiceException {
        try {
            XStream xs = new XStream();
            return (DatasourceDTO)xs.fromXML(dtoStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DatasourceServiceException(e);
        }
    }

    @Override
    public List<String> listDatasourceNames() throws IOException {
        return new ArrayList<String>();
    }

    @Override
    public QueryDatasourceSummary generateQueryDomain(String name, String query, DatabaseConnection connection, DatasourceDTO datasourceDTO) throws DatasourceServiceException {
        ModelerWorkspace modelerWorkspace = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper(), this.getGeoContext());
        ModelerService modelerService = new ModelerService();
        modelerWorkspace.setModelName(name);
        try {
            Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
            SerializedResultSet resultSet = DatasourceInMemoryServiceHelper.getSerializeableResultSet(connection.getName(), query, Integer.parseInt("10"), null);
            SQLModelGenerator sqlModelGenerator = new SQLModelGenerator(name, connection.getName(), connection.getDatabaseType().getShortName(), resultSet.getColumnTypes(), resultSet.getColumns(), query, securityEnabled, this.getPermittedRoleList(), this.getPermittedUserList(), this.getDefaultAcls(), "joe");
            Domain domain = sqlModelGenerator.generate();
            modelerWorkspace.setDomain(domain);
            modelerWorkspace.getWorkspaceHelper().autoModelFlat(modelerWorkspace);
            modelerWorkspace.setModelName(datasourceDTO.getDatasourceName());
            modelerWorkspace.getWorkspaceHelper().populateDomain(modelerWorkspace);
            ((LogicalModel)domain.getLogicalModels().get(0)).setProperty("datasourceModel", (Object)this.serializeModelState(datasourceDTO));
            ((LogicalModel)domain.getLogicalModels().get(0)).setProperty("DatasourceType", (Object)"SQL-DS");
            QueryDatasourceSummary summary = new QueryDatasourceSummary();
            modelerService.serializeModels(domain, modelerWorkspace.getModelName());
            summary.setDomain(domain);
            return summary;
        }
        catch (SQLModelGeneratorException smge) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0016_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), (Throwable)smge);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0015_UNABLE_TO_GENERATE_MODEL"), smge);
        }
        catch (QueryValidationException e) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        catch (ModelerException e) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0016_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0015_UNABLE_TO_GENERATE_MODEL"), e);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0016_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("InMemoryDatasourceServiceImpl.ERROR_0015_UNABLE_TO_GENERATE_MODEL"), e);
        }
    }

    @Override
    public String getDatasourceIllegalCharacters() throws DatasourceServiceException {
        return "$<>?&#%^*()!~:;[]{}|/";
    }

    @Override
    public GeoContext getGeoContext() throws DatasourceServiceException {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File("test-res/geoContextSample.properties")));
            GeoContext geo = GeoContextFactory.create((GeoContextConfigProvider)new GeoContextPropertiesProvider(props));
            return geo;
        }
        catch (ModelerException e) {
            throw new DatasourceServiceException(e);
        }
        catch (FileNotFoundException e) {
            throw new DatasourceServiceException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

